/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.effect;

import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.brandonscore.utils.Utils;
import java.util.Random;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.MathHelper;

public class RenderEnergyBolt {
    public static void renderBoltBetween(Vec3D point1, Vec3D point2, double scale, double maxDeflection, int maxSegments, long boltSeed, boolean corona) {
        Tessellator tessellator = Tessellator.func_178181_a();
        Random random = new Random(boltSeed);
        GlStateManager.func_179090_x();
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)200.0f, (float)200.0f);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        double distance = Utils.getDistanceAtoB((Vec3D)point1, (Vec3D)point2);
        Vec3D dirVec = Vec3D.getDirectionVec((Vec3D)point1, (Vec3D)point2);
        Vec3D invDir = new Vec3D(1.0, 1.0, 1.0).subtract(dirVec);
        Vec3D[] vectors = new Vec3D[maxSegments / 2 + random.nextInt(maxSegments / 2)];
        vectors[0] = point1;
        vectors[vectors.length - 1] = point2;
        for (int i = 1; i < vectors.length - 1; ++i) {
            double pos = (double)i / (double)vectors.length * distance;
            Vec3D point = point1.copy();
            point.add(dirVec.copy().multiply(pos, pos, pos));
            double randX = (-0.5 + random.nextDouble()) * maxDeflection * invDir.x;
            double randY = (-0.5 + random.nextDouble()) * maxDeflection * invDir.y;
            double randZ = (-0.5 + random.nextDouble()) * maxDeflection * invDir.z;
            point.add(randX, randY, randZ);
            vectors[i] = point;
        }
        double rScale = scale * (0.5 + random.nextDouble() * 0.5);
        for (int i = 1; i < vectors.length; ++i) {
            RenderEnergyBolt.drawBoltSegment(tessellator, vectors[i - 1], vectors[i], (float)rScale);
        }
        if (corona) {
            int i;
            Vec3D[][] coronaVecs = new Vec3D[2 + random.nextInt(4)][2 + random.nextInt(3)];
            for (i = 0; i < coronaVecs.length; ++i) {
                coronaVecs[i][0] = point1;
                double d = distance / (2.0 + random.nextDouble() * 2.0);
                for (int v = 1; v < coronaVecs[i].length; ++v) {
                    double pos = (double)v / (double)coronaVecs[i].length * d;
                    Vec3D point = point1.copy();
                    point.add(dirVec.copy().multiply(pos, pos, pos));
                    double randX = (-0.5 + random.nextDouble()) * maxDeflection * invDir.x * 0.5;
                    double randY = (-0.5 + random.nextDouble()) * maxDeflection * invDir.y * 0.5;
                    double randZ = (-0.5 + random.nextDouble()) * maxDeflection * invDir.z * 0.5;
                    point.add(randX, randY, randZ);
                    coronaVecs[i][v] = point;
                }
            }
            for (i = 0; i < coronaVecs.length; ++i) {
                float f = 0.1f + random.nextFloat() * 0.5f;
                for (int v = 1; v < coronaVecs[i].length; ++v) {
                    RenderEnergyBolt.drawBoltSegment(tessellator, coronaVecs[i][v - 1], coronaVecs[i][v], (float)scale * f);
                }
            }
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179145_e();
        GlStateManager.func_179098_w();
    }

    public static void renderCorona(Vec3D source, Vec3D target, double scale, double maxDeflection, int maxSegments, long boltSeed) {
        int v;
        int i;
        Tessellator tessellator = Tessellator.func_178181_a();
        Random random = new Random(boltSeed);
        GlStateManager.func_179090_x();
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)200.0f, (float)200.0f);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        double distance = Utils.getDistanceAtoB((Vec3D)source, (Vec3D)target);
        Vec3D dirVec = Vec3D.getDirectionVec((Vec3D)source, (Vec3D)target);
        Vec3D invDir = new Vec3D(1.0, 1.0, 1.0).subtract(dirVec);
        Vec3D[][] coronaVecs = new Vec3D[2 + random.nextInt(maxSegments * 2)][2 + random.nextInt(2)];
        for (i = 0; i < coronaVecs.length; ++i) {
            coronaVecs[i][0] = source;
            Vec3D newDir = invDir.copy();
            newDir.multiply(0.9 + random.nextDouble() * 0.5, 0.9 + random.nextDouble() * 0.5, 0.9 + random.nextDouble() * 0.5);
            for (v = 1; v < coronaVecs[i].length; ++v) {
                double pos = (double)v / (double)coronaVecs[i].length * distance;
                Vec3D point = source.copy();
                point.add(dirVec.copy().multiply(pos, pos, pos));
                double randX = (-0.5 + random.nextDouble()) * maxDeflection * newDir.x;
                double randY = (-0.5 + random.nextDouble()) * maxDeflection * newDir.y;
                double randZ = (-0.5 + random.nextDouble()) * maxDeflection * newDir.z;
                point.add(randX, randY, randZ);
                coronaVecs[i][v] = point;
            }
        }
        for (i = 0; i < coronaVecs.length; ++i) {
            float f = 0.1f + random.nextFloat() * 0.5f;
            for (v = 1; v < coronaVecs[i].length; ++v) {
                RenderEnergyBolt.drawBoltSegment(tessellator, coronaVecs[i][v - 1], coronaVecs[i][v], (float)scale * f);
            }
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179145_e();
        GlStateManager.func_179098_w();
    }

    private static void drawBoltSegment(Tessellator tessellator, Vec3D p1, Vec3D p2, float scale) {
        VertexBuffer buffer = tessellator.func_178180_c();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)p1.x, (double)p1.y, (double)p1.z);
        double dist = Utils.getDistanceAtoB((Vec3D)p1, (Vec3D)p2);
        float xd = (float)(p1.x - p2.x);
        float yd = (float)(p1.y - p2.y);
        float zd = (float)(p1.z - p2.z);
        double var7 = MathHelper.func_76133_a((double)(xd * xd + zd * zd));
        float rotYaw = (float)(Math.atan2(xd, zd) * 180.0 / Math.PI);
        float rotPitch = (float)(Math.atan2(yd, var7) * 180.0 / Math.PI);
        GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(180.0f + rotYaw), (float)0.0f, (float)0.0f, (float)-1.0f);
        GlStateManager.func_179114_b((float)rotPitch, (float)1.0f, (float)0.0f, (float)0.0f);
        buffer.func_181668_a(5, DefaultVertexFormats.field_181706_f);
        for (int i = 0; i <= 9; ++i) {
            float f = ((float)i + 1.0f) / 9.0f;
            float verX = MathHelper.func_76126_a((float)((float)(i % 3) * (float)Math.PI * 2.0f / 3.0f)) * f * scale;
            float verZ = MathHelper.func_76134_b((float)((float)(i % 3) * (float)Math.PI * 2.0f / 3.0f)) * f * scale;
            buffer.func_181662_b((double)verX, dist, (double)verZ).func_181666_a(0.35f, 0.65f, 0.9f, 0.3f).func_181675_d();
            buffer.func_181662_b((double)verX, 0.0, (double)verZ).func_181666_a(0.35f, 0.65f, 0.9f, 0.3f).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
    }
}

