/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.model;

import codechicken.lib.model.loader.IBakedModelLoader;
import codechicken.lib.util.ItemNBTUtils;
import codechicken.lib.util.TransformUtils;
import com.brandon3055.brandonscore.lib.Set3;
import com.brandon3055.draconicevolution.client.model.tool.PerspectiveAwareToolModelBakery;
import com.brandon3055.draconicevolution.client.model.tool.ToolModelRegistry;
import com.brandon3055.draconicevolution.client.model.tool.ToolTransformOverride;
import com.brandon3055.draconicevolution.items.tools.WyvernBow;
import com.brandon3055.draconicevolution.utils.LogHelper;
import com.google.common.collect.ImmutableList;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.model.IModelState;

public class DEBakedModelProvider
implements IBakedModelLoader {
    public static final DEBakedModelProvider INSTANCE = new DEBakedModelProvider();

    public IBakedModelLoader.IModKeyProvider createKeyProvider() {
        return DEKeyProvider.INSTANCE;
    }

    public void addTextures(ImmutableList.Builder<ResourceLocation> builder) {
        for (Map.Entry<String, Set3<ResourceLocation, ResourceLocation, ResourceLocation>> entry : ToolModelRegistry.itemMap.entrySet()) {
            builder.add(entry.getValue().getA());
            builder.add(entry.getValue().getB());
        }
    }

    public IBakedModel bakeModel(String key) {
        ToolTransformOverride transformOverride = new ToolTransformOverride(key);
        if (key.contains("Bow")) {
            PerspectiveAwareToolModelBakery bakery = new PerspectiveAwareToolModelBakery(ToolModelRegistry.itemMap.get(key));
            return bakery.bake((IModelState)TransformUtils.DEFAULT_ITEM, transformOverride);
        }
        if (ToolModelRegistry.itemMap.containsKey(key)) {
            PerspectiveAwareToolModelBakery bakery = new PerspectiveAwareToolModelBakery(ToolModelRegistry.itemMap.get(key));
            return bakery.bake((IModelState)TransformUtils.DEFAULT_ITEM, transformOverride);
        }
        return null;
    }

    public static class DEKeyProvider
    implements IBakedModelLoader.IModKeyProvider {
        public static final DEKeyProvider INSTANCE = new DEKeyProvider();

        public String getMod() {
            return "draconicevolution".toLowerCase();
        }

        public String createKey(ItemStack stack) {
            if (ToolModelRegistry.itemMap.containsKey(stack.func_77973_b().getRegistryName().func_110623_a())) {
                return stack.func_77973_b().getRegistryName().func_110623_a();
            }
            if (stack.func_77973_b() instanceof WyvernBow) {
                return stack.func_77973_b().getRegistryName().func_110623_a() + "0" + ItemNBTUtils.getInteger((ItemStack)stack, (String)"DrawStage");
            }
            return null;
        }

        public String createKey(IBlockState state) {
            LogHelper.bigInfo("Thing! " + state, new Object[0]);
            return null;
        }
    }
}

