/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity;

import codechicken.lib.raytracer.ICuboidProvider;
import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.blocks.TileInventoryBase;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.brandonscore.network.PacketSyncableObject;
import com.brandon3055.brandonscore.network.wrappers.SyncableBool;
import com.brandon3055.brandonscore.network.wrappers.SyncableByte;
import com.brandon3055.brandonscore.network.wrappers.SyncableObject;
import com.brandon3055.brandonscore.utils.FeatureUtils;
import com.brandon3055.draconicevolution.DEFeatures;
import com.brandon3055.draconicevolution.blocks.PlacedItem;
import com.brandon3055.draconicevolution.lib.DESoundHandler;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TilePlacedItem
extends TileInventoryBase
implements ICuboidProvider {
    private LinkedList<ItemStack> stacks = new LinkedList();
    public final SyncableByte displayCount = new SyncableByte(1, true, false, true);
    public final SyncableBool toolDisplay = new SyncableBool(false, true, false, true);
    public final SyncableByte[] rotation = new SyncableByte[4];
    public EnumFacing facing = EnumFacing.NORTH;
    private boolean[] isBlock = new boolean[]{false, false, false, false};
    private IndexedCuboid6 blockBounds = new IndexedCuboid6((Object)0, new Cuboid6(0.0, 0.0, 0.0, 1.0, 1.0, 1.0));
    private List<IndexedCuboid6> indexedCuboids = new LinkedList<IndexedCuboid6>();
    private static final Transformation[] rotations = new Transformation[]{Rotation.sideRotations[3], Rotation.sideRotations[2], Rotation.sideRotations[0], Rotation.sideRotations[1], Rotation.quarterRotations[3], Rotation.quarterRotations[1]};

    public TilePlacedItem() {
        this.registerSyncableObject((SyncableObject)this.displayCount, true);
        this.registerSyncableObject((SyncableObject)this.toolDisplay, true);
        for (int i = 0; i < this.rotation.length; ++i) {
            this.rotation[i] = new SyncableByte(0, true, false, true);
            this.registerSyncableObject((SyncableObject)this.rotation[i], true);
        }
    }

    public void handleClick(int hit, EntityPlayer player) {
        if (player.func_70093_af()) {
            if (hit == -1) {
                return;
            }
            int index = hit - 1;
            if (index >= 0 && index < this.rotation.length) {
                this.rotation[index].value = (byte)(this.rotation[index].value + 1);
                DESoundHandler.playSoundFromServer(this.field_145850_b, Vec3D.getCenter((BlockPos)this.field_174879_c), SoundEvents.field_187632_cP, SoundCategory.PLAYERS, 1.0f, 0.9f + this.field_145850_b.field_73012_v.nextFloat() * 0.2f, false, 24.0);
                this.detectAndSendChanges();
            }
            return;
        }
        if (hit == 0) {
            for (int i = 0; i < this.func_70302_i_(); ++i) {
                FeatureUtils.dropItemNoDellay((ItemStack)this.func_70301_a(i), (World)this.field_145850_b, (Vector3)Vector3.fromEntity((Entity)player));
            }
            this.stacks.clear();
            this.field_145850_b.func_175698_g(this.field_174879_c);
        } else if (this.func_70301_a(hit - 1) != null) {
            FeatureUtils.dropItemNoDellay((ItemStack)this.func_70301_a(hit - 1), (World)this.field_145850_b, (Vector3)Vector3.fromEntity((Entity)player));
            this.func_70299_a(hit - 1, null);
        }
    }

    public void breakBlock() {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            FeatureUtils.dropItemNoDellay((ItemStack)this.func_70301_a(i), (World)this.field_145850_b, (Vector3)Vector3.fromTileCenter((TileEntity)this));
        }
        this.stacks.clear();
    }

    private void calculateBounds() {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        Cuboid6 box = new Cuboid6(0.5, 0.0, 0.5, 0.5, 0.0, 0.5).apply(Rotation.sideRotations[((EnumFacing)state.func_177229_b((IProperty)PlacedItem.FACING)).func_176745_a()].at(Vector3.center));
        int i = 0;
        for (Cuboid6 cuboid6 : this.indexedCuboids) {
            ++i;
            box.enclose(cuboid6);
        }
        if (this.facing.func_176743_c() == EnumFacing.AxisDirection.NEGATIVE) {
            box.setSide(this.facing.func_176745_a() ^ 1, 0.01);
        } else {
            box.setSide(this.facing.func_176745_a() ^ 1, 0.99);
        }
        if (i > 1) {
            EnumFacing.Axis axis = this.facing.func_176740_k();
            box.expand(new Vector3(axis == EnumFacing.Axis.X ? -0.02 : 0.03, axis == EnumFacing.Axis.Y ? -0.02 : 0.03, axis == EnumFacing.Axis.Z ? -0.02 : 0.03));
        }
        this.blockBounds = new IndexedCuboid6((Object)0, box);
    }

    private void recalculateCuboids() {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (state.func_177230_c() != DEFeatures.placedItem) {
            return;
        }
        this.indexedCuboids.clear();
        double scale = this.toolDisplay.value ? 0.2 : 0.32;
        Transformation rotation = rotations[((EnumFacing)state.func_177229_b((IProperty)PlacedItem.FACING)).func_176745_a()].at(Vector3.center);
        double offset = 0.225;
        double blockH = 0.36;
        double itemH = 0.03;
        if (this.displayCount.value == 1) {
            this.indexedCuboids.add(new IndexedCuboid6((Object)1, new Cuboid6(scale, scale, 0.0, 1.0 - scale, 1.0 - scale, this.isBlock[0] ? blockH : itemH).apply(rotation)));
        } else if (this.displayCount.value == 2) {
            this.indexedCuboids.add(new IndexedCuboid6((Object)1, new Cuboid6(scale, scale, 0.0, 1.0 - scale, 1.0 - scale, this.isBlock[0] ? blockH : itemH).apply((Transformation)new Translation(-offset, 0.0, 0.0).with(rotation))));
            this.indexedCuboids.add(new IndexedCuboid6((Object)2, new Cuboid6(scale, scale, 0.0, 1.0 - scale, 1.0 - scale, this.isBlock[1] ? blockH : itemH).apply((Transformation)new Translation(offset, 0.0, 0.0).with(rotation))));
        } else if (this.displayCount.value == 3) {
            this.indexedCuboids.add(new IndexedCuboid6((Object)1, new Cuboid6(scale, scale, 0.0, 1.0 - scale, 1.0 - scale, this.isBlock[0] ? blockH : itemH).apply((Transformation)new Translation(0.0, offset, 0.0).with(rotation))));
            this.indexedCuboids.add(new IndexedCuboid6((Object)2, new Cuboid6(scale, scale, 0.0, 1.0 - scale, 1.0 - scale, this.isBlock[1] ? blockH : itemH).apply((Transformation)new Translation(-offset, -offset, 0.0).with(rotation))));
            this.indexedCuboids.add(new IndexedCuboid6((Object)3, new Cuboid6(scale, scale, 0.0, 1.0 - scale, 1.0 - scale, this.isBlock[2] ? blockH : itemH).apply((Transformation)new Translation(offset, -offset, 0.0).with(rotation))));
        } else if (this.displayCount.value == 4) {
            this.indexedCuboids.add(new IndexedCuboid6((Object)1, new Cuboid6(scale, scale, 0.0, 1.0 - scale, 1.0 - scale, this.isBlock[0] ? blockH : itemH).apply((Transformation)new Translation(-offset, offset, 0.0).with(rotation))));
            this.indexedCuboids.add(new IndexedCuboid6((Object)2, new Cuboid6(scale, scale, 0.0, 1.0 - scale, 1.0 - scale, this.isBlock[1] ? blockH : itemH).apply((Transformation)new Translation(offset, offset, 0.0).with(rotation))));
            this.indexedCuboids.add(new IndexedCuboid6((Object)3, new Cuboid6(scale, scale, 0.0, 1.0 - scale, 1.0 - scale, this.isBlock[2] ? blockH : itemH).apply((Transformation)new Translation(-offset, -offset, 0.0).with(rotation))));
            this.indexedCuboids.add(new IndexedCuboid6((Object)4, new Cuboid6(scale, scale, 0.0, 1.0 - scale, 1.0 - scale, this.isBlock[3] ? blockH : itemH).apply((Transformation)new Translation(offset, -offset, 0.0).with(rotation))));
        }
    }

    public List<IndexedCuboid6> getCachedRenderCuboids() {
        if (this.indexedCuboids.isEmpty()) {
            this.recalculateCuboids();
        }
        return this.indexedCuboids;
    }

    public List<IndexedCuboid6> getIndexedCuboids() {
        this.recalculateCuboids();
        this.calculateBounds();
        ArrayList<IndexedCuboid6> list = new ArrayList<IndexedCuboid6>();
        list.add(this.blockBounds);
        list.addAll(this.indexedCuboids);
        return list;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.setSlot(index, stack);
        int count = 0;
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i) == null) continue;
            this.isBlock[i] = this.func_70301_a(i).func_77973_b() instanceof ItemBlock;
            ++count;
        }
        if (count == 0) {
            this.field_145850_b.func_175698_g(this.func_174877_v());
        } else {
            this.displayCount.value = (byte)count;
            ItemStack stack0 = this.func_70301_a(0);
            this.toolDisplay.value = count == 1 && stack0 != null && stack0.func_77973_b().func_77616_k(stack0);
            this.detectAndSendChanges();
            this.updateBlock();
        }
    }

    public int func_70302_i_() {
        return 4;
    }

    public ItemStack func_70301_a(int index) {
        return index >= 0 && index < this.stacks.size() ? this.stacks.get(index) : null;
    }

    private void setSlot(int index, ItemStack stack) {
        if (index < 0 || index >= 4) {
            return;
        }
        if (stack == null) {
            if (index < this.stacks.size()) {
                this.stacks.remove(index);
            }
        } else if (index < this.stacks.size()) {
            this.stacks.set(index, stack);
        } else {
            this.stacks.add(stack);
        }
        this.func_70296_d();
    }

    public void receiveSyncPacketFromServer(PacketSyncableObject packet) {
        super.receiveSyncPacketFromServer(packet);
        this.recalculateCuboids();
    }

    public void writeExtraNBT(NBTTagCompound compound) {
        super.writeExtraNBT(compound);
        compound.func_74774_a("Facing", (byte)this.facing.func_176745_a());
        for (int i = 0; i < this.isBlock.length; ++i) {
            compound.func_74757_a("IsBlock" + i, this.isBlock[i]);
        }
    }

    public void readExtraNBT(NBTTagCompound compound) {
        super.readExtraNBT(compound);
        this.facing = EnumFacing.func_82600_a((int)compound.func_74771_c("Facing"));
        for (int i = 0; i < this.isBlock.length; ++i) {
            this.isBlock[i] = compound.func_74767_n("IsBlock" + i);
        }
    }

    protected void writeInventoryToNBT(NBTTagCompound compound) {
        NBTTagList itemList = new NBTTagList();
        for (ItemStack stack : this.stacks) {
            if (stack == null) continue;
            itemList.func_74742_a((NBTBase)stack.func_77955_b(new NBTTagCompound()));
        }
        compound.func_74782_a("InventoryStacks", (NBTBase)itemList);
    }

    protected void readInventoryFromNBT(NBTTagCompound compound) {
        this.stacks.clear();
        NBTTagList itemList = compound.func_150295_c("InventoryStacks", 10);
        for (int i = 0; i < itemList.func_74745_c(); ++i) {
            this.stacks.add(ItemStack.func_77949_a((NBTTagCompound)itemList.func_150305_b(i)));
        }
    }
}

