/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity;

import cofh.api.energy.IEnergyReceiver;
import com.brandon3055.brandonscore.blocks.TileInventoryBase;
import com.brandon3055.brandonscore.network.wrappers.SyncableByte;
import com.brandon3055.brandonscore.network.wrappers.SyncableInt;
import com.brandon3055.brandonscore.network.wrappers.SyncableObject;
import com.brandon3055.draconicevolution.api.fusioncrafting.ICraftingPedestal;
import com.brandon3055.draconicevolution.api.fusioncrafting.IFusionCraftingInventory;
import com.brandon3055.draconicevolution.blocks.machines.CraftingPedestal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

public class TileCraftingPedestal
extends TileInventoryBase
implements IEnergyReceiver,
ICraftingPedestal {
    public final SyncableByte facing = new SyncableByte(0, true, false, true);
    private final SyncableInt energy = new SyncableInt(0, true, false);
    public IFusionCraftingInventory currentCraftingInventory = null;

    public TileCraftingPedestal() {
        this.setInventorySize(1);
        this.registerSyncableObject((SyncableObject)this.facing, true);
        this.registerSyncableObject((SyncableObject)this.energy, true);
    }

    public void updateBlock() {
        super.updateBlock();
        this.detectAndSendChanges();
    }

    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        this.validateCraftingInventory();
        if (this.currentCraftingInventory != null) {
            int maxRFPerTick = this.currentCraftingInventory.getRequiredCharge() / 300;
            int maxAccept = Math.min(maxReceive, Math.min(this.currentCraftingInventory.getRequiredCharge() - this.energy.value, maxRFPerTick));
            if (!simulate) {
                this.energy.value += maxAccept;
            }
            this.detectAndSendChanges();
            return maxAccept;
        }
        return 0;
    }

    public int getEnergyStored(EnumFacing from) {
        return this.energy.value;
    }

    public int getMaxEnergyStored(EnumFacing from) {
        return Integer.MAX_VALUE;
    }

    public boolean canConnectEnergy(EnumFacing from) {
        return from != EnumFacing.func_82600_a((int)this.facing.value);
    }

    @Override
    public int getPedestalTier() {
        String tier = (String)((Object)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)CraftingPedestal.TIER));
        return CraftingPedestal.TIER.toMeta(tier);
    }

    @Override
    public ItemStack getStackInPedestal() {
        return this.func_70301_a(0);
    }

    @Override
    public void setStackInPedestal(ItemStack stack) {
        this.func_70299_a(0, stack);
    }

    @Override
    public boolean setCraftingInventory(IFusionCraftingInventory craftingInventory) {
        if (this.validateCraftingInventory() && !this.field_145850_b.field_72995_K) {
            return false;
        }
        this.currentCraftingInventory = craftingInventory;
        return true;
    }

    @Override
    public EnumFacing getDirection() {
        return EnumFacing.func_82600_a((int)this.facing.value);
    }

    @Override
    public int getCharge() {
        return this.energy.value;
    }

    private boolean validateCraftingInventory() {
        if (this.getStackInPedestal() != null && this.currentCraftingInventory != null && this.currentCraftingInventory.craftingInProgress() && !((TileEntity)this.currentCraftingInventory).func_145837_r()) {
            return true;
        }
        this.currentCraftingInventory = null;
        return false;
    }

    @Override
    public void onCraft() {
        if (this.currentCraftingInventory != null) {
            this.energy.value = 0;
        }
    }

    public void func_70299_a(int index, ItemStack stack) {
        super.func_70299_a(index, stack);
        this.updateBlock();
    }
}

