/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.reactor.tileentity;

import com.brandon3055.brandonscore.blocks.TileBCBase;
import com.brandon3055.brandonscore.lib.Vec3I;
import com.brandon3055.brandonscore.network.wrappers.SyncableBool;
import com.brandon3055.brandonscore.network.wrappers.SyncableEnum;
import com.brandon3055.brandonscore.network.wrappers.SyncableObject;
import com.brandon3055.brandonscore.network.wrappers.SyncableString;
import com.brandon3055.brandonscore.network.wrappers.SyncableVec3I;
import com.brandon3055.brandonscore.utils.FacingUtils;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.blocks.reactor.tileentity.TileReactorComponent;
import com.brandon3055.draconicevolution.blocks.reactor.tileentity.TileReactorEnergyInjector;
import com.brandon3055.draconicevolution.blocks.reactor.tileentity.TileReactorStabilizer;
import com.brandon3055.draconicevolution.utils.LogHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class TileReactorCore
extends TileBCBase
implements ITickable {
    private final SyncableVec3I[] componentPositions = new SyncableVec3I[6];
    private final SyncableEnum<EnumFacing.Axis> stabilizerAxis = new SyncableEnum((Enum)EnumFacing.Axis.Y, true, false);
    public final SyncableBool structureValid = new SyncableBool(false, true, false);
    public final SyncableEnum<ReactorState> reactorState = new SyncableEnum((Enum)ReactorState.COLD, true, false);
    public final SyncableString structureError = new SyncableString("", true, false);

    public TileReactorCore() {
        for (int i = 0; i < this.componentPositions.length; ++i) {
            this.componentPositions[i] = new SyncableVec3I(new Vec3I(0, 0, 0), true, false);
            this.registerSyncableObject((SyncableObject)this.componentPositions[i]);
        }
        this.registerSyncableObject((SyncableObject)this.stabilizerAxis);
        this.registerSyncableObject((SyncableObject)this.structureValid);
        this.registerSyncableObject((SyncableObject)this.reactorState);
        this.registerSyncableObject((SyncableObject)this.structureError);
    }

    public boolean shouldRenderInPass(int pass) {
        return true;
    }

    public void func_73660_a() {
    }

    public void onComponentClicked(EntityPlayer player, TileReactorComponent component) {
        if (!this.field_145850_b.field_72995_K) {
            player.openGui((Object)DraconicEvolution.instance, 14, this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
        }
    }

    public void pokeCore(TileReactorComponent component, EnumFacing pokeFrom) {
        LogHelper.dev("Reactor: Core Poked");
        if (this.structureValid.value) {
            TileEntity tile;
            if (component instanceof TileReactorEnergyInjector && !component.isBound.value && (tile = this.field_145850_b.func_175625_s(this.getOffsetPos(this.componentPositions[pokeFrom.func_176745_a()].vec))) == this) {
                this.componentPositions[pokeFrom.func_176745_a()].vec = this.getOffsetVec(component.func_174877_v());
                component.bindToCore(this);
                LogHelper.dev("Reactor: Injector Added!");
            }
            this.validateStructure();
        } else {
            this.attemptInitialization();
        }
    }

    public void componentBroken(TileReactorComponent component, EnumFacing componentSide) {
        if (!this.structureValid.value) {
            return;
        }
        if (component instanceof TileReactorEnergyInjector) {
            LogHelper.dev("Reactor: Component broken! (Injector)");
            TileEntity tile = this.field_145850_b.func_175625_s(this.getOffsetPos(this.componentPositions[componentSide.func_176745_a()].vec));
            if (tile == component || tile == null) {
                LogHelper.dev("Reactor: -Removed");
                this.componentPositions[componentSide.func_176745_a()].vec.set(0, 0, 0);
            }
        } else if (this.reactorState.value != ReactorState.COLD) {
            LogHelper.dev("Reactor: Component broken, Structure Invalidated (Unsafe!!!!)");
            this.structureValid.value = false;
        } else {
            LogHelper.dev("Reactor: Component broken, Structure Invalidated (Safe)");
            this.structureValid.value = false;
        }
    }

    public void attemptInitialization() {
        LogHelper.dev("Reactor: Attempt Initialization");
        if (!this.findComponents()) {
            return;
        }
        if (!this.checkStabilizerAxis()) {
            return;
        }
        if (!this.bindComponents()) {
            return;
        }
        this.structureValid.value = true;
        LogHelper.dev("Reactor: Structure Successfully Initialized!\n");
    }

    public boolean findComponents() {
        LogHelper.dev("Reactor: Find Components");
        int stabilizersFound = 0;
        block0: for (EnumFacing facing : EnumFacing.field_82609_l) {
            this.componentPositions[facing.func_176745_a()].vec.set(0, 0, 0);
            for (int i = 1; i < 16; ++i) {
                BlockPos searchPos = this.field_174879_c.func_177967_a(facing, i);
                if (this.field_145850_b.func_175623_d(searchPos)) continue;
                TileEntity searchTile = this.field_145850_b.func_175625_s(searchPos);
                LogHelper.dev("Reactor: -Found: " + searchTile);
                if (searchTile instanceof TileReactorComponent && ((TileReactorComponent)searchTile).facing.value == facing.func_176734_d() && i >= 2) {
                    this.componentPositions[facing.func_176745_a()].vec = this.getOffsetVec(searchPos);
                }
                if (!(searchTile instanceof TileReactorStabilizer)) continue block0;
                ++stabilizersFound;
                continue block0;
            }
        }
        return stabilizersFound == 4;
    }

    public boolean checkStabilizerAxis() {
        LogHelper.dev("Reactor: Check Stabilizer Axis");
        for (EnumFacing.Axis axis : EnumFacing.Axis.values()) {
            boolean axisValid = true;
            for (EnumFacing facing : FacingUtils.getFacingsAroundAxis((EnumFacing.Axis)axis)) {
                TileEntity tile = this.field_145850_b.func_175625_s(this.getOffsetPos(this.componentPositions[facing.func_176745_a()].vec));
                if (tile instanceof TileReactorStabilizer && ((TileReactorStabilizer)tile).facing.value == facing.func_176734_d()) continue;
                axisValid = false;
                break;
            }
            if (!axisValid) continue;
            this.stabilizerAxis.value = axis;
            LogHelper.dev("Reactor: -Found Valid Axis: " + axis);
            return true;
        }
        return false;
    }

    public boolean bindComponents() {
        LogHelper.dev("Reactor: Binding Components");
        int stabilizersBound = 0;
        for (int i = 0; i < 6; ++i) {
            TileEntity tile = this.field_145850_b.func_175625_s(this.getOffsetPos(this.componentPositions[i].vec));
            if (!(tile instanceof TileReactorComponent)) continue;
            ((TileReactorComponent)tile).bindToCore(this);
            if (!(tile instanceof TileReactorStabilizer)) continue;
            ++stabilizersBound;
        }
        return stabilizersBound == 4;
    }

    public boolean validateStructure() {
        LogHelper.dev("Reactor: Validate Structure");
        for (EnumFacing facing : FacingUtils.getFacingsAroundAxis((EnumFacing.Axis)((EnumFacing.Axis)this.stabilizerAxis.value))) {
            BlockPos pos = this.getOffsetPos(this.componentPositions[facing.func_176745_a()].vec);
            if (!this.field_145850_b.func_175726_f(pos).func_177410_o()) {
                return true;
            }
            TileEntity tile = this.field_145850_b.func_175625_s(pos);
            LogHelper.dev("Reactor: Validate Stabilizer: " + tile);
            if (tile instanceof TileReactorStabilizer && ((TileReactorStabilizer)tile).getCorePos().equals((Object)this.field_174879_c)) continue;
            LogHelper.dev("Reactor: Structure Validation Failed!!!");
            return false;
        }
        LogHelper.dev("Reactor: Structure Validated!");
        return true;
    }

    private BlockPos getOffsetPos(Vec3I vec) {
        return this.field_174879_c.func_177973_b((Vec3i)vec.getPos());
    }

    private Vec3I getOffsetVec(BlockPos offsetPos) {
        return new Vec3I(this.field_174879_c.func_177973_b((Vec3i)offsetPos));
    }

    public static enum ReactorState {
        INVALID,
        COLD,
        WARMING_UP,
        AT_TEMP,
        RUNNING,
        COOLING;

    }
}

