/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.reactor.tileentity;

import com.brandon3055.brandonscore.blocks.TileBCBase;
import com.brandon3055.brandonscore.lib.Vec3I;
import com.brandon3055.brandonscore.network.wrappers.SyncableBool;
import com.brandon3055.brandonscore.network.wrappers.SyncableByte;
import com.brandon3055.brandonscore.network.wrappers.SyncableEnum;
import com.brandon3055.brandonscore.network.wrappers.SyncableObject;
import com.brandon3055.brandonscore.network.wrappers.SyncableVec3I;
import com.brandon3055.draconicevolution.blocks.reactor.tileentity.TileReactorCore;
import com.brandon3055.draconicevolution.utils.LogHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public abstract class TileReactorComponent
extends TileBCBase
implements ITickable {
    private final SyncableVec3I coreOffset = new SyncableVec3I(new Vec3I(0, 0, 0), true, false);
    public final SyncableEnum<EnumFacing> facing = new SyncableEnum((Enum)EnumFacing.UP, true, false);
    public final SyncableBool isBound = new SyncableBool(false, true, false);
    public final SyncableByte rsMode = new SyncableByte(0, true, false);
    public static final int RMODE_TEMP = 0;
    public static final int RMODE_TEMP_INV = 1;
    public static final int RMODE_FIELD = 2;
    public static final int RMODE_FIELD_INV = 3;
    public static final int RMODE_SAT = 4;
    public static final int RMODE_SAT_INV = 5;
    public static final int RMODE_FUEL = 6;
    public static final int RMODE_FUEL_INV = 7;

    public TileReactorComponent() {
        this.registerSyncableObject((SyncableObject)this.coreOffset);
        this.registerSyncableObject((SyncableObject)this.facing);
        this.registerSyncableObject((SyncableObject)this.isBound);
        this.registerSyncableObject((SyncableObject)this.rsMode);
    }

    public void func_73660_a() {
        this.detectAndSendChanges();
    }

    public void bindToCore(TileReactorCore core) {
        LogHelper.dev("Reactor-Comp: Bind To Core");
        this.isBound.value = true;
        this.coreOffset.vec = this.getCoreOffset(core.func_174877_v());
    }

    public void pokeCore() {
        TileReactorCore core;
        LogHelper.dev("Reactor-Comp: Try Poke Core");
        if (this.isBound.value && (core = this.checkAndGetCore()) != null) {
            core.pokeCore(this, ((EnumFacing)this.facing.value).func_176734_d());
            return;
        }
        LogHelper.dev("Reactor-Comp: Try Poke Core | Find");
        for (int i = 1; i < 16; ++i) {
            BlockPos searchPos = this.field_174879_c.func_177967_a((EnumFacing)this.facing.value, i);
            if (this.field_145850_b.func_175623_d(searchPos)) continue;
            TileEntity tile = this.field_145850_b.func_175625_s(searchPos);
            LogHelper.dev("Reactor-Comp: Try Poke Core | Found: " + tile);
            if (tile instanceof TileReactorCore && i > 1) {
                ((TileReactorCore)tile).pokeCore(this, ((EnumFacing)this.facing.value).func_176734_d());
            }
            return;
        }
    }

    public void func_145843_s() {
        this.isBound.value = false;
    }

    public void onPlaced() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.pokeCore();
    }

    public void onBroken() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        TileReactorCore core = this.checkAndGetCore();
        if (core != null) {
            core.componentBroken(this, ((EnumFacing)this.facing.value).func_176734_d());
        }
    }

    public void onActivated(EntityPlayer player) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.pokeCore();
        TileReactorCore core = this.checkAndGetCore();
        if (core != null) {
            core.onComponentClicked(player, this);
        }
    }

    protected BlockPos getCorePos() {
        return this.field_174879_c.func_177973_b((Vec3i)this.coreOffset.vec.getPos());
    }

    protected Vec3I getCoreOffset(BlockPos corePos) {
        return new Vec3I(this.field_174879_c.func_177973_b((Vec3i)corePos));
    }

    private TileReactorCore checkAndGetCore() {
        if (!this.isBound.value) {
            return null;
        }
        TileEntity tile = this.field_145850_b.func_175625_s(this.getCorePos());
        if (tile instanceof TileReactorCore) {
            return (TileReactorCore)tile;
        }
        if (this.field_145850_b.func_175726_f(this.getCorePos()).func_177410_o()) {
            this.func_145843_s();
        }
        return null;
    }
}

