/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.reactor;

import codechicken.lib.model.ModelRegistryHelper;
import codechicken.lib.render.item.IItemRenderer;
import codechicken.lib.util.RotationUtils;
import com.brandon3055.brandonscore.blocks.BlockBCore;
import com.brandon3055.brandonscore.blocks.properties.PropertyString;
import com.brandon3055.brandonscore.config.Feature;
import com.brandon3055.brandonscore.config.ICustomRender;
import com.brandon3055.brandonscore.config.ITileRegisterer;
import com.brandon3055.draconicevolution.blocks.reactor.tileentity.TileReactorComponent;
import com.brandon3055.draconicevolution.blocks.reactor.tileentity.TileReactorEnergyInjector;
import com.brandon3055.draconicevolution.blocks.reactor.tileentity.TileReactorStabilizer;
import com.brandon3055.draconicevolution.client.render.item.RenderItemReactorComponent;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileReactorComponent;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ReactorComponent
extends BlockBCore
implements ITileEntityProvider,
ITileRegisterer,
ICustomRender {
    public static final PropertyString TYPE = new PropertyString("type", new String[]{"stabilizer", "injector"});
    private static final AxisAlignedBB AABB_INJ_DOWN = new AxisAlignedBB(0.0, (double)0.885f, 0.0, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB AABB_INJ_UP = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0);
    private static final AxisAlignedBB AABB_INJ_NORTH = new AxisAlignedBB(0.0, 0.0, (double)0.885f, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB AABB_INJ_SOUTH = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.125);
    private static final AxisAlignedBB AABB_INJ_WEST = new AxisAlignedBB((double)0.885f, 0.0, 0.0, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB AABB_INJ_EAST = new AxisAlignedBB(0.0, 0.0, 0.0, 0.125, 1.0, 1.0);

    public ReactorComponent() {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)TYPE, (Comparable)((Object)"stabilizer")));
        this.setIsFullCube(false);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE});
    }

    public int func_176201_c(IBlockState state) {
        return ((String)((Object)state.func_177229_b((IProperty)TYPE))).equals("stabilizer") ? 0 : 1;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)TYPE, (Comparable)((Object)(meta == 0 ? "stabilizer" : "injector")));
    }

    public void func_149666_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        list.add(new ItemStack(item, 1, 0));
        list.add(new ItemStack(item, 1, 1));
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return meta == 0 ? new TileReactorStabilizer() : new TileReactorEnergyInjector();
    }

    public void registerTiles(String modidPrefix, String blockName) {
        GameRegistry.registerTileEntity(TileReactorStabilizer.class, (String)(blockName + "_stabilizer"));
        GameRegistry.registerTileEntity(TileReactorEnergyInjector.class, (String)(blockName + "_injector"));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        TileEntity tile = source.func_175625_s(pos);
        if (tile instanceof TileReactorEnergyInjector) {
            switch ((EnumFacing)((TileReactorEnergyInjector)tile).facing.value) {
                case DOWN: {
                    return AABB_INJ_DOWN;
                }
                case UP: {
                    return AABB_INJ_UP;
                }
                case NORTH: {
                    return AABB_INJ_NORTH;
                }
                case SOUTH: {
                    return AABB_INJ_SOUTH;
                }
                case WEST: {
                    return AABB_INJ_WEST;
                }
                case EAST: {
                    return AABB_INJ_EAST;
                }
            }
        }
        return super.func_185496_a(state, source, pos);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerRenderer(Feature feature) {
        ClientRegistry.bindTileEntitySpecialRenderer(TileReactorStabilizer.class, (TileEntitySpecialRenderer)new RenderTileReactorComponent());
        ClientRegistry.bindTileEntitySpecialRenderer(TileReactorEnergyInjector.class, (TileEntitySpecialRenderer)new RenderTileReactorComponent());
        ModelRegistryHelper.registerItemRenderer((Item)Item.func_150898_a((Block)this), (IItemRenderer)new RenderItemReactorComponent());
    }

    public boolean registerNormal(Feature feature) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        TileEntity te = world.func_175625_s(pos);
        EnumFacing facing = RotationUtils.getPlacedRotation((BlockPos)pos, (EntityLivingBase)placer);
        if (placer.func_70093_af()) {
            facing = facing.func_176734_d();
        }
        if (te instanceof TileReactorComponent) {
            ((TileReactorComponent)te).facing.value = facing;
            ((TileReactorComponent)te).onPlaced();
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileReactorComponent) {
            ((TileReactorComponent)te).onActivated(playerIn);
        }
        return true;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileReactorComponent) {
            ((TileReactorComponent)te).onBroken();
        }
        super.func_180663_b(worldIn, pos, state);
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"info.de.shiftReversePlaceLogic.txt", (Object[])new Object[0]));
    }
}

