/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.energynet.tileentity;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyHandler;
import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.brandonscore.api.IDataRetainerTile;
import com.brandon3055.brandonscore.blocks.TileBCBase;
import com.brandon3055.brandonscore.lib.ChatHelper;
import com.brandon3055.brandonscore.lib.IActivatableTile;
import com.brandon3055.brandonscore.lib.ITilePlaceListener;
import com.brandon3055.brandonscore.lib.Vec3B;
import com.brandon3055.brandonscore.network.PacketTileMessage;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.api.ICrystalLink;
import com.brandon3055.draconicevolution.blocks.energynet.EnergyCrystal;
import com.brandon3055.draconicevolution.blocks.energynet.rendering.ENetFXHandler;
import com.brandon3055.draconicevolution.blocks.energynet.rendering.ENetFXHandlerClient;
import com.brandon3055.draconicevolution.blocks.energynet.rendering.ENetFXHandlerServer;
import com.brandon3055.draconicevolution.client.render.effect.CrystalGLFXBase;
import com.brandon3055.draconicevolution.client.render.shaders.DEShaders;
import com.brandon3055.draconicevolution.handlers.DEEventHandler;
import com.brandon3055.draconicevolution.network.CrystalUpdateBatcher;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class TileCrystalBase
extends TileBCBase
implements IDataRetainerTile,
ITilePlaceListener,
ICrystalLink,
IEnergyHandler,
ITickable,
IActivatableTile {
    private static Map<EnergyCrystal.CrystalType, int[]> MAX_LINKS = new HashMap<EnergyCrystal.CrystalType, int[]>();
    protected int tick = 0;
    private int crystalTier = -1;
    protected LinkedList<Vec3B> linkedCrystals = new LinkedList();
    public LinkedList<int[]> transferRatesArrays = new LinkedList();
    public LinkedList<Byte> flowRates = new LinkedList();
    private LinkedList<BlockPos> linkedPosCache = null;
    protected EnergyStorage energyStorage = new EnergyStorage(0);
    protected ENetFXHandler fxHandler;
    boolean hashCached = false;
    int hashID = 0;
    public Map<Integer, Integer> containerEnergyFlow = new HashMap<Integer, Integer>();

    public TileCrystalBase() {
        this.setShouldRefreshOnBlockChange();
        this.fxHandler = DraconicEvolution.proxy.createENetFXHandler(this);
    }

    public void func_73660_a() {
        this.detectAndSendChanges();
        if (this.linkedCrystals.size() != this.transferRatesArrays.size() && !this.field_145850_b.field_72995_K) {
            this.rebuildTransferList();
        }
        this.balanceLinkedDevices();
        this.fxHandler.update();
        if (!this.field_145850_b.field_72995_K && DEEventHandler.serverTicks % 10 == 0) {
            this.flowRates.clear();
            for (int i = 0; i < this.linkedCrystals.size(); ++i) {
                this.flowRates.add(this.calculateFlow(i));
            }
            this.fxHandler.detectAndSendChanges();
        }
        ++this.tick;
    }

    public void balanceLinkedDevices() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        for (BlockPos linkedPos : this.getLinks()) {
            TileEntity linkedTile = this.field_145850_b.func_175625_s(linkedPos);
            if (!(linkedTile instanceof ICrystalLink)) {
                if (!this.field_145850_b.func_175726_f(linkedPos).func_177410_o()) continue;
                this.breakLink(linkedPos);
                return;
            }
            ICrystalLink linkedCrystal = (ICrystalLink)linkedTile;
            double thisCap = (double)this.getEnergyStored() / (double)this.getMaxEnergyStored();
            double thatCap = (double)linkedCrystal.getEnergyStored() / (double)linkedCrystal.getMaxEnergyStored();
            double diff = thisCap - thatCap;
            if (linkedCrystal.balanceMode() == 0 && thatCap < 1.0) {
                this.transferRatesArrays.get((int)this.linkedPosCache.indexOf((Object)linkedPos))[this.tick % 20] = this.balanceTransfer(linkedCrystal, 1.0 - thatCap);
                continue;
            }
            if (diff <= 0.0 || linkedCrystal.balanceMode() == 2) {
                this.transferRatesArrays.get((int)this.linkedPosCache.indexOf((Object)linkedPos))[this.tick % 20] = 0;
                continue;
            }
            this.transferRatesArrays.get((int)this.linkedPosCache.indexOf((Object)linkedPos))[this.tick % 20] = this.balanceTransfer(linkedCrystal, diff);
        }
    }

    protected int balanceTransfer(ICrystalLink sendTo, double capDiff) {
        double minFlow;
        int stored = this.getEnergyStored();
        if (stored <= 0) {
            return 0;
        }
        double transferCap = Math.min(this.getMaxEnergyStored(), sendTo.getMaxEnergyStored());
        int energyToEqual = (int)(capDiff * (double)sendTo.getMaxEnergyStored() / 2.1);
        double maxFlow = Math.min((double)energyToEqual, Math.min(transferCap, (double)(sendTo.getMaxEnergyStored() - sendTo.getEnergyStored())));
        double flowRate = Math.min(1.0, capDiff * 10.0);
        int transfer = (int)(flowRate * maxFlow);
        if ((double)transfer < (minFlow = 0.002 * transferCap)) {
            transfer = (int)Math.min(minFlow, (double)energyToEqual);
        }
        transfer = this.energyStorage.extractEnergy(transfer, false);
        sendTo.modifyEnergyStored(transfer);
        return transfer;
    }

    public void rebuildTransferList() {
        this.transferRatesArrays.clear();
        this.flowRates.clear();
        for (int i = 0; i < this.linkedCrystals.size(); ++i) {
            this.transferRatesArrays.add(new int[20]);
            this.flowRates.add((byte)0);
        }
    }

    @Override
    @Nonnull
    public List<BlockPos> getLinks() {
        if (this.linkedPosCache == null || this.linkedPosCache.size() != this.linkedCrystals.size()) {
            this.linkedPosCache = new LinkedList();
            for (Vec3B offset : this.linkedCrystals) {
                this.linkedPosCache.add(this.fromOffset(offset));
            }
            this.fxHandler.reloadConnections();
            this.updateBlock();
        }
        return this.linkedPosCache;
    }

    @Override
    public boolean binderUsed(EntityPlayer player, BlockPos linkTarget, EnumFacing sideClicked) {
        TileEntity te = this.field_145850_b.func_175625_s(linkTarget);
        if (!(te instanceof ICrystalLink)) {
            ChatHelper.indexedTrans((EntityPlayer)player, (String)"eNet.de.deviceInvalid.info", (TextFormatting)TextFormatting.RED, (int)-442611624, (Object[])new Object[0]);
            return false;
        }
        ICrystalLink target = (ICrystalLink)te;
        if (this.getLinks().contains(te.func_174877_v())) {
            this.breakLink(te.func_174877_v());
            target.breakLink(this.field_174879_c);
            ChatHelper.indexedTrans((EntityPlayer)player, (String)"eNet.de.linkBroken.info", (TextFormatting)TextFormatting.GREEN, (int)-442611624, (Object[])new Object[0]);
            return true;
        }
        if (this.getLinks().size() >= this.maxLinks()) {
            ChatHelper.indexedTrans((EntityPlayer)player, (String)"eNet.de.linkLimitReachedThis.info", (TextFormatting)TextFormatting.RED, (int)-442611624, (Object[])new Object[0]);
            return false;
        }
        if (target.getLinks().size() >= target.maxLinks()) {
            ChatHelper.indexedTrans((EntityPlayer)player, (String)"eNet.de.linkLimitReachedTarget.info", (TextFormatting)TextFormatting.RED, (int)-442611624, (Object[])new Object[0]);
            return false;
        }
        if (!Utils.inRangeSphere((BlockPos)this.field_174879_c, (BlockPos)linkTarget, (int)this.maxLinkRange())) {
            ChatHelper.indexedTrans((EntityPlayer)player, (String)"eNet.de.thisRangeLimit.info", (TextFormatting)TextFormatting.RED, (int)-442611624, (Object[])new Object[0]);
            return false;
        }
        if (!Utils.inRangeSphere((BlockPos)this.field_174879_c, (BlockPos)linkTarget, (int)target.maxLinkRange())) {
            ChatHelper.indexedTrans((EntityPlayer)player, (String)"eNet.de.targetRangeLimit.info", (TextFormatting)TextFormatting.RED, (int)-442611624, (Object[])new Object[0]);
            return false;
        }
        if (!target.createLink(this)) {
            ChatHelper.indexedTrans((EntityPlayer)player, (String)"eNet.de.linkFailedUnknown.info", (TextFormatting)TextFormatting.RED, (int)-442611624, (Object[])new Object[0]);
            return false;
        }
        if (!this.createLink(target)) {
            target.breakLink(this.field_174879_c);
            ChatHelper.indexedTrans((EntityPlayer)player, (String)"eNet.de.linkFailedUnknown.info", (TextFormatting)TextFormatting.RED, (int)-442611624, (Object[])new Object[0]);
            return false;
        }
        ChatHelper.indexedTrans((EntityPlayer)player, (String)"eNet.de.devicesLinked.info", (TextFormatting)TextFormatting.GREEN, (int)-442611624, (Object[])new Object[0]);
        return true;
    }

    @Override
    public boolean createLink(ICrystalLink otherCrystal) {
        Vec3B offset = this.getOffset(((TileEntity)otherCrystal).func_174877_v());
        this.linkedCrystals.add(offset);
        this.linkedPosCache = null;
        this.updateBlock();
        this.dirtyBlock();
        this.fxHandler.reloadConnections();
        return true;
    }

    @Override
    public void breakLink(BlockPos otherCrystal) {
        Vec3B offset = this.getOffset(otherCrystal);
        if (this.linkedCrystals.contains(offset)) {
            this.linkedCrystals.remove(offset);
        }
        this.linkedPosCache = null;
        this.updateBlock();
        this.dirtyBlock();
        this.fxHandler.reloadConnections();
    }

    public boolean canConnectEnergy(EnumFacing from) {
        return false;
    }

    public int getEnergyStored(EnumFacing from) {
        return this.getEnergyStored();
    }

    public int getMaxEnergyStored(EnumFacing from) {
        return this.getMaxEnergyStored();
    }

    @Override
    public int maxLinks() {
        return MAX_LINKS.get((Object)this.getType())[this.getTier()];
    }

    @Override
    public int maxLinkRange() {
        switch (this.getTier()) {
            case 0: {
                return 32;
            }
            case 1: {
                return 64;
            }
            case 2: {
                return 127;
            }
        }
        return 0;
    }

    @Override
    public int balanceMode() {
        return 1;
    }

    @Override
    public int getEnergyStored() {
        return this.energyStorage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored() {
        return this.energyStorage.getMaxEnergyStored();
    }

    @Override
    public void modifyEnergyStored(int energy) {
        this.energyStorage.modifyEnergyStored(energy);
    }

    public int getTier() {
        if (this.crystalTier == -1) {
            this.crystalTier = (Integer)this.getState(this.func_145838_q()).func_177229_b((IProperty)EnergyCrystal.TIER);
        }
        return this.crystalTier;
    }

    public abstract EnergyCrystal.CrystalType getType();

    private int getCapacityForTier(int tier) {
        switch (tier) {
            case 0: {
                return 4000000;
            }
            case 1: {
                return 16000000;
            }
            case 2: {
                return 64000000;
            }
        }
        return 0;
    }

    public Vec3B getOffset(BlockPos target) {
        return new Vec3B(this.field_174879_c.func_177973_b((Vec3i)target));
    }

    public BlockPos fromOffset(Vec3B targetOffset) {
        return this.field_174879_c.func_177973_b((Vec3i)targetOffset.getPos());
    }

    public ENetFXHandler getFxHandler() {
        return this.fxHandler;
    }

    public byte calculateFlow(int index) {
        long sum = 0L;
        for (int transfer : this.transferRatesArrays.get(index)) {
            sum += (long)transfer;
        }
        double rf = sum / 20L;
        double d = rf / ((double)this.getMaxEnergyStored() * 0.001 + rf);
        return (byte)(d * 255.0);
    }

    public void getLinkData(List<LinkData> data) {
        for (BlockPos target : this.getLinks()) {
            TileEntity tile = this.field_145850_b.func_175625_s(target);
            if (tile == null) continue;
            LinkData ld = new LinkData();
            ld.displayName = tile.getClass().getSimpleName();
            long sum = 0L;
            for (int transfer : this.transferRatesArrays.get(this.linkedPosCache.indexOf(target))) {
                sum += (long)transfer;
            }
            ld.transferPerTick = (int)(sum / 20L);
            ld.linkTarget = target;
            ld.data = "Data...";
            data.add(ld);
        }
    }

    public boolean onBlockActivated(IBlockState state, EntityPlayer player, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!this.field_145850_b.field_72995_K) {
            player.openGui((Object)DraconicEvolution.instance, 18, this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
        }
        return true;
    }

    public String getUnlocalizedName() {
        return "tile.draconicevolution:energy_crystal." + this.getType().func_176610_l() + "." + (this.getTier() == 0 ? "basic" : (this.getTier() == 1 ? "wyvern" : "draconic")) + ".name";
    }

    public boolean canRenderBreaking() {
        return true;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 0 || !DEShaders.useShaders();
    }

    @SideOnly(value=Side.CLIENT)
    public abstract CrystalGLFXBase createStaticFX();

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177982_a(1, 1, 1));
    }

    @SideOnly(value=Side.CLIENT)
    public void addDisplayData(List<String> displayList) {
        double charge = Utils.round((double)((double)this.getEnergyStored() / (double)this.getMaxEnergyStored() * 100.0), (double)100.0);
        displayList.add(TextFormatting.BLUE + I18n.func_135052_a((String)"eNet.de.hudCharge.info", (Object[])new Object[0]) + ": " + Utils.formatNumber((long)this.getEnergyStored()) + " / " + Utils.formatNumber((long)this.getMaxEnergyStored()) + " RF [" + charge + "%]");
        displayList.add(TextFormatting.GREEN + I18n.func_135052_a((String)"eNet.de.hudLinks.info", (Object[])new Object[0]) + ": " + this.getLinks().size() + " / " + this.maxLinks() + "");
    }

    public ENetFXHandler createServerFXHandler() {
        return new ENetFXHandlerServer(this);
    }

    @SideOnly(value=Side.CLIENT)
    public ENetFXHandler createClientFXHandler() {
        return new ENetFXHandlerClient(this);
    }

    public void writeExtraNBT(NBTTagCompound compound) {
        NBTTagList list = new NBTTagList();
        for (Vec3B vec : this.linkedCrystals) {
            list.func_74742_a((NBTBase)new NBTTagByteArray(new byte[]{vec.x, vec.y, vec.z}));
        }
        compound.func_74782_a("LinkedCrystals", (NBTBase)list);
        this.fxHandler.writeToNBT(compound);
        byte[] array = new byte[this.flowRates.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.flowRates.get(i);
        }
        compound.func_74773_a("FlowRates", array);
    }

    public void readExtraNBT(NBTTagCompound compound) {
        NBTTagList list = compound.func_150295_c("LinkedCrystals", 7);
        this.linkedCrystals.clear();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            byte[] data = ((NBTTagByteArray)list.func_179238_g(i)).func_150292_c();
            this.linkedCrystals.add(new Vec3B(data[0], data[1], data[2]));
        }
        if (this.linkedPosCache != null) {
            this.linkedPosCache.clear();
        }
        this.fxHandler.readFromNBT(compound);
        if (compound.func_74764_b("FlowRates")) {
            byte[] array = compound.func_74770_j("FlowRates");
            this.flowRates.clear();
            for (byte b : array) {
                this.flowRates.add(b);
            }
        }
    }

    public void writeRetainedData(NBTTagCompound dataCompound) {
        super.writeRetainedData(dataCompound);
        dataCompound.func_74774_a("Tier", (byte)this.getTier());
        this.energyStorage.writeToNBT(dataCompound);
    }

    public void readRetainedData(NBTTagCompound dataCompound) {
        super.readRetainedData(dataCompound);
        int cap = this.getCapacityForTier(dataCompound.func_74771_c("Tier"));
        this.energyStorage.setCapacity(cap).setMaxTransfer(cap);
        this.energyStorage.readFromNBT(dataCompound);
    }

    public void onTilePlaced(World world, BlockPos pos, EnumFacing placedAgainst, float hitX, float hitY, float hitZ, EntityPlayer placer, ItemStack stack) {
        int cap = this.getCapacityForTier(this.getTier());
        this.energyStorage.setCapacity(cap).setMaxTransfer(cap);
    }

    public int getIDHash() {
        if (!this.hashCached) {
            this.hashID = this.field_174879_c.hashCode();
            this.hashCached = true;
        }
        return this.hashID;
    }

    public void onLoad() {
        super.onLoad();
        if (!CrystalUpdateBatcher.ID_CRYSTAL_MAP.containsKey(this.getIDHash())) {
            CrystalUpdateBatcher.ID_CRYSTAL_MAP.put(this.getIDHash(), this.field_174879_c);
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (CrystalUpdateBatcher.ID_CRYSTAL_MAP.containsKey(this.getIDHash())) {
            CrystalUpdateBatcher.ID_CRYSTAL_MAP.remove(this.getIDHash());
        }
        this.fxHandler.tileUnload();
    }

    public void receiveBatchedUpdate(CrystalUpdateBatcher.BatchedCrystalUpdate update) {
        this.fxHandler.updateReceived(update);
    }

    public void detectAndSendContainerChanges(List<IContainerListener> listeners) {
        if (this.linkedCrystals.size() != this.transferRatesArrays.size() && !this.field_145850_b.field_72995_K) {
            this.rebuildTransferList();
        }
        List<BlockPos> positions = this.getLinks();
        NBTTagList list = new NBTTagList();
        for (BlockPos lPos : positions) {
            int index = positions.indexOf(lPos);
            if (this.containerEnergyFlow.containsKey(index) && this.containerEnergyFlow.get(index).intValue() == this.getLinkFlow(index)) continue;
            this.containerEnergyFlow.put(index, this.getLinkFlow(index));
            NBTTagCompound data = new NBTTagCompound();
            data.func_74774_a("I", (byte)index);
            data.func_74768_a("E", this.getLinkFlow(index));
            list.func_74742_a((NBTBase)data);
        }
        if (!list.func_82582_d()) {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74782_a("L", (NBTBase)list);
            this.sendUpdateToListeners(listeners, new PacketTileMessage((TileBCBase)this, 0, compound, false));
        } else if (this.containerEnergyFlow.size() > this.linkedCrystals.size()) {
            this.containerEnergyFlow.clear();
            this.sendUpdateToListeners(listeners, new PacketTileMessage((TileBCBase)this, 0, 0, false));
        }
    }

    public void sendUpdateToListeners(List<IContainerListener> listeners, PacketTileMessage packet) {
        for (IContainerListener listener : listeners) {
            if (!(listener instanceof EntityPlayerMP)) continue;
            BrandonsCore.network.sendTo((IMessage)packet, (EntityPlayerMP)listener);
        }
    }

    public void receivePacketFromServer(PacketTileMessage packet) {
        if (packet.getIndex() == 0 && packet.isNBT()) {
            NBTTagList list = packet.compound.func_150295_c("L", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound data = list.func_150305_b(i);
                this.containerEnergyFlow.put(Integer.valueOf(data.func_74771_c("I")), data.func_74762_e("E"));
            }
        }
        Iterator<Map.Entry<Integer, Integer>> i = this.containerEnergyFlow.entrySet().iterator();
    }

    public void receivePacketFromClient(PacketTileMessage packet, EntityPlayerMP client) {
        block4: {
            block3: {
                PlayerInteractEvent.RightClickBlock event = new PlayerInteractEvent.RightClickBlock((EntityPlayer)client, EnumHand.MAIN_HAND, client.func_184614_ca(), this.field_174879_c, EnumFacing.UP, Vec3d.field_186680_a);
                MinecraftForge.EVENT_BUS.post((Event)event);
                if (event.isCanceled()) {
                    return;
                }
                if (packet.getIndex() != 10) break block3;
                if (this.getLinks().size() <= packet.intValue || packet.intValue < 0) break block4;
                BlockPos target = this.getLinks().get(packet.intValue);
                this.breakLink(target);
                TileEntity targetTile = this.field_145850_b.func_175625_s(target);
                if (!(targetTile instanceof ICrystalLink)) break block4;
                ((ICrystalLink)targetTile).breakLink(this.field_174879_c);
                break block4;
            }
            if (packet.getIndex() == 20) {
                ArrayList<BlockPos> links = new ArrayList<BlockPos>(this.getLinks());
                for (BlockPos target : links) {
                    this.breakLink(target);
                    TileEntity targetTile = this.field_145850_b.func_175625_s(target);
                    if (!(targetTile instanceof ICrystalLink)) continue;
                    ((ICrystalLink)targetTile).breakLink(this.field_174879_c);
                }
            }
        }
    }

    public int getLinkFlow(int linkIndex) {
        if (this.transferRatesArrays.size() > linkIndex) {
            long sum = 0L;
            for (int i : this.transferRatesArrays.get(linkIndex)) {
                sum += (long)i;
            }
            return (int)(sum / 20L);
        }
        return 0;
    }

    static {
        MAX_LINKS.put(EnergyCrystal.CrystalType.RELAY, new int[]{8, 16, 32});
        MAX_LINKS.put(EnergyCrystal.CrystalType.CRYSTAL_IO, new int[]{2, 3, 4});
        MAX_LINKS.put(EnergyCrystal.CrystalType.WIRELESS, new int[]{4, 8, 16});
    }

    public static class LinkData {
        public String displayName;
        public int transferPerTick;
        public BlockPos linkTarget;
        public String data;

        public LinkData() {
        }

        public LinkData(String displayName, int transferPerTick, BlockPos linkTarget, String data) {
            this.displayName = displayName;
            this.transferPerTick = transferPerTick;
            this.linkTarget = linkTarget;
            this.data = data;
        }

        public void toBytes(ByteBuf buf) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.displayName);
            buf.writeInt(this.transferPerTick);
            buf.writeLong(this.linkTarget.func_177986_g());
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.data);
        }

        public static LinkData fromBytes(ByteBuf buf) {
            LinkData data = new LinkData();
            data.displayName = ByteBufUtils.readUTF8String((ByteBuf)buf);
            data.transferPerTick = buf.readInt();
            data.linkTarget = BlockPos.func_177969_a((long)buf.readLong());
            data.data = ByteBufUtils.readUTF8String((ByteBuf)buf);
            return data;
        }

        public int hashCode() {
            return super.hashCode();
        }
    }
}

