/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.raytracer.ICuboidProvider;
import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.raytracer.RayTracer;
import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.blocks.BlockBCore;
import com.brandon3055.brandonscore.config.Feature;
import com.brandon3055.brandonscore.config.ICustomRender;
import com.brandon3055.draconicevolution.blocks.tileentity.TilePlacedItem;
import com.brandon3055.draconicevolution.client.render.tile.RenderTilePlacedItem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PlacedItem
extends BlockBCore
implements ITileEntityProvider,
ICustomRender {
    public static final PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");

    public PlacedItem() {
        super(Material.field_151576_e);
        this.setHarvestLevel("pickaxe", 0);
        this.func_149711_c(1.5f).func_149752_b(10.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.UP));
        this.setIsFullCube(false);
    }

    public void func_149666_a(Item item, CreativeTabs tab, List<ItemStack> list) {
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TilePlacedItem();
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    public boolean registerNormal(Feature feature) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerRenderer(Feature feature) {
        ClientRegistry.bindTileEntitySpecialRenderer(TilePlacedItem.class, (TileEntitySpecialRenderer)new RenderTilePlacedItem());
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TilePlacedItem) {
            RayTraceResult hit = RayTracer.retraceBlock((World)world, (EntityPlayer)player, (BlockPos)pos);
            CuboidRayTraceResult subHitResult = RayTracer.rayTraceCuboidsClosest((Vector3)new Vector3(RayTracer.getStartVec((EntityPlayer)player)), (Vector3)new Vector3(RayTracer.getEndVec((EntityPlayer)player)), ((TilePlacedItem)tile).getIndexedCuboids(), (BlockPos)pos);
            if (subHitResult != null) {
                hit = subHitResult;
            } else if (hit == null) {
                return true;
            }
            ((TilePlacedItem)tile).handleClick(hit.subHit, player);
        }
        return true;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        TileEntity tile = source.func_175625_s(pos);
        if (tile instanceof ICuboidProvider) {
            return ((IndexedCuboid6)((ICuboidProvider)tile).getIndexedCuboids().get(0)).aabb();
        }
        return super.func_185496_a(state, source, pos);
    }

    public RayTraceResult func_180636_a(IBlockState state, World world, BlockPos pos, Vec3d start, Vec3d end) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof ICuboidProvider) {
            return RayTracer.rayTraceCuboidsClosest((Vec3d)start, (Vec3d)end, (List)((ICuboidProvider)tile).getIndexedCuboids(), (BlockPos)pos);
        }
        return super.func_180636_a(state, world, pos, start, end);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TilePlacedItem) {
            RayTraceResult hit = target;
            CuboidRayTraceResult subHitResult = RayTracer.rayTraceCuboidsClosest((Vector3)new Vector3(RayTracer.getStartVec((EntityPlayer)player)), (Vector3)new Vector3(RayTracer.getEndVec((EntityPlayer)player)), ((TilePlacedItem)tile).getIndexedCuboids(), (BlockPos)pos);
            if (subHitResult != null) {
                hit = subHitResult;
            } else if (hit == null) {
                return null;
            }
            if (hit.subHit > 0 && ((TilePlacedItem)tile).func_70301_a(hit.subHit - 1) != null) {
                return ((TilePlacedItem)tile).func_70301_a(hit.subHit - 1);
            }
        }
        return null;
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack heldStack) {
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TilePlacedItem) {
            ((TilePlacedItem)tile).breakBlock();
        }
        super.func_180663_b(world, pos, state);
    }
}

