/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.entity.model.anim;

import net.optifine.entity.model.anim.IExpression;

public enum EnumFunctionType {
    PLUS("+", 2, 0),
    MINUS("-", 2, 0),
    MUL("*", 2, 1),
    DIV("/", 2, 1),
    MOD("%", 2, 1),
    NEG("neg", 1),
    PI("pi", 0),
    SIN("sin", 1),
    COS("cos", 1),
    TAN("tan", 1),
    ATAN("atan", 1),
    ATAN2("atan2", 2),
    TORAD("torad", 1),
    TODEG("todeg", 1),
    MIN("min", 2),
    MAX("max", 2),
    CLAMP("clamp", 3),
    ABS("abs", 1),
    FLOOR("floor", 1),
    CEIL("ceil", 1),
    FRAC("frac", 1),
    ROUND("round", 1),
    SQRT("sqrt", 1),
    FMOD("fmod", 2),
    TIME("time", 0);

    private String name;
    private int countArguments;
    private int precedence;
    public static EnumFunctionType[] VALUES;

    private EnumFunctionType(String name, int countArguments) {
        this.name = name;
        this.countArguments = countArguments;
    }

    private EnumFunctionType(String name, int countArguments, int precedence) {
        this.name = name;
        this.countArguments = countArguments;
        this.precedence = precedence;
    }

    public String getName() {
        return this.name;
    }

    public int getCountArguments() {
        return this.countArguments;
    }

    public int getPrecedence() {
        return this.precedence;
    }

    public float eval(IExpression[] arguments) {
        if (arguments.length != this.countArguments) {
            Config.warn("Invalid number of arguments, function: " + (Object)((Object)this) + ", arguments: " + arguments.length + ", should be: " + this.countArguments);
            return 0.0f;
        }
        switch (this) {
            case PLUS: {
                return arguments[0].eval() + arguments[1].eval();
            }
            case MINUS: {
                return arguments[0].eval() - arguments[1].eval();
            }
            case MUL: {
                return arguments[0].eval() * arguments[1].eval();
            }
            case DIV: {
                return arguments[0].eval() / arguments[1].eval();
            }
            case MOD: {
                float modX = arguments[0].eval();
                float modY = arguments[1].eval();
                return modX - modY * (float)((int)(modX / modY));
            }
            case NEG: {
                return -arguments[0].eval();
            }
            case PI: {
                return (float)Math.PI;
            }
            case SIN: {
                return op.a((float)arguments[0].eval());
            }
            case COS: {
                return op.b((float)arguments[0].eval());
            }
            case TAN: {
                return (float)Math.tan(arguments[0].eval());
            }
            case ATAN: {
                return (float)Math.atan(arguments[0].eval());
            }
            case ATAN2: {
                return (float)op.b((double)arguments[0].eval(), (double)arguments[1].eval());
            }
            case TORAD: {
                return MathUtils.toRad(arguments[0].eval());
            }
            case TODEG: {
                return MathUtils.toDeg(arguments[0].eval());
            }
            case MIN: {
                return Math.min(arguments[0].eval(), arguments[1].eval());
            }
            case MAX: {
                return Math.max(arguments[0].eval(), arguments[1].eval());
            }
            case CLAMP: {
                return op.a((float)arguments[0].eval(), (float)arguments[1].eval(), (float)arguments[2].eval());
            }
            case ABS: {
                return op.e((float)arguments[0].eval());
            }
            case FLOOR: {
                return op.d((float)arguments[0].eval());
            }
            case CEIL: {
                return op.f((float)arguments[0].eval());
            }
            case FRAC: {
                return (float)op.h((double)arguments[0].eval());
            }
            case ROUND: {
                return Math.round(arguments[0].eval());
            }
            case SQRT: {
                return op.c((float)arguments[0].eval());
            }
            case FMOD: {
                float fmodX = arguments[0].eval();
                float fmodY = arguments[1].eval();
                return fmodX - fmodY * (float)op.d((float)(fmodX / fmodY));
            }
            case TIME: {
                bcx mc = bcx.z();
                bln world = mc.f;
                if (world == null) {
                    return 0.0f;
                }
                return (float)(world.P() % 24000L) + mc.aj();
            }
        }
        Config.warn("Unknown function type: " + (Object)((Object)this));
        return 0.0f;
    }

    public static EnumFunctionType parse(String str) {
        for (int i = 0; i < VALUES.length; ++i) {
            EnumFunctionType ef2 = VALUES[i];
            if (!ef2.getName().equals(str)) continue;
            return ef2;
        }
        return null;
    }

    static {
        VALUES = EnumFunctionType.values();
    }
}

