/*
 * Decompiled with CFR 0.152.
 */
import java.util.HashSet;
import java.util.Set;

public class DynamicLight {
    private rw entity = null;
    private double offsetY = 0.0;
    private double lastPosX = -2.147483648E9;
    private double lastPosY = -2.147483648E9;
    private double lastPosZ = -2.147483648E9;
    private int lastLightLevel = 0;
    private boolean underwater = false;
    private long timeCheckMs = 0L;
    private Set<cm> setLitChunkPos = new HashSet<cm>();
    private cm.a blockPosMutable = new cm.a();

    public DynamicLight(rw entity) {
        this.entity = entity;
        this.offsetY = entity.bq();
    }

    public void update(boh renderGlobal) {
        if (Config.isDynamicLightsFast()) {
            long timeNowMs = System.currentTimeMillis();
            if (timeNowMs < this.timeCheckMs + 500L) {
                return;
            }
            this.timeCheckMs = timeNowMs;
        }
        double posX = this.entity.p - 0.5;
        double posY = this.entity.q - 0.5 + this.offsetY;
        double posZ = this.entity.r - 0.5;
        int lightLevel = DynamicLights.getLightLevel(this.entity);
        double dx2 = posX - this.lastPosX;
        double dy = posY - this.lastPosY;
        double dz = posZ - this.lastPosZ;
        double delta = 0.1;
        if (Math.abs(dx2) <= delta && Math.abs(dy) <= delta && Math.abs(dz) <= delta && this.lastLightLevel == lightLevel) {
            return;
        }
        this.lastPosX = posX;
        this.lastPosY = posY;
        this.lastPosZ = posZ;
        this.lastLightLevel = lightLevel;
        this.underwater = false;
        bln world = renderGlobal.getWorld();
        if (world != null) {
            this.blockPosMutable.c(op.c((double)posX), op.c((double)posY), op.c((double)posZ));
            ars state = world.o((cm)this.blockPosMutable);
            akf block = state.t();
            this.underwater = block == akg.j;
        }
        HashSet<cm> setNewPos = new HashSet<cm>();
        if (lightLevel > 0) {
            ct dirX = (op.c((double)posX) & 0xF) >= 8 ? ct.f : ct.e;
            ct dirY = (op.c((double)posY) & 0xF) >= 8 ? ct.b : ct.a;
            ct dirZ = (op.c((double)posZ) & 0xF) >= 8 ? ct.d : ct.c;
            cm chunkPos = new cm(posX, posY, posZ);
            bqy chunk = renderGlobal.getRenderChunk(chunkPos);
            cm chunkPosX = this.getChunkPos(chunk, chunkPos, dirX);
            bqy chunkX = renderGlobal.getRenderChunk(chunkPosX);
            cm chunkPosZ = this.getChunkPos(chunk, chunkPos, dirZ);
            bqy chunkZ = renderGlobal.getRenderChunk(chunkPosZ);
            cm chunkPosXZ = this.getChunkPos(chunkX, chunkPosX, dirZ);
            bqy chunkXZ = renderGlobal.getRenderChunk(chunkPosXZ);
            cm chunkPosY = this.getChunkPos(chunk, chunkPos, dirY);
            bqy chunkY = renderGlobal.getRenderChunk(chunkPosY);
            cm chunkPosYX = this.getChunkPos(chunkY, chunkPosY, dirX);
            bqy chunkYX = renderGlobal.getRenderChunk(chunkPosYX);
            cm chunkPosYZ = this.getChunkPos(chunkY, chunkPosY, dirZ);
            bqy chunkYZ = renderGlobal.getRenderChunk(chunkPosYZ);
            cm chunkPosYXZ = this.getChunkPos(chunkYX, chunkPosYX, dirZ);
            bqy chunkYXZ = renderGlobal.getRenderChunk(chunkPosYXZ);
            this.updateChunkLight(chunk, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkX, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkZ, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkXZ, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkY, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkYX, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkYZ, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkYXZ, this.setLitChunkPos, setNewPos);
        }
        this.updateLitChunks(renderGlobal);
        this.setLitChunkPos = setNewPos;
    }

    private cm getChunkPos(bqy renderChunk, cm pos, ct facing) {
        if (renderChunk != null) {
            return renderChunk.a(facing);
        }
        return pos.a(facing, 16);
    }

    private void updateChunkLight(bqy renderChunk, Set<cm> setPrevPos, Set<cm> setNewPos) {
        if (renderChunk == null) {
            return;
        }
        bqv compiledChunk = renderChunk.h();
        if (compiledChunk != null && !compiledChunk.a()) {
            renderChunk.a(false);
        }
        cm pos = renderChunk.k().h();
        if (setPrevPos != null) {
            setPrevPos.remove(pos);
        }
        if (setNewPos != null) {
            setNewPos.add(pos);
        }
    }

    public void updateLitChunks(boh renderGlobal) {
        for (cm posOld : this.setLitChunkPos) {
            bqy chunkOld = renderGlobal.getRenderChunk(posOld);
            this.updateChunkLight(chunkOld, null, null);
        }
    }

    public rw getEntity() {
        return this.entity;
    }

    public double getLastPosX() {
        return this.lastPosX;
    }

    public double getLastPosY() {
        return this.lastPosY;
    }

    public double getLastPosZ() {
        return this.lastPosZ;
    }

    public int getLastLightLevel() {
        return this.lastLightLevel;
    }

    public boolean isUnderwater() {
        return this.underwater;
    }

    public double getOffsetY() {
        return this.offsetY;
    }

    public String toString() {
        return "Entity: " + this.entity + ", offsetY: " + this.offsetY;
    }
}

