/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.world;

import com.feed_the_beast.ftbl.api.IForgeTeam;
import com.feed_the_beast.ftbl.api.config.IConfigKey;
import com.feed_the_beast.ftbl.api.config.IConfigTree;
import com.feed_the_beast.ftbl.api.config.IConfigValue;
import com.feed_the_beast.ftbl.api.security.EnumTeamPrivacyLevel;
import com.feed_the_beast.ftbl.lib.EnumNameMap;
import com.feed_the_beast.ftbl.lib.config.ConfigKey;
import com.feed_the_beast.ftbl.lib.config.PropertyBool;
import com.feed_the_beast.ftbl.lib.config.PropertyEnum;
import com.feed_the_beast.ftbl.lib.config.PropertyEnumAbstract;
import com.feed_the_beast.ftbl.lib.io.Bits;
import com.feed_the_beast.ftbu.FTBLibIntegration;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraftforge.common.util.INBTSerializable;

public class FTBUTeamData
implements INBTSerializable<NBTBase> {
    private static final EnumTeamPrivacyLevel DEF_BLOCKS_LEVEL = EnumTeamPrivacyLevel.ALLIES;
    private static final IConfigKey DISABLE_EXPLOSIONS = new ConfigKey("ftbu.disable_explosions", (IConfigValue)new PropertyBool(false));
    private static final IConfigKey FAKE_PLAYERS = new ConfigKey("ftbu.fake_players", (IConfigValue)new PropertyBool(false));
    private static final IConfigKey BLOCKS = new ConfigKey("ftbu.blocks", (IConfigValue)new PropertyEnum(EnumTeamPrivacyLevel.NAME_MAP, (Enum)DEF_BLOCKS_LEVEL));
    private static final byte FLAG_DISABLE_EXPLOSIONS = 1;
    private static final byte FLAG_FAKE_PLAYERS = 2;
    private int flags = 0;

    @Nullable
    public static FTBUTeamData get(IForgeTeam t) {
        return (FTBUTeamData)t.getData(FTBLibIntegration.FTBU_DATA);
    }

    public FTBUTeamData() {
        this.setBlocksLevel(EnumTeamPrivacyLevel.ALLIES);
        this.flags |= 2;
    }

    public NBTBase serializeNBT() {
        return new NBTTagInt(this.flags);
    }

    public void deserializeNBT(NBTBase nbt0) {
        this.flags = nbt0 instanceof NBTTagCompound ? (int)((NBTTagCompound)nbt0).func_74771_c("Flags") : (int)((NBTPrimitive)nbt0).func_150290_f();
    }

    public void setBlocksLevel(@Nullable EnumTeamPrivacyLevel level) {
        if (level == null) {
            level = DEF_BLOCKS_LEVEL;
        }
        this.flags &= 0xF3;
        this.flags |= level.ordinal() << 2;
    }

    public EnumTeamPrivacyLevel getBlocks() {
        return EnumTeamPrivacyLevel.VALUES[this.flags >> 2 & 3];
    }

    public boolean disableExplosions() {
        return Bits.getFlag((int)this.flags, (int)1);
    }

    public boolean allowFakePlayers() {
        return Bits.getFlag((int)this.flags, (int)2);
    }

    public void addConfig(IConfigTree tree) {
        tree.add(DISABLE_EXPLOSIONS, (IConfigValue)new PropertyBool(true){

            public boolean getBoolean() {
                return FTBUTeamData.this.disableExplosions();
            }

            public void setBoolean(boolean v) {
                FTBUTeamData.this.flags = Bits.setFlag((int)FTBUTeamData.this.flags, (int)1, (boolean)v);
            }
        });
        tree.add(FAKE_PLAYERS, (IConfigValue)new PropertyBool(true){

            public boolean getBoolean() {
                return FTBUTeamData.this.allowFakePlayers();
            }

            public void setBoolean(boolean v) {
                FTBUTeamData.this.flags = Bits.setFlag((int)FTBUTeamData.this.flags, (int)2, (boolean)v);
            }
        });
        tree.add(BLOCKS, (IConfigValue)new PropertyEnumAbstract<EnumTeamPrivacyLevel>(){

            public EnumNameMap<EnumTeamPrivacyLevel> getNameMap() {
                return EnumTeamPrivacyLevel.NAME_MAP;
            }

            @Nullable
            public EnumTeamPrivacyLevel get() {
                return FTBUTeamData.this.getBlocks();
            }

            public void set(@Nullable EnumTeamPrivacyLevel enumLevel) {
                FTBUTeamData.this.setBlocksLevel(enumLevel);
            }
        });
    }
}

