/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.world;

import com.feed_the_beast.ftbl.api.IForgePlayer;
import com.feed_the_beast.ftbl.api.config.IConfigKey;
import com.feed_the_beast.ftbl.api.config.IConfigTree;
import com.feed_the_beast.ftbl.api.config.IConfigValue;
import com.feed_the_beast.ftbl.lib.config.ConfigKey;
import com.feed_the_beast.ftbl.lib.config.PropertyBool;
import com.feed_the_beast.ftbl.lib.io.Bits;
import com.feed_the_beast.ftbl.lib.math.BlockDimPos;
import com.feed_the_beast.ftbu.FTBLibIntegration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;

public class FTBUPlayerData
implements INBTSerializable<NBTBase> {
    private static final IConfigKey RENDER_BADGE = new ConfigKey("ftbu.render_badge", (IConfigValue)new PropertyBool(true));
    private static final IConfigKey DISABLE_GLOBAL_BADGE = new ConfigKey("ftbu.disable_global_badge", (IConfigValue)new PropertyBool(false));
    private static final IConfigKey CHAT_LINKS = new ConfigKey("ftbu.chat_links", (IConfigValue)new PropertyBool(true));
    public static final byte FLAG_RENDER_BADGE = 1;
    private static final byte FLAG_CHAT_LINKS = 2;
    public static final byte FLAG_DISABLE_GLOBAL_BADGE = 4;
    private byte flags = (byte)3;
    public BlockDimPos lastDeath;
    public BlockDimPos lastSafePos;
    public IForgePlayer lastChunkOwner;
    private Map<String, BlockDimPos> homes;

    @Nullable
    public static FTBUPlayerData get(IForgePlayer p) {
        return (FTBUPlayerData)p.getData(FTBLibIntegration.FTBU_DATA);
    }

    public NBTBase serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        if (this.flags != 0) {
            nbt.func_74774_a("Flags", this.flags);
        }
        if (this.homes != null && !this.homes.isEmpty()) {
            NBTTagCompound tag1 = new NBTTagCompound();
            for (Map.Entry<String, BlockDimPos> e : this.homes.entrySet()) {
                tag1.func_74783_a(e.getKey(), e.getValue().toIntArray());
            }
            nbt.func_74782_a("Homes", (NBTBase)tag1);
        }
        if (this.lastDeath != null) {
            nbt.func_74783_a("LastDeath", this.lastDeath.toIntArray());
        }
        return nbt;
    }

    public void deserializeNBT(NBTBase nbt0) {
        NBTTagCompound nbt = (NBTTagCompound)nbt0;
        this.flags = nbt.func_74771_c("Flags");
        if (nbt.func_74764_b("Homes")) {
            this.homes = new HashMap<String, BlockDimPos>();
            NBTTagCompound tag1 = (NBTTagCompound)nbt.func_74781_a("Homes");
            if (tag1 != null && !tag1.func_82582_d()) {
                for (String s1 : tag1.func_150296_c()) {
                    this.setHome(s1.toLowerCase(), new BlockDimPos(tag1.func_74759_k(s1)));
                }
            }
        } else {
            this.homes = null;
        }
        this.lastDeath = null;
        if (nbt.func_74764_b("LastDeath")) {
            int[] ai = nbt.func_74759_k("LastDeath");
            this.lastDeath = ai.length == 4 ? new BlockDimPos(ai) : null;
        }
    }

    public Collection<String> listHomes() {
        if (this.homes == null || this.homes.isEmpty()) {
            return Collections.emptySet();
        }
        return this.homes.keySet();
    }

    @Nullable
    public BlockDimPos getHome(String s) {
        return this.homes == null ? null : this.homes.get(s.toLowerCase());
    }

    public boolean setHome(String s, @Nullable BlockDimPos pos) {
        if (pos == null) {
            return this.homes != null && this.homes.remove(s) != null;
        }
        if (this.homes == null) {
            this.homes = new HashMap<String, BlockDimPos>();
        }
        return this.homes.put(s, pos.copy()) == null;
    }

    public int homesSize() {
        return this.homes == null ? 0 : this.homes.size();
    }

    public boolean renderBadge() {
        return Bits.getFlag((byte)this.flags, (byte)1);
    }

    public boolean chatLinks() {
        return Bits.getFlag((byte)this.flags, (byte)2);
    }

    public boolean disableGlobalBadge() {
        return Bits.getFlag((byte)this.flags, (byte)4);
    }

    public void addConfig(IConfigTree tree) {
        tree.add(RENDER_BADGE, (IConfigValue)new PropertyBool(true){

            public boolean getBoolean() {
                return FTBUPlayerData.this.renderBadge();
            }

            public void setBoolean(boolean v) {
                FTBUPlayerData.this.flags = Bits.setFlag((byte)FTBUPlayerData.this.flags, (byte)1, (boolean)v);
            }
        });
        tree.add(CHAT_LINKS, (IConfigValue)new PropertyBool(true){

            public boolean getBoolean() {
                return FTBUPlayerData.this.chatLinks();
            }

            public void setBoolean(boolean v) {
                FTBUPlayerData.this.flags = Bits.setFlag((byte)FTBUPlayerData.this.flags, (byte)2, (boolean)v);
            }
        });
        tree.add(DISABLE_GLOBAL_BADGE, (IConfigValue)new PropertyBool(true){

            public boolean getBoolean() {
                return FTBUPlayerData.this.disableGlobalBadge();
            }

            public void setBoolean(boolean v) {
                FTBUPlayerData.this.flags = Bits.setFlag((byte)FTBUPlayerData.this.flags, (byte)4, (boolean)v);
            }
        });
    }

    public int getClientFlags() {
        return Bits.setFlag((byte)this.flags, (byte)2, (boolean)false);
    }
}

