/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.net;

import com.feed_the_beast.ftbl.api.EnumTeamColor;
import com.feed_the_beast.ftbl.api.EnumTeamStatus;
import com.feed_the_beast.ftbl.api.IForgePlayer;
import com.feed_the_beast.ftbl.api.IForgeTeam;
import com.feed_the_beast.ftbl.lib.math.ChunkDimPos;
import com.feed_the_beast.ftbl.lib.net.LMNetworkWrapper;
import com.feed_the_beast.ftbl.lib.net.MessageToClient;
import com.feed_the_beast.ftbl.lib.util.LMNetUtils;
import com.feed_the_beast.ftbu.FTBLibIntegration;
import com.feed_the_beast.ftbu.api.chunks.IClaimedChunk;
import com.feed_the_beast.ftbu.api_impl.ChunkUpgrade;
import com.feed_the_beast.ftbu.api_impl.ClaimedChunkStorage;
import com.feed_the_beast.ftbu.client.FTBUClient;
import com.feed_the_beast.ftbu.gui.ClaimedChunks;
import com.feed_the_beast.ftbu.net.FTBUNetHandler;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.ChunkPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class MessageJMUpdate
extends MessageToClient<MessageJMUpdate> {
    private int startX;
    private int startZ;
    private Map<UUID, ClaimedChunks.Team> teams;
    private ClaimedChunks.Data[] chunkData;

    public MessageJMUpdate() {
    }

    public MessageJMUpdate(int sx, int sz, EntityPlayer player) {
        this.startX = sx;
        this.startZ = sz;
        IForgePlayer player1 = FTBLibIntegration.API.getUniverse().getPlayer((Object)player);
        IForgeTeam team = player1.getTeam();
        this.chunkData = new ClaimedChunks.Data[225];
        this.teams = new HashMap<UUID, ClaimedChunks.Team>();
        if (team != null) {
            ClaimedChunks.Team cteam = new ClaimedChunks.Team();
            cteam.ownerId = team.getOwner().getId();
            cteam.color = team.getColor();
            cteam.formattedName = team.getColor().getTextFormatting() + team.getTitle();
            cteam.isAlly = true;
            this.teams.put(cteam.ownerId, cteam);
        }
        for (int x1 = 0; x1 < 15; ++x1) {
            for (int z1 = 0; z1 < 15; ++z1) {
                IForgePlayer owner;
                ChunkDimPos pos = new ChunkDimPos(this.startX + x1, this.startZ + z1, player.field_71093_bK);
                ClaimedChunks.Data data = new ClaimedChunks.Data();
                IClaimedChunk chunk = ClaimedChunkStorage.INSTANCE.getChunk(pos);
                IForgePlayer iForgePlayer = owner = chunk == null ? null : chunk.getOwner();
                if (owner != null && owner.getTeam() != null) {
                    team = owner.getTeam();
                    data.team = this.teams.get(team.getOwner().getId());
                    if (data.team == null) {
                        data.team = new ClaimedChunks.Team();
                        data.team.ownerId = team.getOwner().getId();
                        data.team.color = team.getColor();
                        data.team.formattedName = team.getColor().getTextFormatting() + team.getTitle();
                        data.team.isAlly = team.hasStatus(player.func_146103_bH().getId(), EnumTeamStatus.ALLY);
                        this.teams.put(data.team.ownerId, data.team);
                    }
                    data.setHasUpgrade(ChunkUpgrade.CLAIMED, true);
                }
                this.chunkData[x1 + z1 * 15] = data;
            }
        }
    }

    public LMNetworkWrapper getWrapper() {
        return FTBUNetHandler.NET;
    }

    public void fromBytes(ByteBuf io) {
        this.startX = io.readInt();
        this.startZ = io.readInt();
        this.chunkData = new ClaimedChunks.Data[225];
        this.teams = new HashMap<UUID, ClaimedChunks.Team>();
        int s = io.readUnsignedShort();
        while (--s >= 0) {
            ClaimedChunks.Team team = new ClaimedChunks.Team();
            team.ownerId = LMNetUtils.readUUID((ByteBuf)io);
            team.formattedName = ByteBufUtils.readUTF8String((ByteBuf)io);
            team.color = EnumTeamColor.get((int)io.readUnsignedByte());
            this.teams.put(team.ownerId, team);
        }
        for (int i = 0; i < this.chunkData.length; ++i) {
            this.chunkData[i] = new ClaimedChunks.Data();
            this.chunkData[i].flags = io.readInt();
            if (!this.chunkData[i].hasUpgrade(ChunkUpgrade.CLAIMED)) continue;
            this.chunkData[i].team = this.teams.get(LMNetUtils.readUUID((ByteBuf)io));
        }
    }

    public void toBytes(ByteBuf io) {
        io.writeInt(this.startX);
        io.writeInt(this.startZ);
        io.writeShort(this.teams.size());
        for (ClaimedChunks.Team t : this.teams.values()) {
            LMNetUtils.writeUUID((ByteBuf)io, (UUID)t.ownerId);
            ByteBufUtils.writeUTF8String((ByteBuf)io, (String)t.formattedName);
            io.writeByte(t.color.ordinal());
        }
        for (ClaimedChunks.Data data : this.chunkData) {
            io.writeInt(data.flags);
            if (!data.hasUpgrade(ChunkUpgrade.CLAIMED)) continue;
            LMNetUtils.writeUUID((ByteBuf)io, (UUID)data.team.ownerId);
        }
    }

    public void onMessage(MessageJMUpdate m, EntityPlayer player) {
        if (FTBUClient.JM_INTEGRATION != null) {
            for (int z = 0; z < 15; ++z) {
                for (int x = 0; x < 15; ++x) {
                    FTBUClient.JM_INTEGRATION.chunkChanged(new ChunkPos(m.startX + x, m.startZ + z), m.chunkData[x + z * 15]);
                }
            }
        }
    }
}

