/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.net;

import com.feed_the_beast.ftbl.api.IForgePlayer;
import com.feed_the_beast.ftbl.lib.math.ChunkDimPos;
import com.feed_the_beast.ftbl.lib.math.MathHelperLM;
import com.feed_the_beast.ftbl.lib.net.LMNetworkWrapper;
import com.feed_the_beast.ftbl.lib.net.MessageToServer;
import com.feed_the_beast.ftbu.FTBLibIntegration;
import com.feed_the_beast.ftbu.api_impl.ClaimedChunkStorage;
import com.feed_the_beast.ftbu.handlers.FTBUPlayerEventHandler;
import com.feed_the_beast.ftbu.net.FTBUNetHandler;
import com.feed_the_beast.ftbu.net.MessageClaimedChunksUpdate;
import com.feed_the_beast.ftbu.world.FTBUUniverseData;
import com.mojang.authlib.GameProfile;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.ChunkPos;
import net.minecraftforge.server.permission.PermissionAPI;

public class MessageClaimedChunksModify
extends MessageToServer<MessageClaimedChunksModify> {
    public static final byte CLAIM = 0;
    public static final byte UNCLAIM = 1;
    public static final byte LOAD = 2;
    public static final byte UNLOAD = 3;
    private int startX;
    private int startZ;
    private byte action;
    private Collection<ChunkPos> chunks;

    public MessageClaimedChunksModify() {
    }

    public MessageClaimedChunksModify(int sx, int sz, byte a, Collection<ChunkPos> c) {
        this.startX = sx;
        this.startZ = sz;
        this.action = a;
        this.chunks = c;
    }

    public LMNetworkWrapper getWrapper() {
        return FTBUNetHandler.NET;
    }

    public void fromBytes(ByteBuf io) {
        this.startX = io.readInt();
        this.startZ = io.readInt();
        this.action = io.readByte();
        int s = io.readUnsignedByte();
        this.chunks = new ArrayList<ChunkPos>(s);
        while (--s >= 0) {
            int x = io.readInt();
            int z = io.readInt();
            this.chunks.add(new ChunkPos(x, z));
        }
    }

    public void toBytes(ByteBuf io) {
        io.writeInt(this.startX);
        io.writeInt(this.startZ);
        io.writeByte((int)this.action);
        io.writeByte(this.chunks.size());
        for (ChunkPos p : this.chunks) {
            io.writeInt(p.field_77276_a);
            io.writeInt(p.field_77275_b);
        }
    }

    public void onMessage(MessageClaimedChunksModify m, EntityPlayer player) {
        IForgePlayer p = FTBLibIntegration.API.getUniverse().getPlayer((Object)player);
        if (p == null || !PermissionAPI.hasPermission((GameProfile)player.func_146103_bH(), (String)"ftbu.claims.modify.self", null)) {
            return;
        }
        boolean canUnclaim = m.action == 1 && PermissionAPI.hasPermission((GameProfile)player.func_146103_bH(), (String)"ftbu.claims.modify.others", null);
        for (ChunkPos pos0 : m.chunks) {
            ChunkDimPos pos = new ChunkDimPos(pos0.field_77276_a, pos0.field_77275_b, player.field_71093_bK);
            switch (m.action) {
                case 0: {
                    FTBUUniverseData.claimChunk(p, pos);
                    break;
                }
                case 1: {
                    if (!canUnclaim && !p.equalsPlayer(ClaimedChunkStorage.INSTANCE.getChunkOwner(pos))) break;
                    FTBUUniverseData.unclaimChunk(p, pos);
                    break;
                }
                case 2: {
                    FTBUUniverseData.setLoaded(p, pos, true);
                    break;
                }
                case 3: {
                    FTBUUniverseData.setLoaded(p, pos, false);
                }
            }
        }
        FTBUPlayerEventHandler.updateChunkMessage((EntityPlayerMP)player, new ChunkDimPos(MathHelperLM.chunk((double)player.field_70165_t), MathHelperLM.chunk((double)player.field_70161_v), player.field_71093_bK));
        new MessageClaimedChunksUpdate(m.startX, m.startZ, player).sendTo(player);
    }
}

