/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.config;

import com.feed_the_beast.ftbl.api.IFTBLibRegistry;
import com.feed_the_beast.ftbl.api.config.IConfigValue;
import com.feed_the_beast.ftbl.lib.config.PropertyBool;
import com.feed_the_beast.ftbl.lib.config.PropertyByte;
import com.feed_the_beast.ftbl.lib.config.PropertyDouble;
import com.feed_the_beast.ftbl.lib.config.PropertyShort;
import com.feed_the_beast.ftbl.lib.config.PropertyString;

public class FTBUConfigBackups {
    public static final PropertyBool ENABLED = new PropertyBool(true);
    public static final PropertyBool SILENT = new PropertyBool(false);
    public static final PropertyShort BACKUPS_TO_KEEP = new PropertyShort(12, 0, 32000);
    public static final PropertyDouble BACKUP_TIMER = new PropertyDouble(2.0).setMin(0.05).setMax(600.0);
    public static final PropertyByte COMPRESSION_LEVEL = new PropertyByte(1, 0, 9);
    public static final PropertyString FOLDER = new PropertyString("");
    public static final PropertyBool DISPLAY_FILE_SIZE = new PropertyBool(true);
    public static final PropertyBool USE_SEPARATE_THREAD = new PropertyBool(true);

    public static void init(IFTBLibRegistry reg) {
        reg.addConfig("ftbu", "backups.enabled", (IConfigValue)ENABLED);
        reg.addConfig("ftbu", "backups.silent", (IConfigValue)SILENT);
        reg.addConfig("ftbu", "backups.backups_to_keep", (IConfigValue)BACKUPS_TO_KEEP).setInfo(new String[]{"The number of backup files to keep", "ore backups = more space used", "0 - Infinite"});
        reg.addConfig("ftbu", "backups.backup_timer", (IConfigValue)BACKUP_TIMER).setInfo(new String[]{"Timer in hours", "1.0 - backups every hour", "6.0 - backups every 6 hours", "0.5 - backups every 30 minutes"});
        reg.addConfig("ftbu", "backups.compression_level", (IConfigValue)COMPRESSION_LEVEL).setInfo(new String[]{"0 - Disabled (output = folders)", "1 - Best speed", "9 - Smallest file size"});
        reg.addConfig("ftbu", "backups.folder", (IConfigValue)FOLDER).setInfo(new String[]{"Absolute path to backups folder"});
        reg.addConfig("ftbu", "backups.display_file_size", (IConfigValue)DISPLAY_FILE_SIZE).setInfo(new String[]{"Prints (current size | total size) when backup is done"});
        reg.addConfig("ftbu", "backups.use_separate_thread", (IConfigValue)USE_SEPARATE_THREAD).setInfo(new String[]{"Run backup in a separated Thread (recommended)"});
    }

    public static long backupMillis() {
        return (long)(BACKUP_TIMER.getDouble() * 3600.0 * 1000.0);
    }
}

