/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.chiseledblock.serialization;

import com.google.common.base.Optional;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import mod.chiselsandbits.core.Log;
import mod.chiselsandbits.helpers.ModUtil;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;

public class StringStates {
    public static int getStateIDFromName(String name) {
        String[] parts = name.split("[?&]");
        try {
            parts[0] = URLDecoder.decode(parts[0], "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            Log.logError("Failed to reload Property from store data : " + name, e);
        }
        Block blk = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(parts[0]));
        if (blk == null || blk == Blocks.field_150350_a) {
            return 0;
        }
        IBlockState state = blk.func_176223_P();
        if (state == null) {
            return 0;
        }
        for (int x = 1; x < parts.length; ++x) {
            try {
                String[] nameval;
                if (parts[x].length() <= 0 || (nameval = parts[x].split("[=]")).length != 2) continue;
                nameval[0] = URLDecoder.decode(nameval[0], "UTF-8");
                nameval[1] = URLDecoder.decode(nameval[1], "UTF-8");
                state = StringStates.withState(state, blk, nameval);
                continue;
            }
            catch (Exception err) {
                Log.logError("Failed to reload Property from store data : " + name, err);
            }
        }
        return ModUtil.getStateId(state);
    }

    private static IBlockState withState(IBlockState state, Block blk, String[] nameval) {
        IProperty prop = blk.func_176194_O().func_185920_a(nameval[0]);
        if (prop == null) {
            Log.info(nameval[0] + " is not a valid property for " + Block.field_149771_c.func_177774_c((Object)blk));
            return state;
        }
        Optional pv = prop.func_185929_b(nameval[1]);
        if (pv.isPresent()) {
            return state.func_177226_a(prop, (Comparable)pv.get());
        }
        Log.info(nameval[1] + " is not a valid value of " + nameval[0] + " for " + Block.field_149771_c.func_177774_c((Object)blk));
        return state;
    }

    public static String getNameFromStateID(int key) {
        IBlockState state = ModUtil.getStateById(key);
        Block blk = state.func_177230_c();
        String sname = "air?";
        try {
            StringBuilder stateName = new StringBuilder(URLEncoder.encode(((ResourceLocation)Block.field_149771_c.func_177774_c((Object)blk)).toString(), "UTF-8"));
            stateName.append('?');
            boolean first = true;
            for (IProperty P : state.func_177227_a()) {
                if (!first) {
                    stateName.append('&');
                }
                first = false;
                Comparable propVal = (Comparable)state.func_177228_b().get((Object)P);
                String saveAs = propVal instanceof IStringSerializable ? ((IStringSerializable)propVal).func_176610_l() : propVal.toString();
                stateName.append(URLEncoder.encode(P.func_177701_a(), "UTF-8"));
                stateName.append('=');
                stateName.append(URLEncoder.encode(saveAs, "UTF-8"));
            }
            sname = stateName.toString();
        }
        catch (UnsupportedEncodingException e) {
            Log.logError("Failed to Serialize State", e);
        }
        return sname;
    }
}

