/*
 * Decompiled with CFR 0.152.
 */
package squeek.wailaharvestability.helpers;

import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeHooks;

public class ToolHelper {
    public static Set<String> getToolClassesOf(ItemStack tool) {
        return tool.func_77973_b().getToolClasses(tool);
    }

    public static boolean isToolOfClass(ItemStack tool, String toolClass) {
        return ToolHelper.getToolClassesOf(tool).contains(toolClass);
    }

    public static boolean toolHasAnyToolClass(ItemStack tool) {
        return !ToolHelper.getToolClassesOf(tool).isEmpty();
    }

    public static boolean isToolEffectiveAgainst(ItemStack tool, IBlockAccess blockAccess, BlockPos blockPos, String effectiveToolClass) {
        return ForgeHooks.isToolEffective((IBlockAccess)blockAccess, (BlockPos)blockPos, (ItemStack)tool) || (ToolHelper.toolHasAnyToolClass(tool) ? ToolHelper.isToolOfClass(tool, effectiveToolClass) : tool.func_77973_b().func_150893_a(tool, blockAccess.func_180495_p(blockPos)) > 1.5f);
    }

    public static boolean canToolHarvestLevel(ItemStack tool, IBlockAccess blockAccess, BlockPos blockPos, EntityPlayer player, int harvestLevel) {
        IBlockState state = blockAccess.func_180495_p(blockPos);
        state = state.func_177230_c().func_176221_a(state, blockAccess, blockPos);
        return tool != null && tool.func_77973_b().getHarvestLevel(tool, state.func_177230_c().getHarvestTool(state), player, state) >= harvestLevel;
    }

    public static boolean canToolHarvestBlock(ItemStack tool, IBlockState blockState) {
        return blockState.func_185904_a().func_76229_l() || tool.func_150998_b(blockState);
    }
}

