/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.hatchery.item;

import com.gendeathrow.hatchery.Hatchery;
import com.gendeathrow.hatchery.core.init.ModBlocks;
import com.gendeathrow.hatchery.core.init.ModFluids;
import com.gendeathrow.hatchery.util.FluidHandlerSprayer;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.IGrowable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Sprayer
extends Item {
    Random rand = new Random();
    int capacity = 3000;

    public Sprayer() {
        this.func_77637_a(Hatchery.hatcheryTabs);
        this.func_77625_d(1);
        this.func_77656_e(3000);
        this.setNoRepair();
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return ((double)stack.func_77958_k() - (double)this.getAmount(stack)) / (double)stack.func_77958_k();
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        RayTraceResult raytraceresult = this.func_77621_a(worldIn, playerIn, true);
        if (raytraceresult == null) {
            return new ActionResult(EnumActionResult.PASS, (Object)itemStackIn);
        }
        if (raytraceresult.field_72313_a != RayTraceResult.Type.BLOCK) {
            return new ActionResult(EnumActionResult.PASS, (Object)itemStackIn);
        }
        BlockPos blockpos = raytraceresult.func_178782_a();
        if (!worldIn.func_175660_a(playerIn, blockpos)) {
            return new ActionResult(EnumActionResult.FAIL, (Object)itemStackIn);
        }
        if (!playerIn.func_175151_a(blockpos.func_177972_a(raytraceresult.field_178784_b), raytraceresult.field_178784_b, itemStackIn)) {
            return new ActionResult(EnumActionResult.FAIL, (Object)itemStackIn);
        }
        if (!worldIn.field_72995_K && worldIn.func_180495_p(blockpos).func_177230_c() == ModFluids.liquidfertilizer.getBlock()) {
            ItemStack newStack = FluidUtil.tryFillContainer((ItemStack)itemStackIn, (IFluidHandler)FluidUtil.getFluidHandler((World)worldIn, (BlockPos)blockpos, (EnumFacing)raytraceresult.field_178784_b), (int)1000, (EntityPlayer)playerIn, (boolean)true);
            if (newStack == null) {
                return new ActionResult(EnumActionResult.FAIL, (Object)itemStackIn);
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)newStack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)itemStackIn);
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        block10: {
            block9: {
                if (!playerIn.func_175151_a(pos.func_177972_a(facing), facing, stack)) {
                    return EnumActionResult.FAIL;
                }
                if (this.getAmount(stack) < 5) {
                    return EnumActionResult.FAIL;
                }
                if (!worldIn.field_72995_K) break block9;
                for (int x = -1; x <= 1; ++x) {
                    for (int z = -1; z <= 1; ++z) {
                        double d0 = (float)pos.func_177982_a(x, 0, z).func_177958_n() + this.rand.nextFloat();
                        double d1 = (double)pos.func_177982_a(x, 0, z).func_177956_o() + 1.0;
                        double d2 = (float)pos.func_177982_a(x, 0, z).func_177952_p() + this.rand.nextFloat();
                        IBlockState checkSolidState = worldIn.func_180495_p(pos);
                        Block checkSolid = checkSolidState.func_177230_c();
                        if (checkSolidState.func_185914_p() || checkSolid instanceof BlockFarmland) {
                            d1 += 1.0;
                        }
                        worldIn.func_175688_a(EnumParticleTypes.WATER_DROP, d0, d1, d2, 0.0, 0.0, 0.0, new int[5]);
                    }
                }
                break block10;
            }
            int chance = this.rand.nextInt(99) + 1;
            if (chance >= 60) break block10;
            for (int xAxis = -2; xAxis <= 2; ++xAxis) {
                for (int zAxis = -2; zAxis <= 2; ++zAxis) {
                    for (int yAxis = -1; yAxis <= 2; ++yAxis) {
                        boolean aboveBlockValid;
                        Block checkBlock = worldIn.func_180495_p(pos.func_177982_a(xAxis, yAxis, zAxis)).func_177230_c();
                        boolean bl = aboveBlockValid = worldIn.func_180495_p(pos.func_177982_a(xAxis, yAxis + 1, zAxis)).func_177230_c() instanceof IGrowable && worldIn.func_180495_p(pos.func_177982_a(xAxis, yAxis + 1, zAxis)).func_177230_c() != Blocks.field_150349_c || worldIn.func_180495_p(pos.func_177982_a(xAxis, yAxis + 1, zAxis)).func_177230_c() != Blocks.field_150349_c || worldIn.func_180495_p(pos.func_177982_a(xAxis, yAxis + 1, zAxis)).func_177230_c() == Blocks.field_150350_a;
                        if (checkBlock == Blocks.field_150458_ak || checkBlock == Blocks.field_150346_d) {
                            if (!aboveBlockValid || this.rand.nextInt(99) + 1 >= 30) continue;
                            Block block = checkBlock == Blocks.field_150458_ak ? ModBlocks.fertilzedFarmland : ModBlocks.fertlizedDirt;
                            worldIn.func_180501_a(pos.func_177982_a(xAxis, yAxis, zAxis), block.func_176223_P(), 2);
                            worldIn.func_180501_a(pos.func_177982_a(xAxis, yAxis, zAxis), block.func_176223_P(), 1);
                            FluidUtil.getFluidHandler((ItemStack)stack).drain(10, true);
                            stack.func_77964_b(this.capacity - this.getAmount(stack));
                            continue;
                        }
                        if (checkBlock != ModBlocks.fertilzedFarmland && checkBlock != ModBlocks.fertlizedDirt) continue;
                        worldIn.func_180497_b(pos.func_177982_a(xAxis, yAxis, zAxis), checkBlock, 0, 1);
                        if (!(this.rand.nextDouble() < 0.6)) continue;
                        FluidUtil.getFluidHandler((ItemStack)stack).drain(5, true);
                        stack.func_77964_b(this.capacity - this.getAmount(stack));
                    }
                }
            }
        }
        return EnumActionResult.FAIL;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new FluidHandlerSprayer(stack, this.capacity);
    }

    public int getAmount(ItemStack stack) {
        FluidStack fstack = FluidUtil.getFluidContained((ItemStack)stack);
        if (fstack != null) {
            return fstack.amount;
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List tooltip, boolean isAdvanced) {
        FluidStack fstack = FluidUtil.getFluidContained((ItemStack)stack);
        if (fstack != null) {
            tooltip.add(I18n.func_135052_a((String)"tooltip.hatchery.sprayer.desc", (Object[])new Object[]{I18n.func_135052_a((String)"fluid.liquid_fertilizer", (Object[])new Object[0]), fstack.amount, this.func_77612_l()}));
        } else {
            tooltip.add(I18n.func_135052_a((String)"tooltip.hatchery.sprayer.desc", (Object[])new Object[]{I18n.func_135052_a((String)"fluid.liquid_fertilizer", (Object[])new Object[0]), 0, this.func_77612_l()}));
        }
    }
}

