/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.hatchery.item;

import com.gendeathrow.hatchery.Hatchery;
import com.gendeathrow.hatchery.block.nestpen.NestPenTileEntity;
import com.gendeathrow.hatchery.core.init.ModBlocks;
import com.gendeathrow.hatchery.core.init.ModItems;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;

public class AnimalNet
extends Item {
    public AnimalNet() {
        this.func_77637_a(Hatchery.hatcheryTabs);
        this.func_77625_d(1);
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase target, EnumHand hand) {
        if (target.field_70170_p.field_72995_K) {
            return false;
        }
        if (target.field_70170_p.field_72995_K || !(target instanceof EntityAnimal) || target instanceof EntityMob || hand == EnumHand.OFF_HAND) {
            return false;
        }
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("storedEntity") && !stack.func_77978_p().func_74781_a("storedEntity").func_82582_d()) {
            return false;
        }
        NBTTagCompound eTag = AnimalNet.getNBT(stack);
        NBTTagCompound storedEntity = new NBTTagCompound();
        storedEntity.func_74778_a("id", EntityList.func_75621_b((Entity)target));
        ((EntityLiving)target).func_70014_b(storedEntity);
        eTag.func_74782_a("storedEntity", (NBTBase)storedEntity);
        stack.func_77982_d(eTag);
        stack.func_151001_c(I18n.func_74838_a((String)(stack.func_77977_a() + ".name")) + " (" + target.func_145748_c_().func_150254_d() + ")");
        player.func_184586_b(hand).func_77982_d(eTag);
        player.func_184598_c(hand);
        target.field_70170_p.func_72900_e((Entity)target);
        return true;
    }

    public static boolean hasCapturedAnimal(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            return false;
        }
        if (stack.func_77978_p().func_74781_a("storedEntity") == null) {
            return false;
        }
        return !stack.func_77978_p().func_74781_a("storedEntity").func_82582_d();
    }

    public static NBTTagCompound getCapturedAnimalNBT(ItemStack stack) {
        return (NBTTagCompound)stack.func_77978_p().func_74781_a("storedEntity");
    }

    public static void setCapturedNBT(ItemStack stack, Entity entity) {
        NBTTagCompound stacknbt = AnimalNet.getNBT(stack);
        NBTTagCompound eNBT = new NBTTagCompound();
        eNBT = entity.func_189511_e(eNBT);
        eNBT.func_74778_a("id", EntityList.func_75621_b((Entity)entity));
        stacknbt.func_74782_a("storedEntity", (NBTBase)eNBT);
        stack.func_77982_d(stacknbt);
        stack.func_151001_c(I18n.func_74838_a((String)(stack.func_77977_a() + ".name")) + " (" + entity.func_145748_c_().func_150254_d() + ")");
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        worldIn.func_184148_a((EntityPlayer)null, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, SoundEvents.field_187730_dW, SoundCategory.NEUTRAL, 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
        if (!worldIn.field_72995_K) {
            if (hand == EnumHand.OFF_HAND && playerIn.func_184614_ca().func_77973_b() == ModItems.animalNet) {
                return EnumActionResult.FAIL;
            }
            if (playerIn.field_70170_p.func_180495_p(pos).func_177230_c() == ModBlocks.pen_chicken) {
                NestPenTileEntity pen = (NestPenTileEntity)playerIn.field_70170_p.func_175625_s(pos);
                if (!AnimalNet.hasCapturedAnimal(stack) && pen.storedEntity() != null) {
                    AnimalNet.setCapturedNBT(stack, pen.storedEntity());
                    pen.tryGetRemoveEntity();
                }
            } else if (stack.func_77978_p() != null) {
                NBTTagCompound entitynbt = (NBTTagCompound)stack.func_77978_p().func_74781_a("storedEntity");
                if (entitynbt == null) {
                    return EnumActionResult.FAIL;
                }
                Entity entity = AnimalNet.buildEntity(worldIn, entitynbt);
                if (entity == null) {
                    return EnumActionResult.FAIL;
                }
                entity.func_70080_a((double)pos.func_177958_n() + 0.5, (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p() + 0.5, Math.abs(playerIn.field_70177_z), 0.0f);
                if (playerIn.field_70170_p.func_180495_p(pos).func_177230_c() == ModBlocks.pen) {
                    NestPenTileEntity pen = (NestPenTileEntity)playerIn.field_70170_p.func_175625_s(pos);
                    pen.trySetEntity(entity);
                } else {
                    worldIn.func_72838_d(entity);
                }
                playerIn.func_71029_a(StatList.func_188057_b((Item)this));
                stack.func_77978_p().func_82580_o("storedEntity");
                stack.func_151001_c(I18n.func_74838_a((String)(stack.func_77977_a() + ".name")));
                return EnumActionResult.PASS;
            }
        }
        return EnumActionResult.FAIL;
    }

    private static Entity buildEntity(World worldIn, NBTTagCompound entitynbt) {
        try {
            Entity entity = EntityList.func_75615_a((NBTTagCompound)entitynbt, (World)worldIn);
            return entity;
        }
        catch (Throwable e) {
            Hatchery.logger.error("Error trying to spawn Animal 'Null NBT' " + e);
            return null;
        }
    }

    static NBTTagCompound getNBT(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77978_p();
    }
}

