/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.hatchery.core;

import com.gendeathrow.hatchery.common.capability.CapabilityAnimalStatsHandler;
import com.gendeathrow.hatchery.common.capability.IAnimalStats;
import com.gendeathrow.hatchery.core.Settings;
import com.gendeathrow.hatchery.core.config.ConfigHandler;
import com.gendeathrow.hatchery.core.init.ModBlocks;
import com.gendeathrow.hatchery.entities.EntityRooster;
import com.gendeathrow.hatchery.entities.ai.ChickenBreeding;
import com.gendeathrow.hatchery.entities.ai.EntityAIMateWithRooster;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemEgg;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EventHandler {
    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.RightClickItem event) {
        if (!Settings.CAN_THROW_EGG && event.getItemStack().func_77973_b() instanceof ItemEgg && !event.getItemStack().func_77973_b().getRegistryName().toString().equalsIgnoreCase("chickens:liquid_egg")) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("hatchery")) {
            ConfigHandler.CONFIG.save();
        }
    }

    @SubscribeEvent
    public void onHoeEvent(UseHoeEvent event) {
        IBlockState blockstate = event.getWorld().func_180495_p(event.getPos());
        Block block = blockstate.func_177230_c();
        if (event.getWorld().func_175623_d(event.getPos().func_177984_a()) && block == ModBlocks.fertlizedDirt) {
            event.getWorld().func_184133_a((EntityPlayer)null, event.getPos(), SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0f, 1.0f);
            if (!event.getWorld().field_72995_K) {
                event.getWorld().func_180501_a(event.getPos(), ModBlocks.fertilzedFarmland.func_176223_P(), 11);
                event.getCurrent().func_77972_a(1, event.getEntityLiving());
            }
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public void onSpawnCheck(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityLivingBase) {
            EntityLivingBase entity = (EntityLivingBase)event.getEntity();
            if (event.getEntity() instanceof EntityChicken) {
                EntityChicken chicken = (EntityChicken)event.getEntity();
                World world = chicken.field_70170_p;
                if (!world.field_72995_K) {
                    chicken.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMateWithRooster((EntityAnimal)chicken, 1.0));
                    if (Settings.ROOSTER_BREED_ONLY || Settings.IS_EGG_BREEDING) {
                        EntityAIBase rmv = null;
                        int priority = 1;
                        for (EntityAITasks.EntityAITaskEntry task : chicken.field_70714_bg.field_75782_a) {
                            if (!(task.field_75733_a instanceof EntityAIMate)) continue;
                            rmv = task.field_75733_a;
                            priority = task.field_75731_b;
                            break;
                        }
                        if (rmv != null) {
                            chicken.field_70714_bg.func_85156_a(rmv);
                        }
                    }
                    if (!Settings.ROOSTER_BREED_ONLY && Settings.IS_EGG_BREEDING) {
                        chicken.field_70714_bg.func_75776_a(1, (EntityAIBase)new ChickenBreeding((EntityAnimal)chicken, 1.0));
                    }
                }
            }
            if (event.getEntity() instanceof EntityRooster) {
                World world = event.getEntity().field_70170_p;
                if (!world.field_72995_K) {
                    ((EntityRooster)entity).field_70714_bg.func_85156_a((EntityAIBase)new EntityAIMate((EntityAnimal)((EntityRooster)entity), 1.0));
                    ((EntityRooster)entity).field_70714_bg.func_85156_a((EntityAIBase)new EntityAIPanic((EntityCreature)((EntityRooster)entity), 1.4));
                }
            }
        }
    }

    @SubscribeEvent
    public void AttachCap(AttachCapabilitiesEvent event) {
        if (event.getObject() instanceof EntityChicken) {
            event.addCapability(new ResourceLocation("hatchery", "eatting_animal"), (ICapabilityProvider)new CapabilityAnimalStatsHandler());
        }
    }

    @SubscribeEvent
    public void EntityUpdate(LivingEvent.LivingUpdateEvent event) {
        if (!(event.getEntity() instanceof EntityAnimal)) {
            return;
        }
        if (event.getEntity().hasCapability(CapabilityAnimalStatsHandler.ANIMAL_HANDLER_CAPABILITY, null)) {
            ((IAnimalStats)event.getEntity().getCapability(CapabilityAnimalStatsHandler.ANIMAL_HANDLER_CAPABILITY, null)).update((EntityAnimal)event.getEntity());
        }
    }
}

