/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.hatchery.block.nestpen;

import com.gendeathrow.hatchery.block.nestpen.NestPenTileEntity;
import com.gendeathrow.hatchery.core.init.ModBlocks;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class NestingPenBlock
extends Block
implements ITileEntityProvider {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    protected static final AxisAlignedBB AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.2, 1.0);
    protected static final AxisAlignedBB NORTH_STAIRS_AABB = new AxisAlignedBB(0.25, 0.0, 0.0, 0.6875, 0.125, 0.1875);
    protected static final AxisAlignedBB NORTH_BASE_AABB = new AxisAlignedBB(0.125, 0.0, 0.25, 0.9375, 0.125, 1.0);
    protected static final AxisAlignedBB NORTH_SOUTH_WALL_AABB = new AxisAlignedBB(0.125, 0.1875, 0.9375, 0.9375, 1.6, 1.0);
    protected static final AxisAlignedBB NORTH_WALL_AABB = new AxisAlignedBB(0.0625, 0.1875, 0.25, 0.125, 1.6, 1.0);
    protected static final AxisAlignedBB NORTH_WEST_WALL_AABB = new AxisAlignedBB(0.0625, 0.1875, 0.25, 0.125, 1.6, 1.0);
    protected static final AxisAlignedBB NORTH_EAST_WALL_AABB = new AxisAlignedBB(0.8125, 0.1875, 0.25, 0.9375, 1.6, 1.0);
    protected static final AxisAlignedBB[] NORTH_FACING_AABB = new AxisAlignedBB[]{NORTH_STAIRS_AABB, NORTH_BASE_AABB, NORTH_SOUTH_WALL_AABB, NORTH_WEST_WALL_AABB, NORTH_EAST_WALL_AABB};
    protected static final AxisAlignedBB[] BOUNDING_BOXES = new AxisAlignedBB[]{AABB};
    protected String name = "pen";
    private static boolean keepInventory = false;

    public NestingPenBlock() {
        super(Material.field_151575_d);
        this.func_149663_c("pen");
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.func_149711_c(2.0f);
        this.setHarvestLevel("axe", 0);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            NestPenTileEntity te = (NestPenTileEntity)worldIn.func_175625_s(pos);
            if (te == null) {
                return false;
            }
            return te.grabItems(playerIn);
        }
        return true;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        if (!keepInventory) {
            NestPenTileEntity te = (NestPenTileEntity)worldIn.func_175625_s(pos);
            te.dropContents();
            if (te.storedEntity() != null) {
                te.storedEntity().func_70107_b((double)te.func_174877_v().func_177958_n() + 0.5, (double)te.func_174877_v().func_177956_o(), (double)te.func_174877_v().func_177952_p() + 0.5);
                worldIn.func_72838_d(te.storedEntity());
            }
        }
        super.func_180663_b(worldIn, pos, state);
    }

    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)ModBlocks.pen);
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()), 2);
    }

    public static void setState(boolean hasChicken, World worldIn, BlockPos pos) {
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        keepInventory = true;
        if (hasChicken) {
            worldIn.func_175656_a(pos, ModBlocks.pen_chicken.func_176223_P().func_177226_a((IProperty)FACING, iblockstate.func_177229_b((IProperty)FACING)));
        } else {
            worldIn.func_175656_a(pos, ModBlocks.pen.func_176223_P().func_177226_a((IProperty)FACING, iblockstate.func_177229_b((IProperty)FACING)));
        }
        keepInventory = false;
        if (tileentity != null) {
            tileentity.func_145829_t();
            worldIn.func_175690_a(pos, tileentity);
            if (!worldIn.field_72995_K) {
                worldIn.func_184138_a(pos, worldIn.func_180495_p(pos), worldIn.func_180495_p(pos), 2);
            }
        }
    }

    public static boolean hasChicken(IBlockState state) {
        return state.func_177230_c() == ModBlocks.pen_chicken;
    }

    public static EntityChicken getNearByMate(World world, IBlockState state, BlockPos pos) {
        TileEntity tileentity = world.func_175625_s(pos);
        if (!(tileentity instanceof NestPenTileEntity)) {
            return null;
        }
        NestPenTileEntity pen = (NestPenTileEntity)tileentity;
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            NestPenTileEntity penMate;
            EntityAnimal targetmate;
            TileEntity tileentity1;
            BlockPos blockpos;
            Block block;
            if (enumfacing == EnumFacing.UP || enumfacing == EnumFacing.DOWN || !((block = world.func_180495_p(blockpos = pos.func_177972_a(enumfacing)).func_177230_c()) instanceof NestingPenBlock) || !((tileentity1 = world.func_175625_s(blockpos)) instanceof NestPenTileEntity) || (targetmate = (EntityAnimal)(penMate = (NestPenTileEntity)tileentity1).storedEntity()) == null || pen.storedEntity().getClass() != targetmate.getClass()) continue;
            return (EntityChicken)((NestPenTileEntity)tileentity1).storedEntity();
        }
        return null;
    }

    private boolean isFeederNear() {
        return false;
    }

    private void setDefaultFacing(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            IBlockState iblockstate = worldIn.func_180495_p(pos.func_177978_c());
            IBlockState iblockstate1 = worldIn.func_180495_p(pos.func_177968_d());
            IBlockState iblockstate2 = worldIn.func_180495_p(pos.func_177976_e());
            IBlockState iblockstate3 = worldIn.func_180495_p(pos.func_177974_f());
            EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            if (enumfacing == EnumFacing.NORTH && iblockstate.func_185913_b() && !iblockstate1.func_185913_b()) {
                enumfacing = EnumFacing.SOUTH;
            } else if (enumfacing == EnumFacing.SOUTH && iblockstate1.func_185913_b() && !iblockstate.func_185913_b()) {
                enumfacing = EnumFacing.NORTH;
            } else if (enumfacing == EnumFacing.WEST && iblockstate2.func_185913_b() && !iblockstate3.func_185913_b()) {
                enumfacing = EnumFacing.EAST;
            } else if (enumfacing == EnumFacing.EAST && iblockstate3.func_185913_b() && !iblockstate2.func_185913_b()) {
                enumfacing = EnumFacing.WEST;
            }
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)enumfacing), 2);
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_185481_k(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new NestPenTileEntity();
    }

    public static EnumFacing getFacing(IBlockState blockStateContainer) {
        return (EnumFacing)blockStateContainer.func_177229_b((IProperty)FACING);
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn) {
        NestingPenBlock.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB);
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, World worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDING_BOXES[0];
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public boolean canPlaceTorchOnTop(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }
}

