/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.hatchery.block.feeder;

import com.gendeathrow.hatchery.block.feeder.FeederBlock;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class FeederTileEntity
extends TileEntity
implements IInventory {
    private int seedInventory = 0;
    private int maxSeedInventory = 200;
    ItemStack[] inventory = new ItemStack[1];

    public void func_145839_a(NBTTagCompound compound) {
        this.seedInventory = compound.func_74762_e("seeds");
        super.func_145839_a(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("seeds", this.seedInventory);
        return super.func_189515_b(compound);
    }

    public int getSeedsInv() {
        return this.seedInventory;
    }

    public void decrSeedsInv() {
        --this.seedInventory;
    }

    public int getMaxSeedInv() {
        return this.maxSeedInventory;
    }

    public void dropContents() {
        for (int i = 0; i < this.inventory.length; ++i) {
            ItemStack stack = ItemStackHelper.func_188383_a((ItemStack[])this.inventory, (int)i);
            if (stack == null) continue;
            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p(), stack));
        }
    }

    public String func_70005_c_() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70302_i_() {
        return 1;
    }

    public ItemStack func_70301_a(int index) {
        return this.inventory[index];
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack itemstack = ItemStackHelper.func_188382_a((ItemStack[])this.inventory, (int)index, (int)count);
        if (itemstack != null) {
            this.func_70296_d();
        }
        return itemstack;
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a((ItemStack[])this.inventory, (int)index);
    }

    public void func_70299_a(int index, @Nullable ItemStack stack) {
        if (this.func_94041_b(index, stack) && stack != null && this.seedInventory < this.maxSeedInventory) {
            int diff = this.seedInventory - this.maxSeedInventory;
            this.seedInventory += stack.field_77994_a;
            if (stack.field_77994_a <= 0) {
                stack = null;
            } else {
                stack.field_77994_a -= diff;
            }
            FeederBlock.setFeederLevel(this.field_145850_b, this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c));
        }
        this.func_70296_d();
    }

    public void setSeeds(int qty) {
        this.seedInventory = qty;
    }

    public void setSeeds(int qty, ItemStack stack, boolean creative) {
        if (this.func_94041_b(0, stack) && stack != null && this.seedInventory < this.maxSeedInventory) {
            this.seedInventory += qty;
            if (this.seedInventory > this.maxSeedInventory) {
                qty -= this.seedInventory - this.maxSeedInventory;
                this.seedInventory = this.maxSeedInventory;
            }
            if (!creative) {
                stack.field_77994_a -= qty;
                if (stack.field_77994_a <= 0) {
                    stack = null;
                }
            }
            FeederBlock.setFeederLevel(this.field_145850_b, this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c));
        }
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return this.seedInventory < this.maxSeedInventory ? stack.func_77973_b() instanceof ItemSeeds : false;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.inventory.length; ++i) {
            this.inventory[i] = null;
        }
    }

    public static IItemHandler getItemHandler(TileEntity tile, EnumFacing side) {
        if (tile == null) {
            return null;
        }
        IItemHandler handler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side);
        if (handler == null) {
            if (side != null && tile instanceof ISidedInventory) {
                handler = new SidedInvWrapper((ISidedInventory)tile, side);
            } else if (tile instanceof IInventory) {
                handler = new InvWrapper((IInventory)tile);
            }
        }
        return handler;
    }

    public static ItemStack putStackInInventoryAllSlots(IInventory inventoryIn, ItemStack stack, @Nullable EnumFacing side) {
        if (inventoryIn instanceof ISidedInventory && side != null) {
            ISidedInventory isidedinventory = (ISidedInventory)inventoryIn;
            int[] aint = isidedinventory.func_180463_a(side);
            for (int k = 0; k < aint.length && stack != null && stack.field_77994_a > 0; ++k) {
                stack = FeederTileEntity.insertStack(inventoryIn, stack, aint[k], side);
            }
        } else {
            int i = inventoryIn.func_70302_i_();
            for (int j = 0; j < i && stack != null && stack.field_77994_a > 0; ++j) {
                stack = FeederTileEntity.insertStack(inventoryIn, stack, j, side);
            }
        }
        if (stack != null && stack.field_77994_a == 0) {
            stack = null;
        }
        return stack;
    }

    private static ItemStack insertStack(IInventory inventoryIn, ItemStack stack, int index, EnumFacing side) {
        ItemStack itemstack = inventoryIn.func_70301_a(index);
        if (FeederTileEntity.canInsertItemInSlot(inventoryIn, stack, index, side)) {
            int max;
            boolean flag = false;
            if (itemstack == null) {
                int max2 = Math.min(stack.func_77976_d(), inventoryIn.func_70297_j_());
                if (max2 >= stack.field_77994_a) {
                    inventoryIn.func_70299_a(index, stack);
                    stack = null;
                } else {
                    inventoryIn.func_70299_a(index, stack.func_77979_a(max2));
                }
                flag = true;
            } else if (FeederTileEntity.canCombine(itemstack, stack) && (max = Math.min(stack.func_77976_d(), inventoryIn.func_70297_j_())) > itemstack.field_77994_a) {
                int i = max - itemstack.field_77994_a;
                int j = Math.min(stack.field_77994_a, i);
                stack.field_77994_a -= j;
                itemstack.field_77994_a += j;
                flag = j > 0;
            }
        }
        return stack;
    }

    private static boolean canInsertItemInSlot(IInventory inventoryIn, ItemStack stack, int index, EnumFacing side) {
        return !inventoryIn.func_94041_b(index, stack) ? false : !(inventoryIn instanceof ISidedInventory) || ((ISidedInventory)inventoryIn).func_180462_a(index, stack, side);
    }

    private static boolean canCombine(ItemStack stack1, ItemStack stack2) {
        return stack1.func_77973_b() != stack2.func_77973_b() ? false : (stack1.func_77960_j() != stack2.func_77960_j() ? false : (stack1.field_77994_a > stack1.func_77976_d() ? false : ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2)));
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)new InvWrapper((IInventory)this);
        }
        return (T)super.getCapability(capability, facing);
    }
}

