/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.hatchery.block.feeder;

import com.gendeathrow.hatchery.Hatchery;
import com.gendeathrow.hatchery.block.feeder.FeederTileEntity;
import com.gendeathrow.hatchery.common.capability.CapabilityAnimalStatsHandler;
import com.gendeathrow.hatchery.common.capability.IAnimalStats;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class FeederBlock
extends Block
implements ITileEntityProvider {
    public static final PropertyInteger LEVEL = PropertyInteger.func_177719_a((String)"level", (int)0, (int)3);
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    protected static final AxisAlignedBB Base_AABB = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.125, 0.875);
    protected static final AxisAlignedBB Container_AABB = new AxisAlignedBB(0.3125, 0.0, 0.3125, 0.6875, 0.5625, 0.625);
    protected static final AxisAlignedBB bounding = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.5625, 0.875);
    boolean keepInventory;

    public FeederBlock() {
        super(Material.field_151575_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)LEVEL, (Comparable)Integer.valueOf(0)));
        this.func_149711_c(2.0f);
        this.setHarvestLevel("axe", 0);
        this.func_149647_a(Hatchery.hatcheryTabs);
        this.func_149675_a(true);
    }

    public boolean getHasSubtypes() {
        return true;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        FeederTileEntity te;
        if (!worldIn.field_72995_K && (te = (FeederTileEntity)worldIn.func_175625_s(pos)).getSeedsInv() > 0) {
            AxisAlignedBB RANGE_AABB = new AxisAlignedBB((double)(pos.func_177958_n() - 4), (double)pos.func_177956_o(), (double)(pos.func_177952_p() - 4), (double)(pos.func_177958_n() + 4), (double)(pos.func_177956_o() + 1), (double)(pos.func_177952_p() + 4));
            List entitys = worldIn.func_72872_a(EntityChicken.class, RANGE_AABB);
            for (EntityChicken entity : entitys) {
                IAnimalStats cap;
                if (te.getSeedsInv() <= 0 || !entity.hasCapability(CapabilityAnimalStatsHandler.ANIMAL_HANDLER_CAPABILITY, null) || (cap = (IAnimalStats)entity.getCapability(CapabilityAnimalStatsHandler.ANIMAL_HANDLER_CAPABILITY, null)) == null || !cap.canEat()) continue;
                if (entity.func_70631_g_()) {
                    te.decrSeedsInv();
                    entity.func_175501_a((int)((float)(-entity.func_70874_b() / 10) * 0.35f), true);
                } else {
                    te.decrSeedsInv();
                    entity.field_70887_j -= 5;
                }
                FeederBlock.setFeederLevel(worldIn, pos, state);
            }
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        ItemStack stack;
        if (!this.keepInventory) {
            // empty if block
        }
        if ((stack = this.func_180643_i(state)) != null) {
            if (worldIn.func_175625_s(pos) != null && worldIn.func_175625_s(pos) instanceof FeederTileEntity) {
                if (!stack.func_77942_o()) {
                    stack.func_77982_d(new NBTTagCompound());
                }
                stack.func_77978_p().func_74768_a("seedInv", ((FeederTileEntity)worldIn.func_175625_s(pos)).getSeedsInv());
            }
            FeederBlock.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)stack);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        return new ArrayList<ItemStack>();
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            FeederTileEntity te = (FeederTileEntity)worldIn.func_175625_s(pos);
            if (heldItem != null && te != null && te.func_94041_b(0, heldItem)) {
                if (playerIn.func_70093_af()) {
                    te.setSeeds(1, heldItem, playerIn.field_71075_bZ.field_75098_d);
                } else {
                    te.setSeeds(heldItem.field_77994_a, heldItem, playerIn.field_71075_bZ.field_75098_d);
                }
                return true;
            }
        }
        return true;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn) {
        FeederBlock.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)Base_AABB);
        FeederBlock.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)Container_AABB);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return bounding;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new FeederTileEntity();
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO()).func_177226_a((IProperty)LEVEL, (Comparable)Integer.valueOf(0));
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        boolean lvl = false;
        if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("seedInv") && worldIn.func_175625_s(pos) != null && worldIn.func_175625_s(pos) instanceof FeederTileEntity) {
            ((FeederTileEntity)worldIn.func_175625_s(pos)).setSeeds(stack.func_77978_p().func_74762_e("seedInv"));
        }
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO()).func_177226_a((IProperty)LEVEL, state.func_177229_b((IProperty)LEVEL)), 2);
        FeederBlock.setFeederLevel(worldIn, pos, state);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_185481_k(IBlockState state) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    public static EnumFacing getFacing(int meta) {
        return EnumFacing.func_176731_b((int)meta);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)FeederBlock.getFacing(meta)).func_177226_a((IProperty)LEVEL, (Comparable)Integer.valueOf(meta >> 2));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        i |= ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
        return i |= (Integer)state.func_177229_b((IProperty)LEVEL) << 2;
    }

    public static void setFeederLevel(World worldIn, BlockPos pos, IBlockState state) {
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        int level = 0;
        if (tileentity != null && tileentity instanceof FeederTileEntity) {
            FeederTileEntity te = (FeederTileEntity)tileentity;
            float percentage = (float)te.getSeedsInv() / (float)te.getMaxSeedInv();
            level = MathHelper.func_76123_f((float)(percentage * 3.0f));
        }
        if ((Integer)state.func_177229_b((IProperty)LEVEL) != level) {
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, state.func_177229_b((IProperty)FACING)).func_177226_a((IProperty)LEVEL, (Comparable)Integer.valueOf(MathHelper.func_76125_a((int)level, (int)0, (int)3))), 2);
            if (tileentity != null) {
                tileentity.func_145829_t();
                worldIn.func_175690_a(pos, tileentity);
            }
        }
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, LEVEL});
    }
}

