/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util.helpers;

import cofh.lib.util.helpers.ItemHelper;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.EmptyHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class InventoryHelper {
    private InventoryHelper() {
    }

    public static ItemStack[] cloneInventory(ItemStack[] inventory) {
        ItemStack[] inventoryCopy = new ItemStack[inventory.length];
        for (int i = 0; i < inventory.length; ++i) {
            inventoryCopy[i] = inventory[i] == null ? null : inventory[i].func_77946_l();
        }
        return inventoryCopy;
    }

    public static boolean addItemStackToInventory(ItemStack[] inventory, ItemStack stack, int startIndex, int endIndex) {
        if (stack == null) {
            return true;
        }
        int openSlot = -1;
        for (int i = startIndex; i <= endIndex; ++i) {
            if (ItemHelper.itemsEqualForCrafting(stack, inventory[i]) && inventory[i].func_77976_d() > inventory[i].field_77994_a) {
                int hold = inventory[i].func_77976_d() - inventory[i].field_77994_a;
                if (hold >= stack.field_77994_a) {
                    inventory[i].field_77994_a += stack.field_77994_a;
                    stack = null;
                    return true;
                }
                stack.field_77994_a -= hold;
                inventory[i].field_77994_a += hold;
                continue;
            }
            if (inventory[i] != null || openSlot != -1) continue;
            openSlot = i;
        }
        if (openSlot <= -1) {
            return false;
        }
        inventory[openSlot] = stack;
        return true;
    }

    public static boolean addItemStackToInventory(ItemStack[] inventory, ItemStack stack, int startIndex) {
        return InventoryHelper.addItemStackToInventory(inventory, stack, startIndex, inventory.length - 1);
    }

    public static boolean addItemStackToInventory(ItemStack[] inventory, ItemStack stack) {
        return InventoryHelper.addItemStackToInventory(inventory, stack, 0);
    }

    public static ItemStack insertStackIntoInventory(IItemHandler handler, ItemStack stack, boolean simulate) {
        return InventoryHelper.insertStackIntoInventory(handler, stack, simulate, false);
    }

    public static ItemStack insertStackIntoInventory(IItemHandler handler, ItemStack stack, boolean simulate, boolean forceEmptySlot) {
        return forceEmptySlot ? ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack, (boolean)simulate) : ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)stack, (boolean)simulate);
    }

    @Deprecated
    public static ItemStack simulateInsertItemStackIntoInventory(IInventory inventory, ItemStack stack, EnumFacing side) {
        if (stack == null || inventory == null) {
            return null;
        }
        if (inventory instanceof ISidedInventory) {
            int i;
            ISidedInventory sidedInv = (ISidedInventory)inventory;
            int[] slots = sidedInv.func_180463_a(side);
            if (slots == null) {
                return stack;
            }
            for (i = 0; i < slots.length && stack != null; ++i) {
                ItemStack existingStack;
                if (!sidedInv.func_180462_a(slots[i], stack, side) || !ItemHelper.itemsEqualWithMetadata(stack, existingStack = inventory.func_70301_a(slots[i]), true)) continue;
                stack = InventoryHelper.simulateAddToOccupiedInventorySlot((IInventory)sidedInv, slots[i], stack, existingStack);
            }
            for (i = 0; i < slots.length && stack != null; ++i) {
                if (inventory.func_70301_a(slots[i]) != null || !sidedInv.func_180462_a(slots[i], stack, side)) continue;
                stack = InventoryHelper.simulateAddToEmptyInventorySlot((IInventory)sidedInv, slots[i], stack);
            }
        } else {
            int i;
            int invSize = inventory.func_70302_i_();
            for (i = 0; i < invSize && stack != null; ++i) {
                ItemStack existingStack = inventory.func_70301_a(i);
                if (!ItemHelper.itemsEqualWithMetadata(stack, existingStack, true)) continue;
                stack = InventoryHelper.simulateAddToOccupiedInventorySlot(inventory, i, stack, existingStack);
            }
            for (i = 0; i < invSize && stack != null; ++i) {
                if (inventory.func_70301_a(i) != null) continue;
                stack = InventoryHelper.simulateAddToEmptyInventorySlot(inventory, i, stack);
            }
        }
        return stack;
    }

    @Deprecated
    public static ItemStack addToEmptyInventorySlot(IInventory inventory, int slot, ItemStack stack) {
        if (!inventory.func_94041_b(slot, stack)) {
            return stack;
        }
        int stackLimit = inventory.func_70297_j_();
        inventory.func_70299_a(slot, ItemHelper.cloneStack(stack, Math.min(stack.field_77994_a, stackLimit)));
        return stackLimit >= stack.field_77994_a ? null : stack.func_77979_a(stack.field_77994_a - stackLimit);
    }

    @Deprecated
    public static ItemStack addToOccupiedInventorySlot(IInventory inventory, int slot, ItemStack stack) {
        int stackLimit = Math.min(inventory.func_70297_j_(), stack.func_77976_d());
        ItemStack stackInSlot = inventory.func_70301_a(slot);
        if (stack.field_77994_a + stackInSlot.field_77994_a > stackLimit) {
            int stackDiff = stackLimit - stackInSlot.field_77994_a;
            stackInSlot.field_77994_a = stackLimit;
            stack.field_77994_a -= stackDiff;
            inventory.func_70299_a(slot, stackInSlot);
            return stack;
        }
        stackInSlot.field_77994_a += Math.min(stack.field_77994_a, stackLimit);
        inventory.func_70299_a(slot, stackInSlot);
        return stackLimit >= stack.field_77994_a ? null : stack.func_77979_a(stack.field_77994_a - stackLimit);
    }

    @Deprecated
    public static ItemStack addToOccupiedInventorySlot(IInventory inventory, int slot, ItemStack stack, ItemStack existingStack) {
        int stackLimit = Math.min(inventory.func_70297_j_(), stack.func_77976_d());
        if (existingStack.field_77994_a >= stackLimit) {
            return stack;
        }
        if (stack.field_77994_a + existingStack.field_77994_a > stackLimit) {
            int stackDiff = stackLimit - existingStack.field_77994_a;
            existingStack.field_77994_a = stackLimit;
            stack.field_77994_a -= stackDiff;
            inventory.func_70299_a(slot, existingStack);
            return stack;
        }
        existingStack.field_77994_a += stack.field_77994_a;
        inventory.func_70299_a(slot, existingStack);
        return stackLimit >= stack.field_77994_a ? null : stack.func_77979_a(stack.field_77994_a - stackLimit);
    }

    public static ItemStack simulateAddToEmptyInventorySlot(IInventory inventory, int slot, ItemStack stack) {
        if (!inventory.func_94041_b(slot, stack)) {
            return stack;
        }
        int stackLimit = Math.min(inventory.func_70297_j_(), stack.func_77976_d());
        return stackLimit >= stack.field_77994_a ? null : stack.func_77979_a(stack.field_77994_a - stackLimit);
    }

    public static ItemStack simulateAddToOccupiedInventorySlot(IInventory inventory, int slot, ItemStack stack) {
        int stackLimit = Math.min(inventory.func_70297_j_(), stack.func_77976_d());
        ItemStack stackInSlot = inventory.func_70301_a(slot);
        if (stack.field_77994_a + stackInSlot.field_77994_a > stackLimit) {
            stack.field_77994_a -= stackLimit - stackInSlot.field_77994_a;
            return stack;
        }
        return stackLimit >= stack.field_77994_a ? null : stack.func_77979_a(stack.field_77994_a - stackLimit);
    }

    public static ItemStack simulateAddToOccupiedInventorySlot(IInventory inventory, int slot, ItemStack stack, ItemStack existingStack) {
        int stackLimit = Math.min(inventory.func_70297_j_(), stack.func_77976_d());
        if (existingStack.field_77994_a >= stackLimit) {
            return stack;
        }
        if (stack.field_77994_a + existingStack.field_77994_a > stackLimit) {
            stack.field_77994_a -= stackLimit - existingStack.field_77994_a;
            return stack;
        }
        return stackLimit >= stack.field_77994_a ? null : stack.func_77979_a(stack.field_77994_a - stackLimit);
    }

    public static boolean mergeItemStack(List<Slot> slots, ItemStack stack, int start, int length, boolean reverse) {
        return InventoryHelper.mergeItemStack(slots, stack, start, length, reverse, true);
    }

    public static boolean mergeItemStack(List<Slot> slots, ItemStack stack, int start, int length, boolean r, boolean limit) {
        int maxStack;
        int rmv;
        ItemStack existingStack;
        Slot slot;
        int i;
        int iterOrder;
        boolean successful = false;
        int n = iterOrder = !r ? 1 : -1;
        if (stack.func_77985_e()) {
            for (i = !r ? start : length - 1; stack.field_77994_a > 0 && (!r && i < length || r && i >= start); i += iterOrder) {
                slot = slots.get(i);
                existingStack = slot.func_75211_c();
                if (existingStack == null || !slot.func_75214_a(ItemHelper.cloneStack(stack, rmv = Math.min(maxStack = Math.min(stack.func_77976_d(), slot.func_75219_a()), stack.field_77994_a))) || !existingStack.func_77973_b().equals(stack.func_77973_b()) || stack.func_77981_g() && stack.func_77952_i() != existingStack.func_77952_i() || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)existingStack)) continue;
                int existingSize = existingStack.field_77994_a + stack.field_77994_a;
                if (existingSize <= maxStack) {
                    stack.field_77994_a = 0;
                    existingStack.field_77994_a = existingSize;
                    slot.func_75215_d(existingStack);
                    successful = true;
                    continue;
                }
                if (existingStack.field_77994_a >= maxStack) continue;
                stack.field_77994_a -= maxStack - existingStack.field_77994_a;
                existingStack.field_77994_a = maxStack;
                slot.func_75215_d(existingStack);
                successful = true;
            }
        }
        if (stack.field_77994_a > 0) {
            int n2 = i = !r ? start : length - 1;
            while (stack.field_77994_a > 0 && (!r && i < length || r && i >= start)) {
                slot = slots.get(i);
                existingStack = slot.func_75211_c();
                if (existingStack == null && slot.func_75214_a(ItemHelper.cloneStack(stack, rmv = Math.min(maxStack = Math.min(stack.func_77976_d(), slot.func_75219_a()), stack.field_77994_a)))) {
                    existingStack = stack.func_77979_a(rmv);
                    slot.func_75215_d(existingStack);
                    successful = true;
                }
                i += iterOrder;
            }
        }
        return successful;
    }

    public static ItemStack addToInsertion(TileEntity tile, EnumFacing side, ItemStack stack) {
        if (stack == null) {
            return null;
        }
        if (InventoryHelper.hasItemHandlerCap(tile, side.func_176734_d())) {
            stack = InventoryHelper.insertStackIntoInventory(InventoryHelper.getItemHandlerCap(tile, side.func_176734_d()), stack, false);
        }
        return stack;
    }

    public static boolean hasItemHandlerCap(TileEntity tileEntity, EnumFacing face) {
        return tileEntity != null && (tileEntity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, face) || tileEntity instanceof ISidedInventory || tileEntity instanceof IInventory);
    }

    public static IItemHandler getItemHandlerCap(TileEntity tileEntity, EnumFacing face) {
        if (tileEntity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, face)) {
            return (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, face);
        }
        if (tileEntity instanceof ISidedInventory && face != null) {
            return new SidedInvWrapper((ISidedInventory)tileEntity, face);
        }
        if (tileEntity instanceof IInventory) {
            return new InvWrapper((IInventory)tileEntity);
        }
        return new EmptyHandler();
    }
}

