/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.world.feature;

import cofh.core.world.FeatureParser;
import cofh.lib.util.WeightedRandomBlock;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.numbers.INumberProvider;
import cofh.lib.world.IFeatureGenerator;
import cofh.lib.world.IFeatureParser;
import cofh.lib.world.feature.FeatureBase;
import cofh.lib.world.feature.FeatureGenUniform;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigList;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueType;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import net.minecraft.init.Blocks;
import net.minecraft.world.gen.feature.WorldGenerator;
import org.apache.logging.log4j.Logger;

public class UniformParser
implements IFeatureParser {
    protected final List<WeightedRandomBlock> defaultMaterial = this.generateDefaultMaterial();

    protected List<WeightedRandomBlock> generateDefaultMaterial() {
        return Arrays.asList(new WeightedRandomBlock(Blocks.field_150348_b, -1));
    }

    @Override
    public IFeatureGenerator parseFeature(String featureName, Config genObject, Logger log) {
        WorldGenerator generator;
        INumberProvider numClusters = FeatureParser.parseNumberValue(genObject.getValue("cluster-count"), 0L, Long.MAX_VALUE);
        boolean retrogen = false;
        if (genObject.hasPath("retrogen")) {
            retrogen = genObject.getBoolean("retrogen");
        }
        FeatureBase.GenRestriction biomeRes = FeatureBase.GenRestriction.NONE;
        if (genObject.hasPath("biome")) {
            ConfigValue data = genObject.getValue("biome");
            if (data.valueType() == ConfigValueType.STRING) {
                biomeRes = FeatureBase.GenRestriction.get(genObject.getString("biome"));
                if (biomeRes != FeatureBase.GenRestriction.NONE) {
                    log.error("Invalid biome restriction %2$s on '%1$s'. Must be an object to meaningfully function", new Object[]{featureName, biomeRes.name().toLowerCase(Locale.US)});
                    return null;
                }
            } else if (data.valueType() == ConfigValueType.OBJECT) {
                biomeRes = FeatureBase.GenRestriction.get(genObject.getString("biome.restriction"));
            }
        }
        FeatureBase.GenRestriction dimRes = FeatureBase.GenRestriction.NONE;
        if (genObject.hasPath("dimension")) {
            ConfigValue data = genObject.getValue("dimension");
            switch (data.valueType()) {
                case STRING: {
                    dimRes = FeatureBase.GenRestriction.get(genObject.getString("dimension"));
                    if (dimRes == FeatureBase.GenRestriction.NONE) break;
                    log.error("Invalid dimension restriction %2$s on '%1$s'. Must be an object to meaningfully function", new Object[]{featureName, dimRes.name().toLowerCase(Locale.US)});
                    return null;
                }
                case OBJECT: {
                    dimRes = FeatureBase.GenRestriction.get(genObject.getString("dimension.restriction"));
                    break;
                }
                case LIST: 
                case NUMBER: {
                    dimRes = FeatureBase.GenRestriction.WHITELIST;
                }
            }
        }
        if ((generator = FeatureParser.parseGenerator(this.getDefaultGenerator(), genObject, this.defaultMaterial)) == null) {
            log.warn("Invalid generator for '%s'!", new Object[]{featureName});
            return null;
        }
        FeatureBase feature = this.getFeature(featureName, genObject, generator, numClusters, biomeRes, retrogen, dimRes, log);
        if (feature != null) {
            if (genObject.hasPath("chunk-chance")) {
                int rarity = MathHelper.clamp(genObject.getInt("chunk-chance"), 1, 1000000000);
                feature.setRarity(rarity);
            }
            UniformParser.addFeatureRestrictions(feature, genObject);
            if (genObject.hasPath("in-village")) {
                feature.withVillage = genObject.getBoolean("in-village");
            }
        }
        return feature;
    }

    protected FeatureBase getFeature(String featureName, Config genObject, WorldGenerator gen, INumberProvider numClusters, FeatureBase.GenRestriction biomeRes, boolean retrogen, FeatureBase.GenRestriction dimRes, Logger log) {
        if (!genObject.hasPath("min-height") || !genObject.hasPath("max-height")) {
            log.error("Height parameters for 'uniform' template not specified in \"" + featureName + "\"");
            return null;
        }
        INumberProvider minHeight = FeatureParser.parseNumberValue(genObject.root().get((Object)"min-height"));
        INumberProvider maxHeight = FeatureParser.parseNumberValue(genObject.root().get((Object)"max-height"));
        return new FeatureGenUniform(featureName, gen, numClusters, minHeight, maxHeight, biomeRes, retrogen, dimRes);
    }

    protected String getDefaultGenerator() {
        return "cluster";
    }

    protected static void addFeatureRestrictions(FeatureBase feature, Config genObject) {
        if (feature.biomeRestriction != FeatureBase.GenRestriction.NONE) {
            feature.addBiomes(FeatureParser.parseBiomeRestrictions(genObject.getConfig("biome")));
        }
        if (feature.dimensionRestriction != FeatureBase.GenRestriction.NONE) {
            String field = "dimension";
            ConfigValue data = genObject.getValue(field);
            ConfigList restrictionList = null;
            switch (data.valueType()) {
                case OBJECT: {
                    field = field + ".value";
                }
                case LIST: {
                    restrictionList = genObject.getList(field);
                    break;
                }
                case NUMBER: {
                    feature.addDimension(genObject.getNumber(field).intValue());
                    break;
                }
            }
            if (restrictionList != null) {
                for (int i = 0; i < restrictionList.size(); ++i) {
                    ConfigValue val = (ConfigValue)restrictionList.get(i);
                    if (val.valueType() != ConfigValueType.NUMBER) continue;
                    feature.addDimension(((Number)val.unwrapped()).intValue());
                }
            }
        }
    }
}

