/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.world.feature;

import cofh.core.world.FeatureParser;
import cofh.core.world.feature.SurfaceParser;
import cofh.lib.util.WeightedRandomBlock;
import cofh.lib.world.IGeneratorParser;
import cofh.lib.world.WorldGenDecoration;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.gen.feature.WorldGenerator;
import org.apache.logging.log4j.Logger;

public class DecorationParser
extends SurfaceParser
implements IGeneratorParser {
    @Override
    public WorldGenerator parseGenerator(String name, Config genObject, Logger log, List<WeightedRandomBlock> resList, List<WeightedRandomBlock> matList) {
        int clusterSize = genObject.getInt("cluster-size");
        if (clusterSize <= 0) {
            log.warn("Invalid cluster size for generator '%s'", new Object[]{name});
            return null;
        }
        ArrayList<WeightedRandomBlock> list = new ArrayList<WeightedRandomBlock>();
        ConfigObject genData = genObject.root();
        if (!genObject.hasPath("surface")) {
            log.info("Entry does not specify surface for 'decoration' generator. Using grass.");
            list.add(new WeightedRandomBlock((Block)Blocks.field_150349_c));
        } else if (!FeatureParser.parseResList(genData.get((Object)"surface"), list, false)) {
            log.warn("Entry specifies invalid surface for 'decoration' generator! Using grass!");
            list.clear();
            list.add(new WeightedRandomBlock((Block)Blocks.field_150349_c));
        }
        WorldGenDecoration r = new WorldGenDecoration(resList, clusterSize, matList, list);
        if (genObject.hasPath("see-sky")) {
            r.setSeeSky(genObject.getBoolean("see-sky"));
        }
        if (genObject.hasPath("check-stay")) {
            r.setCheckStay(genObject.getBoolean("check-stay"));
        }
        if (genObject.hasPath("stack-height")) {
            r.setStackHeight(FeatureParser.parseNumberValue(genData.get((Object)"stack-height")));
        }
        if (genObject.hasPath("x-variance")) {
            r.setXVar(FeatureParser.parseNumberValue(genData.get((Object)"x-variance"), 1L, 15L));
        }
        if (genObject.hasPath("y-variance")) {
            r.setYVar(FeatureParser.parseNumberValue(genData.get((Object)"y-variance"), 0L, 15L));
        }
        if (genObject.hasPath("z-variance")) {
            r.setZVar(FeatureParser.parseNumberValue(genData.get((Object)"z-variance"), 1L, 15L));
        }
        return r;
    }

    @Override
    protected List<WeightedRandomBlock> generateDefaultMaterial() {
        return Collections.singletonList(new WeightedRandomBlock((Block)Blocks.field_150349_c, -1));
    }

    @Override
    protected String getDefaultGenerator() {
        return "decoration";
    }
}

