/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.world.decoration;

import cofh.lib.util.WeightedRandomBlock;
import cofh.lib.world.IGeneratorParser;
import cofh.lib.world.WorldGenMinableCluster;
import cofh.lib.world.WorldGenSparseMinableCluster;
import com.typesafe.config.Config;
import java.util.List;
import net.minecraft.world.gen.feature.WorldGenerator;
import org.apache.logging.log4j.Logger;

public class ClusterParser
implements IGeneratorParser {
    private final boolean sparse;

    public ClusterParser(boolean sparse) {
        this.sparse = sparse;
    }

    @Override
    public WorldGenerator parseGenerator(String name, Config genObject, Logger log, List<WeightedRandomBlock> resList, List<WeightedRandomBlock> matList) {
        int clusterSize = genObject.getInt("cluster-size");
        if (clusterSize <= 0) {
            log.warn("Invalid cluster size for generator '%s'", new Object[]{name});
            return null;
        }
        if (this.sparse) {
            return new WorldGenSparseMinableCluster(resList, clusterSize, matList);
        }
        return new WorldGenMinableCluster(resList, clusterSize, matList);
    }
}

