/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.world;

import cofh.CoFHCore;
import cofh.core.world.WorldHandler;
import cofh.lib.util.ChunkCoord;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayDeque;
import java.util.Random;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

public class TickHandlerWorld {
    public static TickHandlerWorld instance = new TickHandlerWorld();
    public static TIntObjectHashMap<ArrayDeque<RetroChunkCoord>> chunksToGen = new TIntObjectHashMap();
    public static TIntObjectHashMap<ArrayDeque<ChunkCoord>> chunksToPreGen = new TIntObjectHashMap();
    private static byte pregenC;
    private static byte retroC;

    @SubscribeEvent
    public void tickEnd(TickEvent.WorldTickEvent event) {
        if (event.side != Side.SERVER) {
            return;
        }
        World world = event.world;
        int dim = world.field_73011_w.getDimension();
        if (event.phase == TickEvent.Phase.END) {
            ArrayDeque chunks = (ArrayDeque)chunksToGen.get(dim);
            if (chunks != null && chunks.size() > 0) {
                RetroChunkCoord r = (RetroChunkCoord)chunks.pollFirst();
                ChunkCoord c = r.coord;
                byte by = retroC;
                retroC = (byte)(by + 1);
                if (by == 0 || chunks.size() < 3) {
                    CoFHCore.LOG.info("RetroGening " + c.toString() + ".");
                } else {
                    CoFHCore.LOG.debug("RetroGening " + c.toString() + ".");
                }
                retroC = (byte)(retroC & 0x1F);
                long worldSeed = world.func_72905_C();
                Random rand = new Random(worldSeed);
                long xSeed = rand.nextLong() >> 3;
                long zSeed = rand.nextLong() >> 3;
                rand.setSeed(xSeed * (long)c.chunkX + zSeed * (long)c.chunkZ ^ worldSeed);
                WorldHandler.instance.generateWorld(rand, r, world, false);
                chunksToGen.put(dim, (Object)chunks);
            } else if (chunks != null) {
                chunksToGen.remove(dim);
            }
        } else {
            ArrayDeque chunks = (ArrayDeque)chunksToPreGen.get(dim);
            if (chunks != null && chunks.size() > 0) {
                ChunkCoord c = (ChunkCoord)chunks.pollFirst();
                byte by = pregenC;
                pregenC = (byte)(by + 1);
                if (by == 0 || chunks.size() < 5) {
                    CoFHCore.LOG.info("PreGening " + c.toString() + ".");
                } else {
                    CoFHCore.LOG.debug("PreGening " + c.toString() + ".");
                }
                pregenC = (byte)(pregenC & 0x1F);
                world.func_72964_e(c.chunkX, c.chunkZ);
            } else if (chunks != null) {
                chunksToPreGen.remove(dim);
            }
        }
    }

    public static class RetroChunkCoord {
        private static final THashSet<String> emptySet = new THashSet(0);
        public final ChunkCoord coord;
        public final THashSet<String> generatedFeatures;

        public RetroChunkCoord(ChunkCoord pos, NBTTagList features) {
            this.coord = pos;
            if (features == null) {
                this.generatedFeatures = emptySet;
            } else {
                int e = features.func_74745_c();
                this.generatedFeatures = new THashSet(e);
                for (int i = 0; i < e; ++i) {
                    this.generatedFeatures.add((Object)features.func_150307_f(i));
                }
            }
        }

        public boolean equals(Object o) {
            if (o instanceof RetroChunkCoord) {
                return ((RetroChunkCoord)o).coord.equals(this.coord);
            }
            if (o instanceof ChunkCoord) {
                return o.equals(this.coord);
            }
            return false;
        }

        public int hashCode() {
            return this.coord.hashCode();
        }
    }
}

