/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util.nbt;

import cofh.lib.util.helpers.FluidHelper;
import cofh.lib.util.helpers.ItemHelper;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.UUID;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidStack;

public final class NBTTagSmartByteArray
extends NBTTagByteArray {
    private _ByteArrayOutputStream arrayout;
    private DataOutputStream dataout;

    public NBTTagSmartByteArray() {
        this(64);
    }

    public NBTTagSmartByteArray(int initialSize) {
        super(null);
        this.arrayout = new _ByteArrayOutputStream(initialSize);
        this.dataout = new DataOutputStream(this.arrayout);
    }

    public NBTTagSmartByteArray addString(String theString) {
        try {
            this.dataout.writeUTF(theString);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    public NBTTagSmartByteArray addUUID(UUID theUUID) {
        try {
            this.dataout.writeLong(theUUID.getMostSignificantBits());
            this.dataout.writeLong(theUUID.getLeastSignificantBits());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    public NBTTagSmartByteArray addLong(long theLong) {
        try {
            this.dataout.writeLong(theLong);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    public NBTTagSmartByteArray addInt(int theInteger) {
        try {
            this.dataout.writeInt(theInteger);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    public NBTTagSmartByteArray addVarInt(int theInteger) {
        try {
            int v = 0;
            if (theInteger < 0) {
                v |= 0x40;
                theInteger ^= 0xFFFFFFFF;
            }
            if ((theInteger & 0xFFFFFFC0) != 0) {
                v |= 0x80;
            }
            this.dataout.writeByte(v | theInteger & 0x3F);
            theInteger >>>= 6;
            while (theInteger != 0) {
                this.dataout.writeByte(theInteger & 0x7F | ((theInteger & 0xFFFFFF80) != 0 ? 128 : 0));
                theInteger >>>= 7;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    public NBTTagSmartByteArray addBool(boolean theBoolean) {
        try {
            this.dataout.writeBoolean(theBoolean);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    public NBTTagSmartByteArray addByte(byte theByte) {
        try {
            this.dataout.writeByte(theByte);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    public NBTTagSmartByteArray addByte(int theByte) {
        return this.addByte((byte)theByte);
    }

    public NBTTagSmartByteArray addShort(short theShort) {
        try {
            this.dataout.writeShort(theShort);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    public NBTTagSmartByteArray addShort(int theShort) {
        return this.addShort((short)theShort);
    }

    public NBTTagSmartByteArray addByteArray(byte[] theByteArray) {
        try {
            this.dataout.write(theByteArray);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    public NBTTagSmartByteArray addFloat(float theFloat) {
        try {
            this.dataout.writeFloat(theFloat);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    public NBTTagSmartByteArray addItemStack(ItemStack theStack) {
        try {
            if (theStack == null) {
                this.addShort(-1);
            } else {
                this.addShort(Item.func_150891_b((Item)theStack.func_77973_b()));
                this.addByte(theStack.field_77994_a);
                this.addShort(ItemHelper.getItemDamage(theStack));
                this.addNBT(theStack.func_77978_p());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    public void addNBT(NBTTagCompound nbt) throws IOException {
        if (nbt == null) {
            this.addShort(-1);
        } else {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            CompressedStreamTools.func_74799_a((NBTTagCompound)nbt, (OutputStream)baos);
            byte[] abyte = baos.toByteArray();
            this.addShort((short)abyte.length);
            this.addByteArray(abyte);
        }
    }

    public NBTTagSmartByteArray addFluidStack(FluidStack theStack) {
        try {
            FluidHelper.writeFluidStackToPacket(theStack, this.dataout);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    public NBTTagSmartByteArray addCoords(TileEntity theTile) {
        this.addInt(theTile.func_174877_v().func_177958_n());
        this.addInt(theTile.func_174877_v().func_177956_o());
        return this.addInt(theTile.func_174877_v().func_177952_p());
    }

    public NBTTagSmartByteArray addCoords(int x, int y, int z) {
        this.addInt(x);
        this.addInt(y);
        return this.addInt(z);
    }

    public void func_74734_a(DataOutput output) throws IOException {
        output.writeInt(this.arrayout.size());
        output.write(this.arrayout.getByteArray(), 0, this.arrayout.size());
    }

    public String toString() {
        return "[" + this.arrayout.size() + " bytes]";
    }

    public NBTBase func_74737_b() {
        return new NBTTagByteArray(this.func_150292_c());
    }

    public boolean equals(Object o) {
        if (super.equals(o) && o.getClass() == NBTTagSmartByteArray.class) {
            NBTTagSmartByteArray other = (NBTTagSmartByteArray)((Object)o);
            return other.dataout.equals(this.dataout);
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode() ^ this.dataout.hashCode();
    }

    public byte[] func_150292_c() {
        return this.arrayout.toByteArray();
    }

    private class _ByteArrayOutputStream
    extends ByteArrayOutputStream {
        _ByteArrayOutputStream(int initialSize) {
            super(initialSize);
        }

        byte[] getByteArray() {
            return this.buf;
        }
    }
}

