/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util.helpers;

import cofh.core.util.tileentity.IRedstoneControl;
import cofh.lib.util.helpers.StringHelper;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class RedstoneControlHelper {
    private RedstoneControlHelper() {
    }

    public static NBTTagCompound setItemStackTagRS(NBTTagCompound tag, IRedstoneControl tile) {
        if (tile == null) {
            return null;
        }
        if (tag == null) {
            tag = new NBTTagCompound();
        }
        tag.func_74774_a("RSControl", (byte)tile.getControl().ordinal());
        return tag;
    }

    public static IRedstoneControl.ControlMode getControlFromNBT(NBTTagCompound tag) {
        return tag == null ? IRedstoneControl.ControlMode.DISABLED : IRedstoneControl.ControlMode.values()[tag.func_74771_c("RSControl")];
    }

    public static void addRSControlInformation(ItemStack stack, List<String> list) {
        if (RedstoneControlHelper.hasRSControl(stack)) {
            switch (stack.func_77978_p().func_74771_c("RSControl")) {
                case 0: {
                    list.add(StringHelper.localize("info.cofh.signalDisabled"));
                    return;
                }
                case 1: {
                    list.add(StringHelper.localize("info.cofh.signalEnabledLow"));
                    return;
                }
                case 2: {
                    list.add(StringHelper.localize("info.cofh.signalEnabledHigh"));
                    return;
                }
            }
        }
    }

    public static boolean hasRSControl(ItemStack stack) {
        return stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("RSControl");
    }

    public static boolean setControl(ItemStack stack, IRedstoneControl.ControlMode control) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74774_a("RSControl", (byte)control.ordinal());
        return true;
    }

    public static IRedstoneControl.ControlMode getControl(ItemStack stack) {
        return stack.func_77978_p() == null ? IRedstoneControl.ControlMode.DISABLED : IRedstoneControl.ControlMode.values()[stack.func_77978_p().func_74771_c("RSControl")];
    }
}

