/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util;

import com.google.common.collect.HashBiMap;
import java.util.Map;
import java.util.concurrent.Callable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;

public class CrashHelper {
    static final int range = 3;
    static final char[] validLetters = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789abcdefghijklmnopqrstuvwxyz!$%^&*()`_+\"\\@'{}[]~/|<>,.?:;".toCharArray();
    static final char[] metaLetters = "0123456789ABCDEF".toCharArray();

    public static CrashReport makeDetailedCrashReport(Throwable throwable, String message, Object caller, Object ... curState) {
        CrashReport crashReport = CrashReport.func_85055_a((Throwable)throwable, (String)message);
        crashReport.func_85058_a("Calling Thread").func_71507_a("Name", () -> Thread.currentThread().getName());
        if (caller != null) {
            CrashHelper.addCallSection(caller, crashReport, "Calling Object");
        }
        for (int i = 0; i < curState.length; i += 2) {
            Object o = curState[i + 1];
            CrashHelper.addCallSection(o, crashReport, "Additional - " + curState[i]);
        }
        return crashReport;
    }

    public static CrashReport addSurroundingDetails(CrashReport report, String sectionName, TileEntity tile) {
        if (tile == null) {
            CrashReportCategory cat = report.func_85058_a("Surroundings" + (sectionName == null ? "" : sectionName));
            cat.func_71507_a("Tile?", (Object)"Null");
            return report;
        }
        return CrashHelper.addSurroundingDetails(report, sectionName, tile.func_145831_w(), tile.func_174877_v().func_177958_n(), tile.func_174877_v().func_177956_o(), tile.func_174877_v().func_177952_p());
    }

    public static CrashReport addSurroundingDetails(CrashReport report, String sectionName, final World world, final int x, final int y, final int z) {
        CrashReportCategory cat = report.func_85058_a("Surroundings" + (sectionName == null ? "" : sectionName));
        if (world == null) {
            cat.func_71507_a("World", (Object)"Null");
            cat.func_71507_a("Pos", (Object)(x + "," + y + "," + z));
            return report;
        }
        cat.func_71507_a("Dim", () -> String.valueOf(world.field_73011_w.getDimension()));
        cat.func_71507_a("Dim_Name", () -> "" + world.field_73011_w.func_186058_p().func_186065_b());
        cat.func_71507_a("Pos", (Object)(x + "," + y + "," + z));
        cat.func_71507_a("NeighbourBlocks", (Object)new Callable<String>(){

            @Override
            public String call() throws Exception {
                HashBiMap map = HashBiMap.create();
                map.put((Object)Blocks.field_150350_a, (Object)" ");
                StringBuilder builder = new StringBuilder("\n\n");
                for (int dy = -3; dy <= 3; ++dy) {
                    for (int dx = -3; dx <= 3; ++dx) {
                        builder.append("\t\t");
                        if (dx == -3) {
                            builder.append("dy = ").append(dy);
                        } else {
                            builder.append("\t");
                        }
                        builder.append("[ ");
                        for (int dz = -3; dz <= 3; ++dz) {
                            int x2 = x + dx;
                            int y2 = y + dy;
                            int z2 = z + dz;
                            if (world.func_175667_e(new BlockPos(x2, y2, z2))) {
                                IBlockState state = world.func_180495_p(new BlockPos(x2, y2, z2));
                                Block block = state.func_177230_c();
                                builder.append(this.getNameForObject(block, (HashBiMap<Block, String>)map));
                                int meta = block.func_176201_c(state);
                                if (meta < 0 || meta > 15) {
                                    builder.append('!');
                                } else if (meta == 0 && block == Blocks.field_150350_a) {
                                    builder.append(' ');
                                } else {
                                    builder.append(metaLetters[meta]);
                                }
                            } else {
                                map.put(null, (Object)"X");
                                builder.append("XX");
                            }
                            builder.append(" ");
                        }
                        builder.append(']').append('\n');
                    }
                    builder.append('\n');
                }
                for (Map.Entry entry : map.entrySet()) {
                    builder.append("\t\t'");
                    builder.append((String)entry.getValue());
                    builder.append("': ");
                    Block block = (Block)entry.getKey();
                    if (block == null) {
                        builder.append("No Block Present");
                    } else {
                        builder.append(Block.field_149771_c.func_177774_c((Object)block));
                    }
                    builder.append('\n');
                }
                return builder.toString();
            }

            public String getNameForObject(Block block, HashBiMap<Block, String> map) {
                String s = (String)map.get((Object)block);
                if (s != null) {
                    return s;
                }
                String name = ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)block)).toString();
                if (name != null && name.length() > 0) {
                    String t;
                    int i = name.indexOf(58);
                    if (i >= 0) {
                        name = name.substring(i + 1, name.length());
                    }
                    if (!map.containsValue((Object)(t = name.substring(0, 1).toUpperCase()))) {
                        map.put((Object)block, (Object)t);
                        return t;
                    }
                    for (char c : name.toCharArray()) {
                        if (!Character.isUpperCase(c) || map.containsValue((Object)String.valueOf(c))) continue;
                        map.put((Object)block, (Object)String.valueOf(c));
                        return String.valueOf(c);
                    }
                    for (char c : name.toCharArray()) {
                        if (map.containsValue((Object)String.valueOf(c))) continue;
                        map.put((Object)block, (Object)String.valueOf(c));
                        return String.valueOf(c);
                    }
                }
                for (char c : validLetters) {
                    if (map.containsValue((Object)String.valueOf(c))) continue;
                    map.put((Object)block, (Object)String.valueOf(c));
                    return String.valueOf(c);
                }
                s = "#" + map.size();
                map.put((Object)block, (Object)s);
                return s;
            }
        });
        return report;
    }

    public static void addCallSection(Object object, CrashReport crashReport, String sectionName) {
        CrashReportCategory category = crashReport.func_85058_a(sectionName);
        if (object == null) {
            category.func_71507_a("Null?", (Object)"Null");
            return;
        }
        if (object instanceof Enum) {
            category.func_71507_a("Value", (Object)(object.toString() + " . " + ((Enum)object).ordinal()));
            return;
        }
        if (object instanceof Throwable) {
            category.func_71499_a("Throwable", (Throwable)object);
            return;
        }
        category.func_71507_a("Class", () -> object.getClass().getName());
        category.func_71507_a("ToString", object::toString);
        if (object instanceof TileEntity) {
            TileEntity tile = (TileEntity)object;
            tile.func_145828_a(category);
            category.func_71507_a("Tile Pos", () -> String.format("%d,%d,%d", tile.func_174877_v().func_177958_n(), tile.func_174877_v().func_177956_o(), tile.func_174877_v().func_177952_p()));
            category.func_71507_a("Tile NBT", () -> {
                NBTTagCompound tag = new NBTTagCompound();
                tile.func_189515_b(tag);
                return tag.toString();
            });
        }
    }

    public static void addInventoryContents(CrashReport report, String categoryName, IItemHandler inv) {
        CrashReportCategory category = report.func_85058_a(categoryName);
        if (inv == null) {
            category.func_71507_a("Null?", (Object)"Null");
            return;
        }
        category.func_71507_a("InventoryContents", () -> {
            StringBuilder builder = new StringBuilder("\n\n");
            builder.append(inv.toString()).append(" - ").append(inv.getSlots());
            for (int i = 0; i < inv.getSlots(); ++i) {
                ItemStack stackInSlot;
                builder.append(i).append(" - ");
                try {
                    stackInSlot = inv.getStackInSlot(i);
                }
                catch (Exception e) {
                    builder.append("Errored - ").append(e.toString()).append("\n");
                    continue;
                }
                builder.append(stackInSlot == null ? "Null" : stackInSlot.toString()).append("\n");
            }
            builder.append("\n\n");
            return builder.toString();
        });
    }

    public static void addInventoryContents(CrashReport report, String categoryName, IInventory inv) {
        CrashReportCategory category = report.func_85058_a(categoryName);
        if (inv == null) {
            category.func_71507_a("Null?", (Object)"Null");
            return;
        }
        category.func_71507_a("InventoryContents", () -> {
            StringBuilder builder = new StringBuilder("\n\n");
            builder.append(inv.toString()).append(" - ").append(inv.func_70302_i_());
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack stackInSlot;
                builder.append(i).append(" - ");
                try {
                    stackInSlot = inv.func_70301_a(i);
                }
                catch (Exception e) {
                    builder.append("Errored - ").append(e.toString()).append("\n");
                    continue;
                }
                builder.append(stackInSlot == null ? "Null" : stackInSlot.toString()).append("\n");
            }
            builder.append("\n\n");
            return builder.toString();
        });
    }

    public static CrashReport makeDetailedCrashReport(Exception e, String inserting) {
        return CrashHelper.makeDetailedCrashReport(e, inserting, null, new Object[0]);
    }
}

