/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util;

import cofh.CoFHCore;
import cofh.core.entity.EntityLightningBoltFake;
import cofh.core.init.CoreProps;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.apache.logging.log4j.core.helpers.Loader;

public class CoreUtils {
    public static String getModName(Item item) {
        return item.getRegistryName().func_110624_b();
    }

    public static EntityPlayer getClientPlayer() {
        return CoFHCore.proxy.getClientPlayer();
    }

    public static boolean isPlayer(EntityPlayer player) {
        return player instanceof EntityPlayerMP;
    }

    public static boolean isFakePlayer(Entity player) {
        return player instanceof FakePlayer;
    }

    public static boolean isOp(EntityPlayer player) {
        return CoFHCore.proxy.isOp(player.func_70005_c_());
    }

    public static boolean isOp(String playerName) {
        return CoFHCore.proxy.isOp(playerName);
    }

    public static boolean isClient() {
        return CoFHCore.proxy.isClient();
    }

    public static boolean isServer() {
        return CoFHCore.proxy.isServer();
    }

    public static boolean isBlockUnbreakable(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return state.func_177230_c() instanceof BlockLiquid || state.func_185887_b(world, pos) < 0.0f;
    }

    public static boolean isRedstonePowered(World world, BlockPos pos) {
        if (world.func_175687_A(pos) > 0) {
            return true;
        }
        for (EnumFacing face : EnumFacing.field_82609_l) {
            BlockPos step = pos.func_177972_a(face);
            IBlockState state = world.func_180495_p(step);
            if (!state.equals(Blocks.field_150488_af) || state.func_185911_a((IBlockAccess)world, step, EnumFacing.UP) <= 0) continue;
            return true;
        }
        return false;
    }

    public static boolean isRedstonePowered(TileEntity tile) {
        return CoreUtils.isRedstonePowered(tile.func_145831_w(), tile.func_174877_v());
    }

    public static void dismantleLog(String playerName, Block block, int metadata, BlockPos pos) {
        if (CoreProps.enableDismantleLogging) {
            CoFHCore.LOG.info("Player " + playerName + " dismantled " + " (" + block + ":" + metadata + ") at (" + pos.func_177958_n() + "," + pos.func_177956_o() + "," + pos.func_177952_p() + ")");
        }
    }

    public static void copyFileUsingStream(String source, String dest) throws IOException {
        CoreUtils.copyFileUsingStream(source, new File(dest));
    }

    public static void copyFileUsingStream(String source, File dest) throws IOException {
        int length;
        InputStream is = Loader.getResource((String)source, null).openStream();
        FileOutputStream os = new FileOutputStream(dest);
        byte[] buffer = new byte[1024];
        while ((length = is.read(buffer)) > 0) {
            ((OutputStream)os).write(buffer, 0, length);
        }
    }

    public static void copyFileUsingChannel(File source, File dest) throws IOException {
        FileInputStream sourceStream = new FileInputStream(source);
        FileChannel sourceChannel = sourceStream.getChannel();
        FileOutputStream outputStream = new FileOutputStream(dest);
        outputStream.getChannel().transferFrom(sourceChannel, 0L, sourceChannel.size());
    }

    public static String getSoundName(String modId, String soundpath) {
        soundpath = soundpath.replaceAll("/", ".");
        return String.format("%s:%s", modId, soundpath);
    }

    public static float getSoundVolume(int category) {
        return CoFHCore.proxy.getSoundVolume(category);
    }

    public static boolean dropItemStackIntoWorld(ItemStack stack, World world, Vec3d pos) {
        return CoreUtils.dropItemStackIntoWorld(stack, world, pos, false);
    }

    public static boolean dropItemStackIntoWorldWithVelocity(ItemStack stack, World world, BlockPos pos) {
        return CoreUtils.dropItemStackIntoWorld(stack, world, new Vec3d((Vec3i)pos), true);
    }

    public static boolean dropItemStackIntoWorldWithVelocity(ItemStack stack, World world, Vec3d pos) {
        return CoreUtils.dropItemStackIntoWorld(stack, world, pos, true);
    }

    public static boolean dropItemStackIntoWorld(ItemStack stack, World world, Vec3d pos, boolean velocity) {
        if (stack == null) {
            return false;
        }
        float x2 = 0.5f;
        float y2 = 0.0f;
        float z2 = 0.5f;
        if (velocity) {
            x2 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
            y2 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
            z2 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
        }
        EntityItem entity = new EntityItem(world, pos.field_72450_a + (double)x2, pos.field_72448_b + (double)y2, pos.field_72449_c + (double)z2, stack.func_77946_l());
        if (velocity) {
            entity.field_70159_w = (float)world.field_73012_v.nextGaussian() * 0.05f;
            entity.field_70181_x = (float)world.field_73012_v.nextGaussian() * 0.05f + 0.2f;
            entity.field_70179_y = (float)world.field_73012_v.nextGaussian() * 0.05f;
        } else {
            entity.field_70181_x = -0.05f;
            entity.field_70159_w = 0.0;
            entity.field_70179_y = 0.0;
        }
        world.func_72838_d((Entity)entity);
        return true;
    }

    public static void doFakeExplosion(World world, double x, double y, double z, boolean playSound) {
        world.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, x, y + 1.0, z, 0.0, 0.0, 0.0, new int[0]);
        if (playSound) {
            world.func_184148_a(null, x, y, z, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }

    public static void doFakeLightningBolt(World world, double x, double y, double z) {
        EntityLightningBoltFake bolt = new EntityLightningBoltFake(world, x, y, z);
        world.func_72942_c((Entity)bolt);
    }

    public static boolean teleportEntityTo(Entity entity, BlockPos pos) {
        return CoreUtils.teleportEntityTo(entity, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
    }

    public static boolean teleportEntityTo(Entity entity, double x, double y, double z) {
        if (entity instanceof EntityLivingBase) {
            return CoreUtils.teleportEntityTo((EntityLivingBase)entity, x, y, z);
        }
        entity.func_70012_b(x, y, z, entity.field_70177_z, entity.field_70125_A);
        entity.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
        return true;
    }

    public static boolean teleportEntityTo(EntityLivingBase entity, double x, double y, double z) {
        EnderTeleportEvent event = new EnderTeleportEvent(entity, x, y, z, 0.0f);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        entity.func_70634_a(event.getTargetX(), event.getTargetY(), event.getTargetZ());
        entity.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
        return true;
    }

    public static boolean teleportEntityTo(EntityLivingBase entity, double x, double y, double z, boolean cooldown) {
        if (cooldown) {
            NBTTagCompound tag = entity.getEntityData();
            long time = entity.field_70170_p.func_82737_E();
            if (tag.func_74763_f("cofh:tD") > time) {
                return false;
            }
            tag.func_74772_a("cofh:tD", time + 35L);
        }
        return CoreUtils.teleportEntityTo(entity, x, y, z);
    }
}

