/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.key;

import cofh.core.key.IKeyBinding;
import cofh.core.key.PacketKey;
import gnu.trove.map.TMap;
import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class KeyHandlerCore {
    private static TMap<String, IKeyBinding> clientBinds = new THashMap();
    static TMap<String, IKeyBinding> serverBinds = new THashMap();
    private static ArrayList<IKeyBinding> keys = new ArrayList();

    public static boolean addClientKeyBind(IKeyBinding binding) {
        if (!clientBinds.containsKey((Object)binding.getUUID())) {
            keys.add(binding);
            clientBinds.put((Object)binding.getUUID(), (Object)binding);
            return true;
        }
        return false;
    }

    public static boolean addServerKeyBind(IKeyBinding binding) {
        if (!serverBinds.containsKey((Object)binding.getUUID())) {
            serverBinds.put((Object)binding.getUUID(), (Object)binding);
            return true;
        }
        return false;
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void handleKeyInputEvent(InputEvent.KeyInputEvent event) {
        for (IKeyBinding key : keys) {
            int button = key.getKey();
            if (button <= 0 || !Keyboard.isKeyDown((int)button) || !key.keyPressClient() || !key.hasServerSide()) continue;
            PacketKey.sendToServer(key.getUUID());
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void handleMouseInputEvent(InputEvent.MouseInputEvent event) {
        for (IKeyBinding key : keys) {
            int button = key.getKey();
            if (button >= 0 || !Mouse.isButtonDown((int)(button + 100)) || !key.keyPressClient() || !key.hasServerSide()) continue;
            PacketKey.sendToServer(key.getUUID());
        }
    }

    static {
        MinecraftForge.EVENT_BUS.register((Object)new KeyHandlerCore());
    }
}

