/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.gui.element;

import cofh.api.tileentity.IEnergyInfo;
import cofh.core.init.CoreTextures;
import cofh.lib.gui.GuiBase;
import cofh.lib.gui.element.TabBase;
import cofh.lib.util.helpers.StringHelper;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;

public class TabEnergy
extends TabBase {
    public static int defaultSide = 0;
    public static int defaultHeaderColor = 14797103;
    public static int defaultSubHeaderColor = 11186104;
    public static int defaultTextColor = 0;
    public static int defaultBackgroundColorOut = 13657355;
    public static int defaultBackgroundColorIn = 685776;
    private IEnergyInfo myContainer;
    private boolean isProducer;

    public TabEnergy(GuiBase gui, IEnergyInfo container, boolean isProducer) {
        this(gui, defaultSide, container, isProducer);
    }

    public TabEnergy(GuiBase gui, int side, IEnergyInfo container, boolean producer) {
        super(gui, side);
        this.headerColor = defaultHeaderColor;
        this.subheaderColor = defaultSubHeaderColor;
        this.textColor = defaultTextColor;
        this.backgroundColor = producer ? defaultBackgroundColorOut : defaultBackgroundColorIn;
        this.maxHeight = 92;
        this.maxWidth = 100;
        this.myContainer = container;
        this.isProducer = producer;
    }

    @Override
    protected void drawForeground() {
        this.drawTabIcon(CoreTextures.ICON_ENERGY);
        if (!this.isFullyOpened()) {
            return;
        }
        String powerDirection = this.isProducer ? "info.cofh.energyProduce" : "info.cofh.energyConsume";
        this.getFontRenderer().func_175063_a(StringHelper.localize("info.cofh.energy"), (float)(this.posXOffset() + 20), (float)(this.posY + 6), this.headerColor);
        this.getFontRenderer().func_175063_a(StringHelper.localize(powerDirection) + ":", (float)(this.posXOffset() + 6), (float)(this.posY + 18), this.subheaderColor);
        this.getFontRenderer().func_78276_b(this.myContainer.getInfoEnergyPerTick() + " RF/t", this.posXOffset() + 14, this.posY + 30, this.textColor);
        this.getFontRenderer().func_175063_a(StringHelper.localize("info.cofh.maxPower") + ":", (float)(this.posXOffset() + 6), (float)(this.posY + 42), this.subheaderColor);
        this.getFontRenderer().func_78276_b(this.myContainer.getInfoMaxEnergyPerTick() + " RF/t", this.posXOffset() + 14, this.posY + 54, this.textColor);
        this.getFontRenderer().func_175063_a(StringHelper.localize("info.cofh.energyStored") + ":", (float)(this.posXOffset() + 6), (float)(this.posY + 66), this.subheaderColor);
        this.getFontRenderer().func_78276_b(this.myContainer.getInfoEnergyStored() + " RF", this.posXOffset() + 14, this.posY + 78, this.textColor);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public void addTooltip(List<String> list) {
        if (!this.isFullyOpened()) {
            list.add(this.myContainer.getInfoEnergyPerTick() + " RF/t");
            return;
        }
    }
}

