/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.gui.element;

import cofh.api.tileentity.IReconfigurableFacing;
import cofh.core.init.CoreTextures;
import cofh.core.render.ISidedTexture;
import cofh.core.util.tileentity.IReconfigurableSides;
import cofh.core.util.tileentity.ITransferControl;
import cofh.lib.gui.GuiBase;
import cofh.lib.gui.element.TabBase;
import cofh.lib.util.helpers.BlockHelper;
import cofh.lib.util.helpers.RenderHelper;
import cofh.lib.util.helpers.StringHelper;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;

public class TabConfigurationTransfer
extends TabBase {
    public static int defaultSide = 1;
    public static int defaultHeaderColor = 14797103;
    public static int defaultSubHeaderColor = 11186104;
    public static int defaultTextColor = 0;
    public static int defaultBackgroundColor = 0x226688;
    private IReconfigurableFacing myTileFacing;
    private IReconfigurableSides myTileSides;
    private ISidedTexture myTileTexture;
    private ITransferControl myTileControl;

    public TabConfigurationTransfer(GuiBase gui, IReconfigurableSides theTile) {
        this(gui, defaultSide, theTile);
    }

    public TabConfigurationTransfer(GuiBase gui, int side, IReconfigurableSides theTile) {
        super(gui, side);
        this.headerColor = defaultHeaderColor;
        this.subheaderColor = defaultSubHeaderColor;
        this.textColor = defaultTextColor;
        this.backgroundColor = defaultBackgroundColor;
        this.maxHeight = 92;
        this.maxWidth = 100;
        this.myTileSides = theTile;
        this.myTileFacing = (IReconfigurableFacing)((Object)theTile);
        this.myTileTexture = (ISidedTexture)((Object)theTile);
        this.myTileControl = (ITransferControl)((Object)theTile);
    }

    @Override
    public void addTooltip(List<String> list) {
        if (!this.isFullyOpened()) {
            list.add(StringHelper.localize("info.cofh.configuration"));
            return;
        }
        int x = this.gui.getMouseX() - this.currentShiftX;
        int y = this.gui.getMouseY() - this.currentShiftY;
        if (8 <= x && x < 24 && 34 <= y && y < 50) {
            if (this.myTileControl.hasTransferIn()) {
                list.add(this.myTileControl.getTransferIn() ? StringHelper.localize("gui.cofh.transferInEnabled") : StringHelper.localize("gui.cofh.transferInDisabled"));
            } else {
                list.add(StringHelper.localize("gui.cofh.transferInUnavailable"));
            }
        } else if (8 <= x && x < 24 && 54 <= y && y < 68) {
            if (this.myTileControl.hasTransferOut()) {
                list.add(this.myTileControl.getTransferOut() ? StringHelper.localize("gui.cofh.transferOutEnabled") : StringHelper.localize("gui.cofh.transferOutDisabled"));
            } else {
                list.add(StringHelper.localize("gui.cofh.transferOutUnavailable"));
            }
        }
    }

    @Override
    public boolean onMousePressed(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (!this.isFullyOpened()) {
            return false;
        }
        if (this.side == 0) {
            mouseX += this.currentWidth;
        }
        if ((mouseX -= this.currentShiftX) < 8 || mouseX >= 92 || (mouseY -= this.currentShiftY) < 20 || mouseY >= 84) {
            return super.onMousePressed(mouseX, mouseY, mouseButton);
        }
        if (8 <= mouseX && mouseX < 24 && 34 <= mouseY && mouseY < 50) {
            this.handleTransferChange(0, mouseButton);
        } else if (8 <= mouseX && mouseX < 24 && 54 <= mouseY && mouseY < 68) {
            this.handleTransferChange(1, mouseButton);
        } else if (52 <= mouseX && mouseX < 68 && 24 <= mouseY && mouseY < 40) {
            this.handleSideChange(BlockHelper.SIDE_ABOVE[this.myTileFacing.getFacing()], mouseButton);
        } else if (32 <= mouseX && mouseX < 48 && 44 <= mouseY && mouseY < 60) {
            this.handleSideChange(BlockHelper.SIDE_LEFT[this.myTileFacing.getFacing()], mouseButton);
        } else if (52 <= mouseX && mouseX < 68 && 44 <= mouseY && mouseY < 60) {
            this.handleSideChange(this.myTileFacing.getFacing(), mouseButton);
        } else if (72 <= mouseX && mouseX < 88 && 44 <= mouseY && mouseY < 60) {
            this.handleSideChange(BlockHelper.SIDE_RIGHT[this.myTileFacing.getFacing()], mouseButton);
        } else if (52 <= mouseX && mouseX < 68 && 64 <= mouseY && mouseY < 80) {
            this.handleSideChange(BlockHelper.SIDE_BELOW[this.myTileFacing.getFacing()], mouseButton);
        } else if (72 <= mouseX && mouseX < 88 && 64 <= mouseY && mouseY < 80) {
            this.handleSideChange(BlockHelper.SIDE_OPPOSITE[this.myTileFacing.getFacing()], mouseButton);
        }
        return true;
    }

    @Override
    protected void drawBackground() {
        super.drawBackground();
        if (!this.isFullyOpened()) {
            return;
        }
        float colorR = (float)(this.backgroundColor >> 16 & 0xFF) / 255.0f * 0.6f;
        float colorG = (float)(this.backgroundColor >> 8 & 0xFF) / 255.0f * 0.6f;
        float colorB = (float)(this.backgroundColor & 0xFF) / 255.0f * 0.6f;
        GlStateManager.func_179131_c((float)colorR, (float)colorG, (float)colorB, (float)1.0f);
        this.gui.func_73729_b(this.posX() + 28, this.posY + 20, 16, 20, 64, 64);
        this.gui.func_73729_b(this.posX() + 6, this.posY + 32, 16, 20, 20, 40);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    protected void drawForeground() {
        this.drawTabIcon(CoreTextures.ICON_CONFIG);
        if (!this.isFullyOpened()) {
            return;
        }
        this.getFontRenderer().func_175063_a(StringHelper.localize("info.cofh.configuration"), (float)(this.posXOffset() + 18), (float)(this.posY + 6), this.headerColor);
        RenderHelper.setBlockTextureSheet();
        if (this.myTileControl.hasTransferIn()) {
            this.gui.drawButton(CoreTextures.ICON_INPUT, this.posX() + 8, this.posY + 34, this.myTileControl.getTransferIn() ? 1 : 0);
        } else {
            this.gui.drawButton(CoreTextures.ICON_INPUT, this.posX() + 8, this.posY + 34, 2);
        }
        if (this.myTileControl.hasTransferOut()) {
            this.gui.drawButton(CoreTextures.ICON_OUTPUT, this.posX() + 8, this.posY + 54, this.myTileControl.getTransferOut() ? 1 : 0);
        } else {
            this.gui.drawButton(CoreTextures.ICON_OUTPUT, this.posX() + 8, this.posY + 54, 2);
        }
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        for (int pass = 0; pass < this.myTileTexture.getNumPasses(); ++pass) {
            this.gui.drawIcon(this.myTileTexture.getTexture(BlockHelper.SIDE_ABOVE[this.myTileFacing.getFacing()], pass), this.posX() + 52, this.posY + 24);
            this.gui.drawIcon(this.myTileTexture.getTexture(BlockHelper.SIDE_LEFT[this.myTileFacing.getFacing()], pass), this.posX() + 32, this.posY + 44);
            this.gui.drawIcon(this.myTileTexture.getTexture(this.myTileFacing.getFacing(), pass), this.posX() + 52, this.posY + 44);
            this.gui.drawIcon(this.myTileTexture.getTexture(BlockHelper.SIDE_RIGHT[this.myTileFacing.getFacing()], pass), this.posX() + 72, this.posY + 44);
            this.gui.drawIcon(this.myTileTexture.getTexture(BlockHelper.SIDE_BELOW[this.myTileFacing.getFacing()], pass), this.posX() + 52, this.posY + 64);
            this.gui.drawIcon(this.myTileTexture.getTexture(BlockHelper.SIDE_OPPOSITE[this.myTileFacing.getFacing()], pass), this.posX() + 72, this.posY + 64);
        }
        GlStateManager.func_179084_k();
        RenderHelper.setDefaultFontTextureSheet();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    void handleTransferChange(int direction, int mouseButton) {
        if (direction == 0) {
            if (this.myTileControl.setTransferIn(!this.myTileControl.getTransferIn())) {
                GuiBase.playClickSound(1.0f, this.myTileControl.getTransferIn() ? 0.8f : 0.4f);
            }
        } else if (this.myTileControl.setTransferOut(!this.myTileControl.getTransferOut())) {
            GuiBase.playClickSound(1.0f, this.myTileControl.getTransferOut() ? 0.8f : 0.4f);
        }
    }

    void handleSideChange(int side, int mouseButton) {
        if (GuiScreen.func_146272_n()) {
            if (side == this.myTileFacing.getFacing()) {
                if (this.myTileSides.resetSides()) {
                    GuiBase.playClickSound(1.0f, 0.2f);
                }
            } else if (this.myTileSides.setSide(side, 0)) {
                GuiBase.playClickSound(1.0f, 0.4f);
            }
            return;
        }
        if (mouseButton == 0) {
            if (this.myTileSides.incrSide(side)) {
                GuiBase.playClickSound(1.0f, 0.8f);
            }
        } else if (mouseButton == 1 && this.myTileSides.decrSide(side)) {
            GuiBase.playClickSound(1.0f, 0.6f);
        }
    }
}

