/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.command;

import cofh.core.command.CommandHandler;
import cofh.core.command.ISubCommand;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandNotFoundException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.NumberInvalidException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;

public class CommandSyntax
implements ISubCommand {
    public static CommandSyntax instance = new CommandSyntax();

    @Override
    public String getCommandName() {
        return "syntax";
    }

    @Override
    public int getPermissionLevel() {
        return -1;
    }

    @Override
    public void handleCommand(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        int page;
        ArrayList<String> commandList = new ArrayList<String>(CommandHandler.getCommandList());
        commandList.sort(String.CASE_INSENSITIVE_ORDER);
        commandList.remove(this.getCommandName());
        for (int i = 0; i < commandList.size(); ++i) {
            String name = (String)commandList.get(i);
            if (CommandHandler.canUseCommand(sender, CommandHandler.getCommandPermission(name), name)) continue;
            commandList.remove(i--);
        }
        int pageSize = 7;
        int maxPages = (commandList.size() - 1) / 7;
        try {
            page = args.length == 1 ? 0 : CommandBase.func_175764_a((String)args[1], (int)1, (int)(maxPages + 1)) - 1;
        }
        catch (NumberInvalidException numberinvalidexception) {
            String commandName = args[1];
            if (!CommandHandler.getCommandExists(commandName)) {
                throw new CommandNotFoundException("chat.cofh.command.notFound", new Object[0]);
            }
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("chat.cofh.command." + commandName + ".syntax", new Object[0]));
            return;
        }
        int maxIndex = Math.min((page + 1) * 7, commandList.size());
        TextComponentTranslation chatcomponenttranslation1 = new TextComponentTranslation("commands.help.header", new Object[]{page + 1, maxPages + 1});
        chatcomponenttranslation1.func_150256_b().func_150238_a(TextFormatting.DARK_GREEN);
        sender.func_145747_a((ITextComponent)chatcomponenttranslation1);
        for (int i = page * 7; i < maxIndex; ++i) {
            TextComponentString chatcomponenttranslation = new TextComponentString("/cofh \u00a7e" + (String)commandList.get(i));
            chatcomponenttranslation.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/cofh syntax " + (String)commandList.get(i)));
            sender.func_145747_a((ITextComponent)chatcomponenttranslation);
        }
    }

    @Override
    public List<String> addTabCompletionOptions(MinecraftServer server, ICommandSender sender, String[] args) {
        if (args.length == 2) {
            return CommandBase.func_175762_a((String[])args, CommandHandler.getCommandList());
        }
        return null;
    }
}

