/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.block;

import cofh.api.core.ISecurable;
import cofh.core.init.CoreProps;
import cofh.core.network.PacketBase;
import cofh.core.network.PacketCoFHBase;
import cofh.core.network.PacketHandler;
import cofh.core.network.PacketTile;
import cofh.core.network.PacketTileInfo;
import cofh.core.util.CoreUtils;
import cofh.core.util.RegistrySocial;
import cofh.core.util.helpers.SecurityHelper;
import cofh.lib.util.helpers.ServerHelper;
import com.mojang.authlib.GameProfile;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;

public abstract class TileCore
extends TileEntity {
    public abstract String getTileName();

    public abstract int getType();

    public void blockBroken() {
    }

    public void blockDismantled() {
        this.blockBroken();
    }

    public void blockPlaced() {
    }

    public void callBlockUpdate() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
    }

    public void callNeighborStateChange() {
        this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q());
    }

    public void callNeighborTileChange() {
        this.field_145850_b.func_175666_e(this.field_174879_c, this.func_145838_q());
    }

    public void markChunkDirty() {
        this.field_145850_b.func_175646_b(this.field_174879_c, (TileEntity)this);
    }

    public void onChunkUnload() {
        if (!this.field_145846_f) {
            this.func_145843_s();
        }
    }

    public void onLoad() {
    }

    public void onNeighborBlockChange() {
    }

    public void onNeighborTileChange(BlockPos pos) {
    }

    public boolean canPlayerAccess(EntityPlayer player) {
        if (!(this instanceof ISecurable)) {
            return true;
        }
        ISecurable.AccessMode access = ((ISecurable)((Object)this)).getAccess();
        String name = player.func_70005_c_();
        if (access.isPublic() || CoreProps.enableOpSecureAccess && CoreUtils.isOp(name)) {
            return true;
        }
        GameProfile profile = ((ISecurable)((Object)this)).getOwner();
        UUID ownerID = profile.getId();
        if (SecurityHelper.isDefaultUUID(ownerID)) {
            return true;
        }
        UUID otherID = SecurityHelper.getID(player);
        if (ownerID.equals(otherID)) {
            return true;
        }
        return access.isFriendsOnly() && RegistrySocial.playerHasAccess(name, profile);
    }

    public boolean canPlayerDismantle(EntityPlayer player) {
        return true;
    }

    public boolean isUsable(EntityPlayer player) {
        return player.func_174818_b(this.field_174879_c) <= 64.0 && this.field_145850_b.func_175625_s(this.field_174879_c) == this;
    }

    public boolean onWrench(EntityPlayer player, EnumFacing side) {
        return false;
    }

    public int getComparatorInputOverride() {
        return 0;
    }

    public int getLightValue() {
        return 0;
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state;
    }

    protected final boolean timeCheck() {
        return this.field_145850_b.func_82737_E() % 32L == 0L;
    }

    protected final boolean timeCheckHalf() {
        return this.field_145850_b.func_82737_E() % 16L == 0L;
    }

    protected final boolean timeCheckQuarter() {
        return this.field_145850_b.func_82737_E() % 8L == 0L;
    }

    protected final boolean timeCheckEighth() {
        return this.field_145850_b.func_82737_E() % 4L == 0L;
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return PacketHandler.toTilePacket(this.getTilePacket(), this.func_174877_v());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        PacketHandler.handleNBTPacket(pkt.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        return PacketHandler.toNBTTag(this.getTilePacket(), super.func_189517_E_());
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        PacketHandler.handleNBTPacket(tag);
    }

    public PacketCoFHBase getAccessPacket() {
        PacketTileInfo payload = PacketTileInfo.newPacket(this);
        payload.addByte(TilePacketID.C_ACCESS.ordinal());
        return payload;
    }

    public PacketCoFHBase getConfigPacket() {
        PacketTileInfo payload = PacketTileInfo.newPacket(this);
        payload.addByte(TilePacketID.C_CONFIG.ordinal());
        return payload;
    }

    public PacketCoFHBase getModePacket() {
        PacketTileInfo payload = PacketTileInfo.newPacket(this);
        payload.addByte(TilePacketID.C_MODE.ordinal());
        return payload;
    }

    protected void handleAccessPacket(PacketCoFHBase payload) {
        this.markChunkDirty();
    }

    protected void handleConfigPacket(PacketCoFHBase payload) {
        this.markChunkDirty();
    }

    protected void handleModePacket(PacketCoFHBase payload) {
        this.markChunkDirty();
        this.callNeighborTileChange();
    }

    public void sendAccessPacket() {
        if (ServerHelper.isClientWorld(this.field_145850_b)) {
            PacketHandler.sendToServer(this.getAccessPacket());
        }
    }

    public void sendConfigPacket() {
        if (ServerHelper.isClientWorld(this.field_145850_b)) {
            PacketHandler.sendToServer(this.getConfigPacket());
        }
    }

    public void sendModePacket() {
        if (ServerHelper.isClientWorld(this.field_145850_b)) {
            PacketHandler.sendToServer(this.getModePacket());
        }
    }

    public PacketCoFHBase getFluidPacket() {
        PacketTileInfo payload = PacketTileInfo.newPacket(this);
        payload.addByte(TilePacketID.S_FLUID.ordinal());
        return payload;
    }

    public PacketCoFHBase getGuiPacket() {
        PacketTileInfo payload = PacketTileInfo.newPacket(this);
        payload.addByte(TilePacketID.S_GUI.ordinal());
        return payload;
    }

    public PacketCoFHBase getTilePacket() {
        return new PacketTile(this);
    }

    protected void handleFluidPacket(PacketCoFHBase payload) {
    }

    protected void handleGuiPacket(PacketCoFHBase payload) {
    }

    public void sendFluidPacket() {
        PacketHandler.sendToDimension(this.getFluidPacket(), this.field_145850_b.field_73011_w.getDimension());
    }

    public void sendTilePacket(Side side) {
        if (this.field_145850_b == null) {
            return;
        }
        if (side == Side.CLIENT && ServerHelper.isServerWorld(this.field_145850_b)) {
            PacketHandler.sendToAllAround((PacketBase)this.getTilePacket(), this);
        } else if (side == Side.SERVER && ServerHelper.isClientWorld(this.field_145850_b)) {
            PacketHandler.sendToServer(this.getTilePacket());
        }
    }

    protected void updateLighting() {
        int light2 = this.field_145850_b.func_175642_b(EnumSkyBlock.BLOCK, this.func_174877_v());
        int light1 = this.getLightValue();
        if (light1 != light2 && this.field_145850_b.func_180500_c(EnumSkyBlock.BLOCK, this.func_174877_v())) {
            IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        }
    }

    public Object getGuiClient(InventoryPlayer inventory) {
        return null;
    }

    public Object getGuiServer(InventoryPlayer inventory) {
        return null;
    }

    public int getInvSlotCount() {
        return 0;
    }

    public boolean hasGui() {
        return false;
    }

    public boolean openGui(EntityPlayer player) {
        return false;
    }

    public void receiveGuiNetworkData(int id, int data) {
    }

    public void sendGuiNetworkData(Container container, IContainerListener player) {
    }

    public static enum TilePacketID {
        C_ACCESS,
        C_CONFIG,
        C_MODE,
        S_FLUID,
        S_GUI;

    }
}

