/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.init;

import erogenousbeef.bigreactors.common.BigReactors;
import erogenousbeef.bigreactors.common.CommonProxy;
import erogenousbeef.bigreactors.common.block.BlockBR;
import erogenousbeef.bigreactors.common.block.BlockBRGenericFluid;
import erogenousbeef.bigreactors.common.item.ItemBase;
import erogenousbeef.bigreactors.init.BrBlocks;
import erogenousbeef.bigreactors.init.BrFluids;
import erogenousbeef.bigreactors.init.BrItems;
import it.zerono.mods.zerocore.lib.IGameObject;
import it.zerono.mods.zerocore.lib.IModInitializationHandler;
import it.zerono.mods.zerocore.util.OreDictionaryHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLMissingMappingsEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.oredict.OreDictionary;

public final class InitHandler
implements IModInitializationHandler {
    public static final InitHandler INSTANCE = new InitHandler();
    private List<IGameObject> _objects = new ArrayList<IGameObject>();
    private final LowerCaseRemapper<Block> _remapBlocks = new LowerCaseRemapper();
    private final LowerCaseRemapper<Item> _remapItems = new LowerCaseRemapper();
    private CommonProxy _proxy = BigReactors.getProxy();

    public void onPreInit(FMLPreInitializationEvent event) {
        BrFluids.initialize();
        BrItems.initialize();
        BrBlocks.initialize();
    }

    public void onInit(FMLInitializationEvent event) {
        if (!OreDictionaryHelper.doesOreNameExist((String)"blockSnow")) {
            OreDictionary.registerOre((String)"blockSnow", (ItemStack)new ItemStack(Blocks.field_150433_aE, 1));
        }
        if (!OreDictionaryHelper.doesOreNameExist((String)"blockIce")) {
            OreDictionary.registerOre((String)"blockIce", (ItemStack)new ItemStack(Blocks.field_150432_aD, 1));
        }
        for (IGameObject obj : this._objects) {
            obj.registerOreDictionaryEntries();
        }
        for (IGameObject obj : this._objects) {
            obj.registerRecipes();
        }
    }

    public void onPostInit(FMLPostInitializationEvent event) {
        this._objects.clear();
        this._objects = null;
        this._proxy = null;
    }

    public void onMissingMapping(FMLMissingMappingsEvent event) {
        for (FMLMissingMappingsEvent.MissingMapping mapping : event.get()) {
            switch (mapping.type) {
                case ITEM: {
                    this._remapItems.remap(mapping);
                    break;
                }
                case BLOCK: {
                    this._remapBlocks.remap(mapping);
                }
            }
        }
    }

    private InitHandler() {
    }

    protected ItemBase register(ItemBase item) {
        this._objects.add(item);
        ItemBase result = this._proxy.register(item);
        this.addRemapEntry(result);
        return result;
    }

    protected BlockBR register(BlockBR block) {
        this._objects.add(block);
        BlockBR result = this._proxy.register(block);
        this.addRemapEntry(result);
        return result;
    }

    protected BlockBRGenericFluid register(BlockBRGenericFluid block) {
        this._objects.add(block);
        BlockBRGenericFluid result = this._proxy.register(block);
        this.addRemapEntry((Block)result);
        return result;
    }

    protected void register(Class<? extends TileEntity> tileEntityClass) {
        GameRegistry.registerTileEntity(tileEntityClass, (String)("bigreactors" + tileEntityClass.getSimpleName()));
    }

    private void addRemapEntry(Block block) {
        this._remapBlocks.add(block);
        Item itemBlock = (Item)Item.field_150901_e.func_82594_a((Object)block.getRegistryName());
        if (null != itemBlock) {
            this.addRemapEntry(itemBlock);
        }
    }

    private void addRemapEntry(Item item) {
        this._remapItems.add(item);
    }

    private static class LowerCaseRemapper<T extends IForgeRegistryEntry<T>> {
        private Map<String, T> _map = new HashMap<String, T>();

        LowerCaseRemapper() {
        }

        public void add(T entry) {
            this._map.put(entry.getRegistryName().func_110623_a(), entry);
        }

        void remap(FMLMissingMappingsEvent.MissingMapping mapping) {
            String candidateName = mapping.resourceLocation.func_110623_a().toLowerCase();
            if (this._map.containsKey(candidateName)) {
                IForgeRegistryEntry replacement = (IForgeRegistryEntry)this._map.get(candidateName);
                if (GameRegistry.Type.BLOCK == mapping.type && replacement instanceof Block) {
                    mapping.remap((Block)replacement);
                } else if (GameRegistry.Type.ITEM == mapping.type && replacement instanceof Item) {
                    mapping.remap((Item)replacement);
                }
            }
        }
    }
}

