/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.item;

import erogenousbeef.bigreactors.common.BigReactors;
import erogenousbeef.bigreactors.common.MetalType;
import erogenousbeef.bigreactors.common.item.ItemBase;
import it.zerono.mods.zerocore.lib.MetalSize;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class ItemBRMetal
extends ItemBase {
    private MetalSize _size;
    private List<ItemStack> _subItems;

    public ItemBRMetal(String itemName, MetalSize size) {
        super(itemName);
        this.func_77627_a(true);
        this.func_77656_e(0);
        this._size = size;
        this._subItems = null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onPostClientRegister() {
        ResourceLocation location = this.getRegistryName();
        for (MetalType metal : MetalType.values()) {
            ModelLoader.setCustomModelResourceLocation((Item)this, (int)metal.toMeta(), (ModelResourceLocation)new ModelResourceLocation(location, String.format("metal=%s", metal.func_176610_l())));
        }
    }

    @Override
    public void registerOreDictionaryEntries() {
        MetalType[] types = MetalType.values();
        int length = types.length;
        for (int i = 0; i < length; ++i) {
            OreDictionary.registerOre((String)types[i].getOreDictionaryName(this._size), (ItemStack)this.createItemStack(types[i], 1));
        }
        if (BigReactors.CONFIG.registerYelloriumAsUranium) {
            OreDictionary.registerOre((String)(this._size.oreDictionaryPrefix + "Uranium"), (ItemStack)this.createItemStack(MetalType.Yellorium, 1));
            OreDictionary.registerOre((String)(this._size.oreDictionaryPrefix + "Plutonium"), (ItemStack)this.createItemStack(MetalType.Blutonium, 1));
        }
    }

    @Override
    public int func_77647_b(int damage) {
        return damage;
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77658_a() + "." + MetalType.fromMeta(stack.func_77960_j()).func_176610_l();
    }

    public void func_150895_a(Item item, CreativeTabs creativeTabs, List<ItemStack> list) {
        if (null == this._subItems) {
            MetalType[] types = MetalType.VALUES;
            int length = types.length;
            this._subItems = new ArrayList<ItemStack>(length);
            for (int i = 0; i < length; ++i) {
                this._subItems.add(new ItemStack(item, 1, types[i].toMeta()));
            }
        }
        list.addAll(this._subItems);
    }

    public ItemStack createItemStack(MetalType metal, int amount) {
        return new ItemStack((Item)this, amount, metal.toMeta());
    }
}

