/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.client.renderer;

import erogenousbeef.bigreactors.common.multiblock.MultiblockReactor;
import erogenousbeef.bigreactors.common.multiblock.helpers.FuelAssembly;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorFuelRod;
import erogenousbeef.bigreactors.init.BrFluids;
import it.zerono.mods.zerocore.lib.BlockFacings;
import it.zerono.mods.zerocore.lib.client.render.ModRenderHelper;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RendererReactorFuelRod
extends TileEntitySpecialRenderer<TileEntityReactorFuelRod> {
    public void renderTileEntityAt(TileEntityReactorFuelRod rod, double x, double y, double z, float partialTicks, int destroyStage) {
        FuelAssembly assembly = rod.getFuelAssembly();
        MultiblockReactor reactor = rod.getReactorController();
        if (null == assembly || null == reactor || !reactor.isAssembled() || reactor.isInteriorInvisible()) {
            return;
        }
        World world = this.func_178459_a();
        BlockPos rodPosition = rod.getWorldPosition();
        int rodsCount = assembly.getFueldRodsCount();
        EnumFacing.Axis axis = assembly.getAxis();
        Fluid fluid = BrFluids.fluidFuelColumn;
        int fuelColor = assembly.getFuelColor();
        int wasteColor = assembly.getWasteColor();
        float rodCapacity = 4000.0f;
        if (EnumFacing.Axis.Y == axis) {
            boolean gotFuel;
            int rodIndex = rodPosition.func_177956_o() - reactor.getMinimumCoord().func_177956_o() - 1;
            FuelAssembly.FuelRodData rodData = assembly.getFuelRodData(rodIndex);
            if (null == rodData) {
                return;
            }
            BlockFacings facesToDraw = BlockFacings.ALL;
            float wasteHight = rodData.getWasteAmount() / 4000.0f;
            float fuelHight = rodData.getFuelAmount() / 4000.0f;
            boolean gotWaste = wasteHight > 0.0f;
            boolean bl = gotFuel = fuelHight > 0.0f;
            if (gotWaste && gotFuel) {
                float offset = MathHelper.func_76126_a((float)(((float)world.func_82737_E() + partialTicks) * 0.1f)) * 0.01f;
                int brightness = world.func_175626_b(rodPosition, fluid.getLuminosity());
                facesToDraw = facesToDraw.set(EnumFacing.DOWN, 0 == rodIndex);
                facesToDraw = facesToDraw.set(EnumFacing.UP, false);
                ModRenderHelper.renderFluidCube((Fluid)fluid, (BlockFacings)facesToDraw, (double)x, (double)y, (double)z, (double)0.005, (double)0.0, (double)0.005, (double)0.995, (double)(wasteHight += offset), (double)0.995, (int)wasteColor, (int)brightness);
                facesToDraw = facesToDraw.set(EnumFacing.DOWN, false);
                facesToDraw = facesToDraw.set(EnumFacing.UP, rodsCount - 1 == rodIndex || rodData.getFuelAmount() + 4000.0f * (float)rodIndex >= assembly.getFuelQuota());
                ModRenderHelper.renderFluidCube((Fluid)fluid, (BlockFacings)facesToDraw, (double)x, (double)(y + (double)wasteHight), (double)z, (double)0.005, (double)0.0, (double)0.005, (double)0.995, (double)(fuelHight -= offset), (double)0.995, (int)fuelColor, (int)brightness);
            } else if (gotWaste) {
                facesToDraw = facesToDraw.set(EnumFacing.DOWN, 0 == rodIndex);
                facesToDraw = facesToDraw.set(EnumFacing.UP, rodsCount - 1 == rodIndex || rodData.getWasteAmount() + 4000.0f * (float)rodIndex >= assembly.getWasteQuota());
                int brightness = world.func_175626_b(rodPosition, fluid.getLuminosity());
                ModRenderHelper.renderFluidCube((Fluid)fluid, (BlockFacings)facesToDraw, (double)x, (double)y, (double)z, (double)0.005, (double)0.0, (double)0.005, (double)0.995, (double)wasteHight, (double)0.995, (int)wasteColor, (int)brightness);
            } else if (gotFuel) {
                facesToDraw = facesToDraw.set(EnumFacing.DOWN, 0 == rodIndex);
                facesToDraw = facesToDraw.set(EnumFacing.UP, rodsCount - 1 == rodIndex || fuelHight + wasteHight < 1.0f || fuelHight + 4000.0f * (float)rodIndex >= assembly.getFuelQuota());
                int brightness = world.func_175626_b(rodPosition, fluid.getLuminosity());
                ModRenderHelper.renderFluidCube((Fluid)fluid, (BlockFacings)facesToDraw, (double)x, (double)(y + (double)wasteHight), (double)z, (double)0.005, (double)0.0, (double)0.005, (double)0.995, (double)fuelHight, (double)0.995, (int)fuelColor, (int)brightness);
            }
        } else {
            boolean gotFuel;
            double z2;
            double z1;
            double x2;
            double x1;
            float myFuelQuota = assembly.getFuelRodFuelQuota();
            float myWasteQuota = assembly.getFuelRodWasteQuota();
            if (EnumFacing.Axis.X == axis) {
                x1 = 0.0;
                x2 = 1.0;
                z1 = 0.005;
                z2 = 0.995;
            } else {
                x1 = 0.005;
                x2 = 0.995;
                z1 = 0.0;
                z2 = 1.0;
            }
            float wasteHight = myWasteQuota / 4000.0f;
            float fuelHight = myFuelQuota / 4000.0f;
            boolean gotWaste = wasteHight > 0.0f;
            boolean bl = gotFuel = fuelHight > 0.0f;
            if (gotWaste && gotFuel) {
                float offset = MathHelper.func_76126_a((float)(((float)world.func_82737_E() + partialTicks) * 0.1f)) * 0.01f;
                int brightness = world.func_175626_b(rodPosition, fluid.getLuminosity());
                BlockFacings facesToDraw = BlockFacings.from((boolean)true, (boolean)false, (axis != EnumFacing.Axis.Z ? 1 : 0) != 0, (axis != EnumFacing.Axis.Z ? 1 : 0) != 0, (axis != EnumFacing.Axis.X ? 1 : 0) != 0, (axis != EnumFacing.Axis.X ? 1 : 0) != 0);
                ModRenderHelper.renderFluidCube((Fluid)fluid, (BlockFacings)facesToDraw, (double)x, (double)y, (double)z, (double)x1, (double)0.005, (double)z1, (double)x2, (double)(wasteHight += offset), (double)z2, (int)wasteColor, (int)brightness);
                facesToDraw = facesToDraw.set(EnumFacing.DOWN, false);
                facesToDraw = facesToDraw.set(EnumFacing.UP, true);
                ModRenderHelper.renderFluidCube((Fluid)fluid, (BlockFacings)facesToDraw, (double)x, (double)(y + (double)wasteHight), (double)z, (double)x1, (double)0.0, (double)z1, (double)x2, (double)((double)(fuelHight -= offset) - 0.005), (double)z2, (int)fuelColor, (int)brightness);
            } else if (gotWaste) {
                BlockFacings facesToDraw = BlockFacings.from((boolean)true, (boolean)true, (axis != EnumFacing.Axis.Z ? 1 : 0) != 0, (axis != EnumFacing.Axis.Z ? 1 : 0) != 0, (axis != EnumFacing.Axis.X ? 1 : 0) != 0, (axis != EnumFacing.Axis.X ? 1 : 0) != 0);
                int brightness = world.func_175626_b(rodPosition, fluid.getLuminosity());
                ModRenderHelper.renderFluidCube((Fluid)fluid, (BlockFacings)facesToDraw, (double)x, (double)y, (double)z, (double)x1, (double)0.005, (double)z1, (double)x2, (double)((double)wasteHight - 0.005), (double)z2, (int)wasteColor, (int)brightness);
            } else if (gotFuel) {
                BlockFacings facesToDraw = BlockFacings.from((boolean)true, (boolean)true, (axis != EnumFacing.Axis.Z ? 1 : 0) != 0, (axis != EnumFacing.Axis.Z ? 1 : 0) != 0, (axis != EnumFacing.Axis.X ? 1 : 0) != 0, (axis != EnumFacing.Axis.X ? 1 : 0) != 0);
                int brightness = world.func_175626_b(rodPosition, fluid.getLuminosity());
                ModRenderHelper.renderFluidCube((Fluid)fluid, (BlockFacings)facesToDraw, (double)x, (double)(y + (double)wasteHight), (double)z, (double)x1, (double)0.005, (double)z1, (double)x2, (double)((double)fuelHight - 0.005), (double)z2, (int)fuelColor, (int)brightness);
            }
        }
    }
}

