/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks;

import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLMissingMappingsEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import shetiphian.core.common.MyCreativeTab;
import shetiphian.endertanks.Recipes;
import shetiphian.endertanks.Registry;
import shetiphian.endertanks.Values;
import shetiphian.endertanks.common.misc.ConfigHandler;
import shetiphian.endertanks.common.misc.ProxyCommon;
import shetiphian.endertanks.common.misc.TankHelper;
import shetiphian.endertanks.modintegration.ModIntegration;

@Mod(modid="endertanks", name="EnderTanks", version="1.4.11", dependencies="required-after:shetiphiancore@[v3.3.5,)", guiFactory="shetiphian.endertanks.client.misc.ConfigGUIHandler", updateJSON="https://gist.githubusercontent.com/ShetiPhian/8f54131fc6436c8c85a5/raw/EnderTanks", acceptedMinecraftVersions="[1.10]")
public class EnderTanks {
    @SidedProxy(clientSide="shetiphian.endertanks.client.misc.ProxyClient", serverSide="shetiphian.endertanks.common.misc.ProxyCommon")
    public static ProxyCommon proxy;
    @Mod.Instance(value="endertanks")
    public static EnderTanks INSTANCE;
    public static final String MOD_ID = "endertanks";

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Values.logEnderTanks = event.getModLog();
        Values.tabEnderTanks = new MyCreativeTab("EnderTanks");
        Values.minecraftDir = event.getModConfigurationDirectory().getParentFile().getAbsolutePath();
        proxy.setupConfig(event.getSuggestedConfigurationFile());
        new Registry().doRegistration();
        proxy.renderingPreInt();
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        if (Values.blockEnderTank == null || Values.itemEnderBucket == null) {
            return;
        }
        proxy.renderingInt();
        proxy.registerEventHandlers();
        ConfigHandler.INSTANCE.processUpgradeItemStrings();
        new Recipes().loadRecipes();
        new ModIntegration();
    }

    @Mod.EventHandler
    public void fmlMissingMappingsEvent(FMLMissingMappingsEvent event) {
        for (FMLMissingMappingsEvent.MissingMapping mapping : event.getAll()) {
            if (Values.itemEnderBucket == null || !mapping.name.equalsIgnoreCase("EnderTanks:itemEnderBucket") || mapping.type != GameRegistry.Type.ITEM) continue;
            Values.logEnderTanks.info("Item Remap: " + mapping.name + " > " + Values.itemEnderBucket.getRegistryName());
            mapping.remap(Values.itemEnderBucket);
        }
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartedEvent event) {
        TankHelper.INSTANCE.loadTankData();
    }

    @Mod.EventHandler
    public void serverStopped(FMLServerStoppedEvent event) {
        TankHelper.INSTANCE.unloadTankData();
    }

    public static ItemStack getCustomItemStack(String name, int ... amount) {
        return Values.stacks.get(name, amount);
    }
}

