/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.utils.datastructures;

import com.google.common.base.Throwables;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.apache.logging.log4j.Level;

public class FieldSetter<C, V> {
    private static Object reflectionFactory;
    private static Method newConstructorAccessor;
    private static Method newInstance;
    private static Method newFieldAccessor;
    private static Method fieldAccessorSet;
    private Field field;
    private final Object fieldAccessor;

    public FieldSetter(Class<C> clazz, String ... fieldNames) {
        this.field = ReflectionHelper.findField(clazz, (String[])fieldNames);
        this.field.setAccessible(true);
        try {
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(this.field, this.field.getModifiers() & 0xFFFFFFEF);
            this.fieldAccessor = newFieldAccessor.invoke(reflectionFactory, this.field, false);
        }
        catch (IllegalAccessException | NoSuchFieldException | InvocationTargetException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public void apply(C owner, V object) {
        try {
            fieldAccessorSet.invoke(this.fieldAccessor, owner, object);
        }
        catch (Exception e) {
            FMLLog.getLogger().log(Level.WARN, "Unable to set {} with value {}", new Object[]{this.field, object});
        }
    }

    static {
        try {
            Method getReflectionFactory = Class.forName("sun.reflect.ReflectionFactory").getDeclaredMethod("getReflectionFactory", new Class[0]);
            reflectionFactory = getReflectionFactory.invoke(null, new Object[0]);
            newConstructorAccessor = Class.forName("sun.reflect.ReflectionFactory").getDeclaredMethod("newConstructorAccessor", Constructor.class);
            newInstance = Class.forName("sun.reflect.ConstructorAccessor").getDeclaredMethod("newInstance", Object[].class);
            newFieldAccessor = Class.forName("sun.reflect.ReflectionFactory").getDeclaredMethod("newFieldAccessor", Field.class, Boolean.TYPE);
            fieldAccessorSet = Class.forName("sun.reflect.FieldAccessor").getDeclaredMethod("set", Object.class, Object.class);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }
}

