/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.transfernodes;

import com.google.common.collect.Lists;
import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.fluids.FluidTankSerial;
import com.rwtema.extrautils2.gui.backend.DynamicContainer;
import com.rwtema.extrautils2.gui.backend.DynamicContainerTile;
import com.rwtema.extrautils2.gui.backend.IDynamicHandler;
import com.rwtema.extrautils2.gui.backend.IWidget;
import com.rwtema.extrautils2.gui.backend.WidgetFluidIndicator;
import com.rwtema.extrautils2.gui.backend.WidgetSlotItemHandler;
import com.rwtema.extrautils2.gui.backend.WidgetTextData;
import com.rwtema.extrautils2.itemhandler.InventoryHelper;
import com.rwtema.extrautils2.itemhandler.SingleStackHandlerFilter;
import com.rwtema.extrautils2.network.XUPacketBuffer;
import com.rwtema.extrautils2.transfernodes.FacingHelper;
import com.rwtema.extrautils2.transfernodes.GrocketType;
import com.rwtema.extrautils2.transfernodes.IPipe;
import com.rwtema.extrautils2.transfernodes.TransferNodeBase;
import com.rwtema.extrautils2.transfernodes.Upgrade;
import com.rwtema.extrautils2.utils.CapGetter;
import com.rwtema.extrautils2.utils.helpers.BlockStates;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.IItemHandler;

public class TransferNodeFluid
extends TransferNodeBase<IFluidHandler>
implements IDynamicHandler {
    SingleStackHandlerFilter.FluidFilter filter = this.registerNBT("Filter", new SingleStackHandlerFilter.FluidFilter(){

        @Override
        protected void onContentsChanged() {
            TransferNodeFluid.this.holder.func_70296_d();
        }
    });
    protected FluidTankSerial tank = this.registerNBT("Buffer", new FluidTankSerial(1000){

        @Override
        protected void onChange() {
            TransferNodeFluid.this.holder.func_70296_d();
        }

        @Override
        public int fill(FluidStack resource, boolean doFill) {
            if (resource == null || !TransferNodeFluid.this.filter.matches(resource)) {
                return 0;
            }
            return super.fill(resource, doFill);
        }
    });

    @Override
    public List<ItemStack> getDrops() {
        ArrayList drops = Lists.newArrayList();
        drops.add(this.getBaseDrop());
        for (ItemStack itemStack : InventoryHelper.getItemHandlerIterator((IItemHandler)this.upgradeHandler)) {
            if (!StackHelper.isNonNull(itemStack)) continue;
            drops.add(itemStack);
        }
        if (StackHelper.isNonNull(this.filter.getStack())) {
            drops.add(this.filter.getStack());
        }
        return drops;
    }

    @Override
    protected boolean shouldAdvance() {
        return !this.tank.isEmpty();
    }

    public int getDrainAmount() {
        return this.getUpgradeLevel(Upgrade.STACK_SIZE) > 0 ? 12800 : 200;
    }

    @Override
    protected void processBuffer(@Nullable IFluidHandler attached) {
        if (attached != null) {
            int fill;
            FluidStack drain = attached.drain(this.getDrainAmount(), false);
            if (drain != null && (fill = this.tank.fill(drain, false)) > 0) {
                this.tank.fill(attached.drain(fill, true), true);
            }
        } else {
            int upgradeLevel = this.getUpgradeLevel(Upgrade.MINING);
            if (upgradeLevel > 0) {
                BlockPos offset;
                FluidStack fluid = this.tank.getFluid();
                if (fluid != null && (fluid.getFluid() != FluidRegistry.WATER || fluid.amount == this.tank.getCapacity())) {
                    return;
                }
                World world = this.holder.func_145831_w();
                IBlockState state = world.func_180495_p(offset = this.holder.func_174877_v().func_177972_a(this.side));
                if (state == BlockStates.WATER_LEVEL_0) {
                    EnumFacing facing;
                    IBlockState blockState;
                    int numWater = 0;
                    EnumSet<EnumFacing> enumFacings = FacingHelper.horizontalOrthogonal.get(this.side);
                    Iterator iterator = enumFacings.iterator();
                    while (iterator.hasNext() && ((blockState = world.func_180495_p(offset.func_177972_a(facing = (EnumFacing)iterator.next()))) != BlockStates.WATER_LEVEL_0 || (numWater = (int)((byte)(numWater + 1))) != 2)) {
                    }
                    if (numWater >= 2 && ForgeEventFactory.canCreateFluidSource((World)world, (BlockPos)offset, (IBlockState)state, (boolean)true)) {
                        this.tank.fill(new FluidStack(FluidRegistry.WATER, 200), true);
                    }
                }
            }
        }
    }

    @Override
    protected boolean processPosition(BlockPos pingPos, IFluidHandler attached, IPipe pipe) {
        if (pipe == null) {
            return true;
        }
        int maxTransfer = this.tank.getFluidAmount();
        if (maxTransfer >= 0) {
            for (EnumFacing facing : FacingHelper.getRandomFaceOrder()) {
                int fill;
                IFluidHandler capability = pipe.getCapability((IBlockAccess)this.holder.func_145831_w(), pingPos, facing, CapGetter.FluidHandler);
                if (capability == null || (fill = capability.fill(this.tank.getFluid(), false)) <= 0 || (maxTransfer -= capability.fill(this.tank.drain(fill = Math.min(fill, maxTransfer), true), true)) != 0) continue;
                break;
            }
        }
        if (this.tank.isEmpty()) {
            this.ping.resetPosition();
            return false;
        }
        return true;
    }

    @Override
    public IFluidHandler getHandler(TileEntity tile) {
        return CapGetter.FluidHandler.getInterface((ICapabilityProvider)tile, this.side.func_176734_d());
    }

    @Override
    public GrocketType getType() {
        return GrocketType.TRANSFER_NODE_FLUIDS;
    }

    @Override
    public boolean onActivated(EntityPlayer playerIn, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!this.holder.func_145831_w().field_72995_K) {
            this.holder.openGui(playerIn, this);
        }
        return true;
    }

    @Override
    public <T> T getInterface(TileEntity tileEntity, CapGetter<T> capability) {
        IFluidHandler handler;
        if (capability == CapGetter.FluidHandler && (handler = CapGetter.FluidHandler.getInterface((ICapabilityProvider)tileEntity, this.side.func_176734_d())) != null) {
            return (T)new IFluidHandler(){

                public IFluidTankProperties[] getTankProperties() {
                    return handler.getTankProperties();
                }

                public int fill(FluidStack resource, boolean doFill) {
                    return 0;
                }

                @Nullable
                public FluidStack drain(FluidStack resource, boolean doDrain) {
                    if (resource == null || !TransferNodeFluid.this.filter.matches(resource)) {
                        return null;
                    }
                    return handler.drain(resource, doDrain);
                }

                @Nullable
                public FluidStack drain(int maxDrain, boolean doDrain) {
                    FluidStack drain = handler.drain(maxDrain, false);
                    if (drain == null || !TransferNodeFluid.this.filter.matches(drain)) {
                        return null;
                    }
                    return doDrain ? handler.drain(maxDrain, true) : drain;
                }
            };
        }
        return super.getInterface(tileEntity, capability);
    }

    @Override
    public DynamicContainer getDynamicContainer(int ID2, EntityPlayer player, World world, int x, int y, int z) {
        return new TransferNodeFluidContainer(player);
    }

    public class TransferNodeFluidContainer
    extends DynamicContainerTile {
        public TransferNodeFluidContainer(EntityPlayer player) {
            super(TransferNodeFluid.this.holder, 9, 64);
            this.addTitle("Transfer Node");
            int numUpgradeSlots = TransferNodeFluid.this.upgradeHandler.getSlots();
            for (int i = 0; i < numUpgradeSlots; ++i) {
                this.addWidget(new WidgetSlotItemHandler((IItemHandler)TransferNodeFluid.this.upgradeHandler, i, 85 + i * 18 - 9 * numUpgradeSlots, 80));
            }
            this.addWidget(TransferNodeFluid.this.filter.newSlot(4, 80));
            this.addWidget(new WidgetFluidIndicator(76, 31){

                @Override
                public FluidStack getFluid() {
                    return TransferNodeFluid.this.tank.getFluid();
                }

                @Override
                public float getFillPercent() {
                    return 1.0f;
                }
            });
            this.addWidget((IWidget)new WidgetTextData(4, 54, 154){

                @Override
                public void addToDescription(XUPacketBuffer packet) {
                    packet.writeFluidStack(TransferNodeFluid.this.tank.getFluid());
                    packet.writeInt(TransferNodeFluid.this.tank.getFluidAmount());
                    packet.writeInt(TransferNodeFluid.this.tank.getCapacity());
                }

                @Override
                protected String constructText(XUPacketBuffer packet) {
                    FluidStack stack = packet.readFluidStack();
                    int i = packet.readInt();
                    int n = packet.readInt();
                    if (stack == null) {
                        return null;
                    }
                    return String.format("%s: %s/%s mB", stack.getLocalizedName(), i, n);
                }
            }.setAlign(0));
            this.addWidget(new TransferNodeBase.WidgetPingPosition(4, 68));
            this.cropAndAddPlayerSlots(player.field_71071_by);
            this.validate();
        }
    }

    public static class Retrieve
    extends TransferNodeFluid {
        @Override
        protected boolean shouldAdvance() {
            return !this.tank.isFull();
        }

        @Override
        protected void processBuffer(@Nullable IFluidHandler attached) {
            int fill;
            FluidStack drain;
            if (attached != null && (drain = this.tank.getFluid()) != null && (fill = attached.fill(drain, false)) > 0) {
                attached.fill(this.tank.drain(fill, true), true);
            }
        }

        @Override
        protected boolean processPosition(BlockPos pingPos, IFluidHandler attached, IPipe pipe) {
            if (pipe == null || this.tank.isFull()) {
                return true;
            }
            int maxTransfer = this.getDrainAmount();
            for (EnumFacing facing : FacingHelper.getRandomFaceOrder()) {
                int fill;
                IFluidHandler capability = pipe.getCapability((IBlockAccess)this.holder.func_145831_w(), pingPos, facing, CapGetter.FluidHandler);
                if (capability == null || (fill = this.tank.fill(capability.drain(maxTransfer, false), false)) <= 0 || (maxTransfer -= this.tank.fill(capability.drain(fill = Math.min(fill, maxTransfer), true), true)) != 0) continue;
                break;
            }
            return true;
        }

        @Override
        public GrocketType getType() {
            return GrocketType.TRANSFER_NODE_FLUIDS_RETRIEVE;
        }
    }
}

