/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.transfernodes;

import com.rwtema.extrautils2.backend.XUBlock;
import com.rwtema.extrautils2.backend.XUBlockStateCreator;
import com.rwtema.extrautils2.backend.entries.XU2Entries;
import com.rwtema.extrautils2.backend.model.BoxModel;
import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.power.Freq;
import com.rwtema.extrautils2.power.PowerManager;
import com.rwtema.extrautils2.tile.TilePower;
import com.rwtema.extrautils2.transfernodes.BlockTransferPipe;
import com.rwtema.extrautils2.transfernodes.Grocket;
import com.rwtema.extrautils2.transfernodes.TileTransferHolder;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockTransferHolder
extends XUBlock {
    private static IBlockState holderState;

    public BlockTransferHolder() {
        super(Material.field_151571_B, MapColor.field_151665_m);
        holderState = this.func_176223_P();
    }

    public static boolean placePipe(World world, BlockPos pos, EntityPlayer player) {
        IBlockState blockState = world.func_180495_p(pos);
        if (blockState == holderState) {
            TileEntity tile = world.func_175625_s(pos);
            if (!(tile instanceof TileTransferHolder)) {
                world.func_175713_t(pos);
                tile = world.func_175625_s(pos);
            }
            TileTransferHolder holder = (TileTransferHolder)tile;
            if (!world.field_72995_K && !PowerManager.canUse(player, holder)) {
                return false;
            }
            if (holder.centerPipe != null) {
                return false;
            }
            holder.centerPipe = BlockTransferPipe.stateBuilder.defaultState;
            holder.markForUpdate();
            return true;
        }
        return blockState.func_177230_c().func_176200_f((IBlockAccess)world, pos) && world.func_175656_a(pos, (IBlockState)BlockTransferPipe.stateBuilder.defaultState);
    }

    public static boolean placeGrocket(EntityPlayer player, World world, BlockPos pos, Grocket grocket, EnumFacing facing) {
        IBlockState blockState = world.func_180495_p(pos);
        if (blockState == holderState) {
            TileEntity tile = world.func_175625_s(pos);
            if (!(tile instanceof TileTransferHolder)) {
                world.func_175713_t(pos);
                tile = world.func_175625_s(pos);
            }
            TileTransferHolder holder = (TileTransferHolder)tile;
            if (!world.field_72995_K && !PowerManager.canUse(player, holder)) {
                return false;
            }
            if (holder.grockets[facing.ordinal()] != null) {
                return false;
            }
            holder.addGrocket(player, grocket, facing);
            holder.markForUpdate();
            return true;
        }
        if (BlockTransferPipe.stateBuilder.genericPipeStates.contains(blockState)) {
            world.func_175656_a(pos, holderState);
            world.func_175713_t(pos);
            TileTransferHolder tileEntity = (TileTransferHolder)world.func_175625_s(pos);
            if (!world.field_72995_K) {
                tileEntity.frequency = Freq.getBasePlayerFreq((EntityPlayerMP)player);
            }
            tileEntity.addGrocket(player, grocket, facing);
            tileEntity.centerPipe = blockState;
            tileEntity.markForUpdate();
            return true;
        }
        if (blockState.func_177230_c().func_176200_f((IBlockAccess)world, pos)) {
            world.func_175656_a(pos, holderState);
            TileTransferHolder tileEntity = (TileTransferHolder)world.func_175625_s(pos);
            if (!world.field_72995_K) {
                tileEntity.frequency = Freq.getBasePlayerFreq((EntityPlayerMP)player);
            }
            tileEntity.addGrocket(player, grocket, facing);
            tileEntity.markForUpdate();
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    protected XUBlockStateCreator createBlockState() {
        return new XUBlockStateCreator.Builder(this).addMetaProperty(TilePower.ENABLED_STATE).build();
    }

    public boolean isToolEffective(String type, @Nonnull IBlockState state) {
        return true;
    }

    public boolean canHarvestBlock(IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player) {
        return true;
    }

    @Override
    @Nonnull
    public BoxModel getWorldModel(IBlockAccess world, BlockPos pos, @Nullable IBlockState state) {
        TileEntity tileEntity;
        if (world != null && pos != null && (tileEntity = world.func_175625_s(pos)) instanceof TileTransferHolder) {
            TileTransferHolder transferHolder = (TileTransferHolder)tileEntity;
            BoxModel worldModel = transferHolder.worldModel;
            if (worldModel != null) {
                return worldModel;
            }
            worldModel = new BoxModel();
            IBlockState centerPipe = transferHolder.centerPipe;
            if (centerPipe != null) {
                worldModel.addAll(((BlockTransferPipe)BlockTransferPipe.stateBuilder.mainBlock).getWorldModel(world, pos, centerPipe));
            }
            Grocket[] grockets = transferHolder.grockets;
            for (EnumFacing facing : EnumFacing.values()) {
                Grocket grocket = grockets[facing.ordinal()];
                if (grocket == null) continue;
                worldModel.addAll(grocket.getWorldModel(facing));
            }
            return worldModel;
        }
        return new BoxModel(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    @Override
    public BoxModel getRenderModel(IBlockAccess world, BlockPos pos, @Nullable IBlockState state) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileTransferHolder) {
            TileTransferHolder transferHolder = (TileTransferHolder)tileEntity;
            BoxModel worldModel = transferHolder.worldModel;
            if (worldModel != null) {
                return worldModel;
            }
            worldModel = new BoxModel();
            IBlockState centerPipe = transferHolder.centerPipe;
            if (centerPipe != null) {
                worldModel.addAll(((BlockTransferPipe)BlockTransferPipe.stateBuilder.mainBlock).getRenderModel(world, pos, centerPipe));
            }
            Grocket[] grockets = transferHolder.grockets;
            for (EnumFacing facing : EnumFacing.values()) {
                Grocket grocket = grockets[facing.ordinal()];
                if (grocket == null) continue;
                worldModel.addAll(grocket.getWorldModel(facing));
            }
            return worldModel;
        }
        return new BoxModel(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nonnull
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        return new TileTransferHolder();
    }

    @Override
    @Nonnull
    public BoxModel getInventoryModel(@Nullable ItemStack item) {
        return BoxModel.newStandardBlock("transfernodes/pipes");
    }

    @Override
    public void func_180657_a(@Nonnull World worldIn, EntityPlayer player, @Nonnull BlockPos pos, @Nonnull IBlockState state, TileEntity te, ItemStack stack) {
        if (te instanceof TileTransferHolder) {
            TileTransferHolder holder = (TileTransferHolder)te;
            if (holder.centerPipe != null) {
                BlockTransferHolder.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)XU2Entries.pipe.newStack());
            }
            for (Grocket grocket : holder.grockets) {
                if (grocket == null) continue;
                for (ItemStack itemStack : grocket.getDrops()) {
                    if (!StackHelper.isNonNull(itemStack)) continue;
                    BlockTransferHolder.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)itemStack);
                }
            }
        } else {
            super.func_180657_a(worldIn, player, pos, state, te, stack);
        }
    }

    @Override
    @Nonnull
    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, @Nonnull IBlockState state, int fortune) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileTransferHolder) {
            TileTransferHolder holder = (TileTransferHolder)tileEntity;
            if (holder.centerPipe != null) {
                list.add(XU2Entries.pipe.newStack());
            }
            for (Grocket grocket : holder.grockets) {
                if (grocket == null) continue;
                list.addAll(grocket.getDrops());
            }
        }
        return list;
    }

    public String func_149739_a() {
        return "tile.ExtraUtils2:pipe.pipe.container";
    }
}

