/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.tile;

import com.rwtema.extrautils2.blocks.BlockCreativeHarvest;
import com.rwtema.extrautils2.compatibility.BlockCompat;
import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.network.XUPacketBuffer;
import com.rwtema.extrautils2.tile.XUTile;
import com.rwtema.extrautils2.tile.tesr.ITESREnchantment;
import com.rwtema.extrautils2.utils.datastructures.NBTSerializable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileCreativeHarvest
extends XUTile
implements ITESREnchantment<TileCreativeHarvest> {
    public final NBTSerializable.NBTBlockState mimicState = this.registerNBT("state", new NBTSerializable.NBTBlockState());

    @Override
    public boolean shouldShowEnchantment() {
        return this.mimicState.value != null;
    }

    @Override
    public boolean onBlockActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (this.mimicState.value == null && playerIn.field_71075_bZ.field_75098_d) {
            if (worldIn.field_72995_K) {
                return true;
            }
            ItemStack stack = playerIn.func_184586_b(hand);
            if (StackHelper.isNonNull(stack) && stack.func_77973_b() instanceof ItemBlock) {
                ItemBlock itemblock = (ItemBlock)stack.func_77973_b();
                if (!(itemblock.field_150939_a instanceof BlockCreativeHarvest)) {
                    this.mimicState.value = BlockCompat.invokeGetStateForPlacement(itemblock.field_150939_a, worldIn, pos, side, hitX, hitY, hitZ, itemblock.func_77647_b(stack.func_77960_j()), playerIn, EnumHand.MAIN_HAND, stack);
                    this.func_70296_d();
                    this.markForUpdate();
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void addToDescriptionPacket(XUPacketBuffer packet) {
        if (this.mimicState.value == null) {
            packet.writeInt(-1);
        } else {
            Block block = this.mimicState.value.func_177230_c();
            packet.writeInt(Block.func_149682_b((Block)block));
            packet.writeByte(block.func_176201_c(this.mimicState.value));
        }
    }

    @Override
    public void handleDescriptionPacket(XUPacketBuffer packet) {
        int i = packet.readInt();
        this.mimicState.value = null;
        if (i >= 0) {
            IBlockState stateFromMeta;
            short meta = packet.readUnsignedByte();
            Block blockById = Block.func_149729_e((int)i);
            if (blockById != Blocks.field_150350_a && this.mimicState.value != (stateFromMeta = blockById.func_176203_a((int)meta))) {
                this.mimicState.value = stateFromMeta;
                this.markForUpdate();
            }
        }
    }
}

