/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.quarry;

import com.google.common.collect.ImmutableList;
import com.rwtema.extrautils2.backend.XUBlockStateCreator;
import com.rwtema.extrautils2.backend.XUBlockStatic;
import com.rwtema.extrautils2.backend.model.BoxModel;
import com.rwtema.extrautils2.backend.model.Textures;
import com.rwtema.extrautils2.textures.SpriteSub;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.IFluidBlock;

public class BlockSludge
extends XUBlockStatic {
    static final PropertyInteger DECAY_LEVEL = PropertyInteger.func_177719_a((String)"decay", (int)0, (int)3);
    public final int TICK_TIME = 128;

    public BlockSludge() {
        super(Material.field_151583_m);
        this.func_149711_c(0.0f);
    }

    @Override
    @Nonnull
    protected XUBlockStateCreator createBlockState() {
        return XUBlockStateCreator.builder(this).addWorldProperties(new IProperty[]{DECAY_LEVEL}).build();
    }

    @Nonnull
    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.BLOCK;
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        worldIn.func_180497_b(pos.func_185334_h(), (Block)this, 1 + worldIn.field_73012_v.nextInt(128), 0);
    }

    @Override
    public void neighborChangedBase(IBlockState state, World worldIn, BlockPos pos, Block neighborBlock) {
        super.neighborChangedBase(state, worldIn, pos, neighborBlock);
        worldIn.func_180497_b(pos, (Block)this, 128, 0);
    }

    public boolean isFluid(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return state.func_185904_a().func_76224_d() || state.func_177230_c() instanceof IFluidBlock;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (worldIn.field_72995_K) {
            return;
        }
        int i = (Integer)state.func_177229_b((IProperty)DECAY_LEVEL);
        if (this.isFluid(worldIn, pos.func_177977_b())) {
            worldIn.func_180501_a(pos.func_177977_b(), state, 3);
        }
        boolean waterNearby = false;
        boolean spread = false;
        block0: for (EnumFacing facing : EnumFacing.field_176754_o) {
            BlockPos offset = pos.func_177972_a(facing);
            if (!this.isFluid(worldIn, offset)) continue;
            waterNearby = true;
            if (this.isFluid(worldIn, offset.func_177984_a())) continue;
            BlockPos down = offset.func_177977_b();
            if (this.blocksWater(worldIn, down)) {
                worldIn.func_175656_a(offset, state);
                continue;
            }
            EnumFacing opposite = facing.func_176734_d();
            for (EnumFacing facing2 : EnumFacing.field_176754_o) {
                BlockPos offset1;
                if (facing2 == opposite || !this.blocksWater(worldIn, offset1 = offset.func_177972_a(facing2))) continue;
                worldIn.func_175656_a(offset, state);
                continue block0;
            }
        }
        if (!waterNearby) {
            waterNearby = this.isFluid(worldIn, pos.func_177984_a());
        }
        if (waterNearby) {
            return;
        }
        if (i == 3) {
            worldIn.func_175698_g(pos);
        } else {
            worldIn.func_175656_a(pos, state.func_177226_a((IProperty)DECAY_LEVEL, (Comparable)Integer.valueOf(i + 1)));
            worldIn.func_180497_b(pos, (Block)this, 128, 0);
        }
    }

    private boolean blocksWater(World worldIn, BlockPos offset1) {
        return worldIn.func_180495_p(offset1).func_177230_c() == this;
    }

    @Override
    @Nonnull
    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, @Nonnull IBlockState state, int fortune) {
        return ImmutableList.of();
    }

    @Override
    public void registerTextures() {
        for (int i = 0; i < 4; ++i) {
            Textures.textureNames.put("sludge_" + i, new SpriteSub("sludge", 0, i, 1, 4, 1));
        }
    }

    @Override
    public BoxModel getModel(IBlockState state) {
        return BoxModel.newStandardBlock("sludge_" + state.func_177229_b((IProperty)DECAY_LEVEL));
    }
}

