/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.items.itemmatching;

import com.google.common.collect.ImmutableList;
import com.rwtema.extrautils2.api.recipes.ICustomRecipeMatching;
import com.rwtema.extrautils2.backend.entries.IItemStackMaker;
import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.items.itemmatching.IMatcher;
import com.rwtema.extrautils2.items.itemmatching.MultiMatcher;
import com.rwtema.extrautils2.utils.datastructures.ItemRef;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class Matchers {
    public static IMatcher createMatcher(Object object, boolean crafting) {
        if (object == null) {
            return ItemRef.NULL;
        }
        if (object instanceof ItemStack) {
            return Matchers.matchItemStackIS((ItemStack)object, crafting);
        }
        if (object instanceof Block) {
            return Matchers.matchItemStackIS(new ItemStack((Block)object), crafting);
        }
        if (object instanceof Item) {
            return Matchers.matchItemStackIS(new ItemStack((Item)object), crafting);
        }
        if (object instanceof IItemStackMaker) {
            return Matchers.matchItemStackIS(((IItemStackMaker)object).newStack(), crafting);
        }
        if (object instanceof String) {
            List ores = OreDictionary.getOres((String)((String)object));
            ImmutableList.Builder builder = ImmutableList.builder();
            for (ItemStack ore : ores) {
                builder.add((Object)Matchers.matchItemStackIS(ore, crafting));
            }
            return new MultiMatcher((Collection<? extends IMatcher>)builder.build());
        }
        if (object instanceof List) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Object o : (List)object) {
                builder.add((Object)Matchers.createMatcher(o, crafting));
            }
            return new MultiMatcher((Collection<? extends IMatcher>)builder.build());
        }
        throw new IllegalArgumentException("Unable to process " + object);
    }

    private static IMatcher matchItemStackIS(ItemStack stack, boolean crafting) {
        if (crafting) {
            return Matchers.matchCrafting(stack);
        }
        return ItemRef.wrap(stack);
    }

    public static IMatcher matchCrafting(final ItemStack stack) {
        if (StackHelper.isNull(stack)) {
            return ItemRef.NULL;
        }
        Item item = stack.func_77973_b();
        if (item == StackHelper.nullItem()) {
            return ItemRef.NULL;
        }
        if (item instanceof ICustomRecipeMatching) {
            final ICustomRecipeMatching matching = (ICustomRecipeMatching)item;
            return new IMatcher(){

                @Override
                public boolean matchesItemStack(@Nullable ItemStack t) {
                    return matching.itemsMatch(t, stack);
                }
            };
        }
        return new IMatcher(){

            @Override
            public boolean matchesItemStack(@Nullable ItemStack t) {
                return t != null && OreDictionary.itemMatches((ItemStack)stack, (ItemStack)t, (boolean)false);
            }
        };
    }
}

