/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.items;

import com.google.common.collect.ImmutableList;
import com.rwtema.extrautils2.backend.XUItem;
import com.rwtema.extrautils2.backend.model.PassthruModelItem;
import com.rwtema.extrautils2.backend.model.Textures;
import com.rwtema.extrautils2.backend.model.UV;
import com.rwtema.extrautils2.lighting.ILight;
import com.rwtema.extrautils2.power.player.IPlayerPowerCreator;
import com.rwtema.extrautils2.power.player.PlayerPower;
import com.rwtema.extrautils2.utils.Lang;
import com.rwtema.extrautils2.utils.MCTimer;
import com.rwtema.extrautils2.utils.helpers.ColorHelper;
import com.rwtema.extrautils2.utils.helpers.QuadHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.vecmath.Matrix4f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector4f;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.vector.Vector3f;

public class ItemSunCrystal
extends XUItem {
    public static IPlayerPowerCreator creator = new IPlayerPowerCreator(){

        @Override
        public PlayerPower createPower(EntityPlayer player, ItemStack params) {
            return new PlayerLight(player);
        }
    };
    @SideOnly(value=Side.CLIENT)
    TextureAtlasSprite sprite;
    @SideOnly(value=Side.CLIENT)
    TextureAtlasSprite sprite2;
    @SideOnly(value=Side.CLIENT)
    TextureAtlasSprite gradient;
    @SideOnly(value=Side.CLIENT)
    List<BakedQuad> rays;
    float prevTime = -1.0f;
    @SideOnly(value=Side.CLIENT)
    Vector3f[] vecs;

    public ItemSunCrystal() {
        this.func_77656_e(250);
        this.func_77625_d(1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerTextures() {
        Textures.register("gradient", "sun_crystal", "sun_crystal2");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void postTextureRegister() {
        this.sprite = (TextureAtlasSprite)Textures.sprites.get((Object)"sun_crystal");
        this.sprite2 = (TextureAtlasSprite)Textures.sprites.get((Object)"sun_crystal2");
        this.gradient = (TextureAtlasSprite)Textures.sprites.get((Object)"gradient");
    }

    @Override
    public void getSubItemsBase(@Nonnull Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        subItems.add(new ItemStack(itemIn, 1, 0));
        subItems.add(new ItemStack(itemIn, 1, itemIn.func_77612_l()));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getBaseTexture() {
        return this.sprite;
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        ItemStack item = entityItem.func_92059_d();
        int itemDamage = item.func_77952_i();
        if (itemDamage > 0) {
            World worldObj = entityItem.field_70170_p;
            if (!worldObj.field_73011_w.func_177495_o()) {
                float f;
                float f1;
                BlockPos pos = new BlockPos(entityItem.field_70165_t, entityItem.func_174813_aQ().field_72338_b, entityItem.field_70161_v);
                if (!worldObj.func_175678_i(pos)) {
                    return false;
                }
                int i = worldObj.func_175642_b(EnumSkyBlock.SKY, pos) - worldObj.func_175657_ab();
                if ((i = Math.round((float)i * MathHelper.func_76134_b((float)(f += ((f1 = (f = worldObj.func_72929_e(1.0f)) < (float)Math.PI ? 0.0f : (float)Math.PI * 2) - f) * 0.2f)))) > 0 && (i >= 15 || worldObj.field_73012_v.nextInt(15) < i)) {
                    item.func_77964_b(itemDamage - 1);
                }
            }
        }
        return false;
    }

    @Override
    public boolean allowOverride() {
        return false;
    }

    @Override
    public int getMaxMetadata() {
        return 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addQuads(PassthruModelItem.ModelLayer model, ItemStack stack) {
        model.addSprite(this.sprite);
        TextureAtlasSprite sprite2 = this.sprite2;
        int progress = 255 - stack.func_77952_i() * 255 / stack.func_77958_k();
        int color = ColorHelper.makeAlphaWhite(progress);
        if (this.rays == null) {
            this.rays = new ArrayList<BakedQuad>();
            this.vecs = new Vector3f[]{new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(0.0f, 0.0f, 1.0f), new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(0.0f, 0.0f, 1.0f)};
        }
        this.rays.clear();
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)QuadHelper.buildQuad(DefaultVertexFormats.field_176599_b, TRSRTransformation.identity(), EnumFacing.SOUTH, -1, 0.0f, 0.0f, 0.46875f, sprite2.func_94209_e(), sprite2.func_94210_h(), 0.0f, 1.0f, 0.46875f, sprite2.func_94209_e(), sprite2.func_94206_g(), 1.0f, 1.0f, 0.46875f, sprite2.func_94212_f(), sprite2.func_94206_g(), 1.0f, 0.0f, 0.46875f, sprite2.func_94212_f(), sprite2.func_94210_h(), color, sprite2));
        builder.add((Object)QuadHelper.buildQuad(DefaultVertexFormats.field_176599_b, TRSRTransformation.identity(), EnumFacing.NORTH, -1, 0.0f, 0.0f, 0.53125f, sprite2.func_94209_e(), sprite2.func_94210_h(), 1.0f, 0.0f, 0.53125f, sprite2.func_94212_f(), sprite2.func_94210_h(), 1.0f, 1.0f, 0.53125f, sprite2.func_94212_f(), sprite2.func_94206_g(), 0.0f, 1.0f, 0.53125f, sprite2.func_94209_e(), sprite2.func_94206_g(), color, sprite2));
        this.rays.addAll((Collection<BakedQuad>)builder.build());
        Random rand = new Random(425L + (long)System.identityHashCode(stack));
        Matrix4f matrix = new Matrix4f();
        matrix.setIdentity();
        Vector4f b = new Vector4f();
        Vector4f c = new Vector4f();
        Vector4f d = new Vector4f();
        for (int i = 0; i < 16; ++i) {
            for (Vector3f vec : this.vecs) {
                QuadHelper.rotate((float)Math.PI * 2 * rand.nextFloat() + MCTimer.renderTimer / 360.0f, vec, matrix, matrix);
            }
            float r = (1.0f + rand.nextFloat() * 0.5f) * (float)progress / 255.0f;
            QuadHelper.rotate(MCTimer.renderTimer / 180.0f, new Vector3f(0.0f, 1.0f, 0.0f), matrix, matrix);
            b.set(0.0f, 0.126f * r, 0.5f * r, 1.0f);
            c.set(0.0f, -0.126f * r, 0.5f * r, 1.0f);
            d.set(0.0f, 0.0f, 0.6f * r, 1.0f);
            matrix.transform((Tuple4f)b);
            matrix.transform((Tuple4f)c);
            matrix.transform((Tuple4f)d);
            this.rays.add(QuadHelper.createBakedQuad(new UV[]{new UV(0.5f, 0.5f, 0.5f, 0.5f, 1.0f), new UV(0.5f + b.x, 0.5f + b.y, 0.5f + b.z, 1.0f, 0.0f), new UV(0.5f + d.x, 0.5f + d.y, 0.5f + d.z, 0.5f, 0.0f), new UV(0.5f + c.x, 0.5f + c.y, 0.5f + c.z, 0.0f, 0.0f)}, "gradient", false, -1));
            this.rays.add(QuadHelper.createBakedQuad(new UV[]{new UV(0.5f, 0.5f, 0.5f, 0.5f, 1.0f), new UV(0.5f + c.x, 0.5f + c.y, 0.5f + c.z, 0.0f, 0.0f), new UV(0.5f + d.x, 0.5f + d.y, 0.5f + d.z, 0.5f, 0.0f), new UV(0.5f + b.x, 0.5f + b.y, 0.5f + b.z, 1.0f, 0.0f)}, "gradient", false, -1));
        }
        model.addAllQuads(this.rays);
    }

    @Nonnull
    public String func_77667_c(ItemStack stack) {
        if (stack.func_77952_i() == stack.func_77958_k()) {
            return super.func_77667_c(stack) + ".empty";
        }
        return super.func_77667_c(stack);
    }

    public static class PlayerLight
    extends PlayerPower
    implements ILight {
        final double RADIUS = 5.0;
        Vec3d center;

        public PlayerLight(@Nonnull EntityPlayer player) {
            super(player);
            this.loadPlayerCenter(player);
        }

        @Override
        public World getLightWorld() {
            return this.getPlayer().field_70170_p;
        }

        @Override
        public float getLightOffset(BlockPos pos, EnumSkyBlock type) {
            double dx = (double)pos.func_177958_n() - this.center.field_72450_a;
            double dy = (double)pos.func_177956_o() - this.center.field_72448_b;
            double dz = (double)pos.func_177952_p() - this.center.field_72449_c;
            double t = 1.0 - Math.sqrt(dx * dx + dy * dy + dz * dz) / 5.0;
            return MathHelper.func_76125_a((int)((int)(t * 16.0)), (int)0, (int)15);
        }

        @Override
        public EnumSkyBlock[] getLightType() {
            return new EnumSkyBlock[]{EnumSkyBlock.BLOCK};
        }

        @Override
        public float power(EntityPlayer playerMP) {
            return 0.0f;
        }

        @Override
        public void powerChanged(boolean powered) {
        }

        @Override
        public String getName() {
            return Lang.translate("FlashLight");
        }

        @Override
        public void tick() {
            EntityPlayer player = this.getPlayer();
            this.loadPlayerCenter(player);
        }

        public void loadPlayerCenter(EntityPlayer player) {
            this.center = new Vec3d(player.field_70165_t, player.field_70163_u, player.field_70161_v);
        }

        @Override
        public void tickClient() {
            Vec3d pos = this.center;
            this.tick();
            if (this.center.func_72438_d(pos) > 0.01) {
                World world = this.getPlayer().field_70170_p;
                world.func_147458_c((int)(this.center.field_72450_a - 5.0), (int)(this.center.field_72448_b - 5.0), (int)(this.center.field_72449_c - 5.0), (int)(this.center.field_72450_a + 5.0), (int)(this.center.field_72448_b + 5.0), (int)(this.center.field_72449_c + 5.0));
            } else {
                this.center = pos;
            }
        }
    }
}

