/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.enchants;

import com.google.common.collect.Sets;
import com.rwtema.extrautils2.compatibility.CompatHelper;
import com.rwtema.extrautils2.utils.Lang;
import java.util.HashSet;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public abstract class XUEnchantment
extends Enchantment {
    public final String stripText;
    public final HashSet<Enchantment> blackList = new HashSet();
    private final int maxLevel;
    private int minEnchantLevel = 1;

    public XUEnchantment(String name, int maxLevel, Enchantment.Rarity rarityIn, EnumEnchantmentType typeIn, EntityEquipmentSlot ... slots) {
        super(rarityIn, typeIn, slots);
        this.maxLevel = maxLevel;
        this.stripText = "xu." + Lang.stripText(name);
        Lang.translate("enchantment." + this.stripText, name);
        this.func_77322_b(this.stripText);
    }

    public static EnumEnchantmentType getOrRegisterEnchantmentType(String name) {
        for (EnumEnchantmentType type : EnumEnchantmentType.values()) {
            if (!name.equalsIgnoreCase(type.name())) continue;
            return type;
        }
        return CompatHelper.addEnchantmentType(name);
    }

    public static void makeMutuallyExclusive(XUEnchantment ... enchantments) {
        HashSet set = Sets.newHashSet((Object[])enchantments);
        for (XUEnchantment enchantment : enchantments) {
            enchantment.blackList.addAll(set);
        }
    }

    public void register() {
        Enchantment.field_185264_b.func_177775_a(-1, (Object)new ResourceLocation("extrautils2", this.stripText), (Object)this);
    }

    public XUEnchantment setMinEnchantLevel(int minEnchantLevel) {
        this.minEnchantLevel = minEnchantLevel;
        return this;
    }

    public abstract boolean canApplyAtEnchantingTable(ItemStack var1);

    public int func_77325_b() {
        return this.maxLevel;
    }

    public int func_77321_a(int enchantmentLevel) {
        return this.minEnchantLevel + enchantmentLevel * (30 - this.minEnchantLevel) / this.maxLevel;
    }

    public int func_77317_b(int enchantmentLevel) {
        return this.func_77321_a(enchantmentLevel + 1) + 1;
    }

    public boolean func_77326_a(Enchantment enchantment) {
        return this != enchantment && !this.blackList.contains(enchantment);
    }
}

